/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNVSwapGroupNEWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getGL2ES2();
        Assert.assertNotNull(glp);
        caps = new GLCapabilities(glp);
        Assert.assertNotNull(caps);
        width = 256;
        height = 256;
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, final int n3, final int n4) {
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2);
        gLWindow.setSize(width, height);
        GearsES2 gearsES2 = new GearsES2(1);
        gLWindow.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                int[] nArray = new int[]{-1, -1};
                GLContext gLContext = gLAutoDrawable.getContext();
                boolean bl = gLContext.queryMaxSwapGroups(nArray, 0, nArray, 1);
                System.err.println("swap group max groups " + nArray[0] + ", barriers " + nArray[0] + ", " + bl);
                if (nArray[0] >= n3) {
                    System.err.println("swap group joing 1: " + gLContext.joinSwapGroup(n3));
                    if (nArray[1] >= n4) {
                        System.err.println("swap group bind 1-1: " + gLContext.bindSwapBarrier(n3, n4));
                    }
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n32, int n42) {
            }
        });
        gLWindow.addGLEventListener(gearsES2);
        animator.add(gLWindow);
        gLWindow.setVisible(true);
        gLWindow.setTopLevelPosition(n, n2);
        return gLWindow;
    }

    @Test
    public void test01() throws InterruptedException {
        Animator animator = new Animator(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, 9999, 9999);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator, width + insetsImmutable.getTotalWidth(), 0, 9999, 9999);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestNVSwapGroupNEWT.class.getName());
    }

    static {
        duration = 500L;
    }
}

