/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.junit.util.JunitTracer;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLTestUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    static boolean waitForKey = false;
    volatile int szStep = 2;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get(string));
    }

    static void setGLCanvasSize(final Frame frame, final GLCanvas gLCanvas, final int n, final int n2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Dimension dimension = new Dimension(n, n2);
                    gLCanvas.setMinimumSize(dimension);
                    gLCanvas.setPreferredSize(dimension);
                    gLCanvas.setSize(dimension);
                    frame.pack();
                    frame.validate();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    void doTest(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        if (gLCapabilitiesImmutable.isOnscreen() && JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("onscreen layer n/a");
            return;
        }
        if (!gLCapabilitiesImmutable.isOnscreen() && !JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("offscreen layer n/a");
            return;
        }
        System.out.println("Requested  GL Caps: " + gLCapabilitiesImmutable);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilitiesImmutable.getGLProfile());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, gLDrawableFactory, null);
        System.out.println("Expected   GL Caps: " + gLCapabilitiesImmutable2);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilitiesImmutable);
        Assert.assertNotNull(gLCanvas);
        Dimension dimension = new Dimension(200 * this.szStep, 150 * this.szStep);
        gLCanvas.setMinimumSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        gLCanvas.setSize(dimension);
        final Frame frame = new Frame(this.getSimpleTestName("."));
        Assert.assertNotNull(frame);
        frame.add(gLCanvas);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLCanvas, true, null));
        Assert.assertTrue(GLTestUtil.waitForRealized(gLCanvas, true, null));
        System.out.println("Window: " + gLCanvas.getClass().getName());
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLCanvas.getChosenGLCapabilities();
        System.out.println("Window Caps Pre_GL: " + gLCapabilitiesImmutable3);
        Assert.assertNotNull(gLCapabilitiesImmutable3);
        Assert.assertTrue(gLCapabilitiesImmutable3.getGreenBits() > 5);
        Assert.assertTrue(gLCapabilitiesImmutable3.getBlueBits() > 5);
        Assert.assertTrue(gLCapabilitiesImmutable3.getRedBits() > 5);
        gLCanvas.display();
        Object object = gLCanvas.getDelegatedDrawable();
        Assert.assertNotNull(object);
        System.out.println("Drawable    Pre-GL(0): " + object.getClass().getName() + ", " + object.getNativeSurface().getClass().getName());
        System.out.println("Window Caps PostGL   : " + gLCanvas.getChosenGLCapabilities());
        System.out.println("Drawable   Post-GL(1): " + gLCanvas.getClass().getName() + ", " + gLCanvas.getNativeSurface().getClass().getName());
        object = gLCanvas.getChosenGLCapabilities();
        System.out.println("Chosen     GL Caps(1): " + object);
        Assert.assertNotNull(object);
        Assert.assertTrue(object.getGreenBits() > 5);
        Assert.assertTrue(object.getBlueBits() > 5);
        Assert.assertTrue(object.getRedBits() > 5);
        Assert.assertTrue(object.getDepthBits() > 4);
        Assert.assertEquals(gLCapabilitiesImmutable2.isOnscreen(), object.isOnscreen());
        Assert.assertEquals(gLCapabilitiesImmutable2.isFBO(), object.isFBO());
        Assert.assertEquals(gLCapabilitiesImmutable2.isPBuffer(), object.isPBuffer());
        Assert.assertEquals(gLCapabilitiesImmutable2.isBitmap(), object.isBitmap());
        Object object2 = gLCanvas.getContext();
        System.out.println("Chosen     GL CTX (2): " + ((GLContext)object2).getGLVersion());
        Assert.assertNotNull(object2);
        Assert.assertTrue(((GLContext)object2).isCreated());
        System.out.println("Chosen     GL Caps(2): " + gLCanvas.getChosenGLCapabilities());
        System.out.println("Drawable   Post-GL(2): " + gLCanvas.getClass().getName() + ", " + gLCanvas.getNativeSurface().getClass().getName());
        gLCanvas.addGLEventListener(gLEventListener);
        object2 = new UITestCase.SnapshotGLEventListener(this);
        gLCanvas.addGLEventListener((GLEventListener)object2);
        gLCanvas.display();
        int[] nArray = gLCanvas.getNativeSurface().convertToPixelUnits(new int[]{200 * this.szStep, 150 * this.szStep});
        Assert.assertTrue("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight(), GLTestUtil.waitForSize(gLCanvas, nArray[0], nArray[1], null));
        ((UITestCase.SnapshotGLEventListener)object2).setMakeSnapshot();
        gLCanvas.display();
        this.szStep = 1;
        TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.setGLCanvasSize(frame, gLCanvas, 200 * this.szStep, 150 * this.szStep);
        nArray[0] = 200 * this.szStep;
        nArray[1] = 150 * this.szStep;
        gLCanvas.getNativeSurface().convertToPixelUnits(nArray);
        Assert.assertTrue("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight(), GLTestUtil.waitForSize(gLCanvas, nArray[0], nArray[1], null));
        gLCanvas.display();
        ((UITestCase.SnapshotGLEventListener)object2).setMakeSnapshot();
        gLCanvas.display();
        this.szStep = 4;
        TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.setGLCanvasSize(frame, gLCanvas, 200 * this.szStep, 150 * this.szStep);
        nArray[0] = 200 * this.szStep;
        nArray[1] = 150 * this.szStep;
        gLCanvas.getNativeSurface().convertToPixelUnits(nArray);
        Assert.assertTrue("Surface Size not reached: Expected " + nArray[0] + "x" + nArray[1] + ", Is " + gLCanvas.getSurfaceWidth() + "x" + gLCanvas.getSurfaceHeight(), GLTestUtil.waitForSize(gLCanvas, nArray[0], nArray[1], null));
        gLCanvas.display();
        ((UITestCase.SnapshotGLEventListener)object2).setMakeSnapshot();
        gLCanvas.display();
        Thread.sleep(50L);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove(gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        System.out.println("Fin: " + gLCanvas);
    }

    @Test
    public void testGL2OnScreenDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenPbuffer() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        if (waitForKey) {
            JunitTracer.waitForKey("Start");
        }
        JUnitCore.main(TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.class.getName());
    }

    static interface MyGLEventListener
    extends GLEventListener {
        public void setMakeSnapshot();
    }
}

