/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.FBOMix2DemosES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NewtTestUtil;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestFBOMix2DemosES2NEWT
extends UITestCase {
    static long duration = 1000L;
    static int swapInterval = 1;
    static boolean showFPS = false;
    static boolean forceES2 = false;
    static boolean doRotate = true;
    static boolean demo0Only = false;
    static int globalNumSamples = 0;
    static boolean manual = false;

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n) throws InterruptedException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        final GLWindow gLWindow = GLWindow.create(gLCapabilitiesImmutable);
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle("Gears NEWT Test (translucent " + !gLCapabilitiesImmutable.isBackgroundOpaque() + "), swapInterval " + swapInterval);
        if (manual) {
            gLWindow.setSize(512, 512);
        } else {
            gLWindow.setSize(128, 128);
        }
        final FBOMix2DemosES2 fBOMix2DemosES2 = new FBOMix2DemosES2(swapInterval);
        fBOMix2DemosES2.setMSAA(n);
        fBOMix2DemosES2.setDoRotation(doRotate);
        fBOMix2DemosES2.setDemo0Only(demo0Only);
        gLWindow.addGLEventListener(fBOMix2DemosES2);
        gLWindow.addGLEventListener(new GLEventListener(){
            int i = 0;
            int c = 0;
            int origS;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                this.origS = fBOMix2DemosES2.getMSAA();
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (manual) {
                    return;
                }
                final int n = gLAutoDrawable.getSurfaceWidth();
                final int n2 = gLAutoDrawable.getSurfaceHeight();
                ++this.c;
                if (n < 800) {
                    System.err.println("XXX: " + n + "x" + n2 + ", c " + this.c);
                    if (0 == this.c % 3) {
                        TestFBOMix2DemosES2NEWT.this.snapshot(this.i++, "msaa" + fBOMix2DemosES2.getMSAA(), gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                    }
                    if (3 == this.c) {
                        fBOMix2DemosES2.setMSAA(4);
                    } else if (6 == this.c) {
                        new InterruptSource.Thread(){

                            @Override
                            public void run() {
                                gLWindow.setSize(n + 64, n2 + 64);
                            }
                        }.start();
                    } else if (9 == this.c) {
                        fBOMix2DemosES2.setMSAA(8);
                    } else if (12 == this.c) {
                        fBOMix2DemosES2.setMSAA(0);
                    } else if (15 == this.c) {
                        new InterruptSource.Thread(){

                            @Override
                            public void run() {
                                gLWindow.setSize(n + 128, n2 + 128);
                            }
                        }.start();
                    } else if (18 == this.c) {
                        this.c = 0;
                        new InterruptSource.Thread(){

                            @Override
                            public void run() {
                                gLWindow.setSize(n + 256, n2 + 256);
                                fBOMix2DemosES2.setMSAA(origS);
                            }
                        }.start();
                    }
                }
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator(gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
            }

            @Override
            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight());
            }
        });
        gLWindow.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                System.err.println("*** " + keyEvent);
                if (keyEvent.getKeyChar() == 'f') {
                    new InterruptSource.Thread(){

                        @Override
                        public void run() {
                            System.err.println("[set fullscreen  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setFullscreen(!gLWindow.isFullscreen());
                            System.err.println("[set fullscreen post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'd') {
                    fBOMix2DemosES2.setDemo0Only(!fBOMix2DemosES2.getDemo0Only());
                } else {
                    int n = keyEvent.getKeyChar() - 48;
                    System.err.println("*** " + n);
                    if (0 <= n && n <= 8) {
                        System.err.println("MSAA: " + fBOMix2DemosES2.getMSAA() + " -> " + n);
                        fBOMix2DemosES2.setMSAA(n);
                    }
                }
            }
        });
        animator.start();
        gLWindow.setVisible(true);
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getSurfaceWidth() + "x" + gLWindow.getSurfaceHeight() + ", " + gLWindow.getInsets());
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        Assert.assertFalse(animator.isAnimating());
        Assert.assertFalse(animator.isStarted());
        gLWindow.destroy();
        Assert.assertEquals(true, NewtTestUtil.waitForRealized(gLWindow, false, null));
    }

    @Test
    public void test00_Manual() throws InterruptedException {
        if (manual) {
            GLCapabilities gLCapabilities = new GLCapabilities(forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2());
            gLCapabilities.setAlphaBits(1);
            this.runTestGL(gLCapabilities, globalNumSamples);
        }
    }

    @Test
    public void test01_startMSAA0() throws InterruptedException {
        if (manual) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2());
        gLCapabilities.setAlphaBits(1);
        this.runTestGL(gLCapabilities, 0);
    }

    @Test
    public void test02_startMSAA4() throws InterruptedException {
        if (manual) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2());
        gLCapabilities.setAlphaBits(1);
        this.runTestGL(gLCapabilities, 4);
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = false;
        manual = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-samples")) {
                globalNumSamples = MiscUtils.atoi(stringArray[++i], globalNumSamples);
                continue;
            }
            if (stringArray[i].equals("-norotate")) {
                doRotate = false;
                continue;
            }
            if (stringArray[i].equals("-demo0Only")) {
                demo0Only = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manual = true;
        }
        System.err.println("swapInterval " + swapInterval);
        System.err.println("forceES2 " + forceES2);
        System.err.println("manual " + manual);
        if (bl) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main(TestFBOMix2DemosES2NEWT.class.getName());
    }
}

