/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.graph.FontSet01;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWTBugXXXX
extends UITestCase {
    static long duration = 100L;
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static boolean mainRun = false;
    static boolean useMSAA = true;
    static boolean onlyIssues = false;
    static final float fontSize = 24.0f;
    private static final String issues = "m M n u 8 g q Q";
    private GLReadBufferUtil screenshot;
    int lastRow = -1;
    private int screenshot_num = 0;

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = TestTextRendererNEWTBugXXXX.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-noMSAA")) {
                useMSAA = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (!stringArray[i].equals("-gl3")) continue;
            forceGL3 = true;
        }
        String string = TestTextRendererNEWTBugXXXX.class.getName();
        JUnitCore.main(string);
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void test00All() throws InterruptedException, GLException, IOException {
        this.testTextRendererImpl(FontSet01.getSet01(), 2, 4, false);
    }

    @Test
    public void test01OnlyIssues() throws InterruptedException, GLException, IOException {
        this.testTextRendererImpl(FontSet01.getSet01(), 2, 4, true);
    }

    void testTextRendererImpl(Font[] fontArray, int n, int n2, boolean bl) throws InterruptedException, GLException, IOException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get("GL3") : (forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        if (0 < n2 && !Region.isVBAA(n)) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n2);
        }
        gLCapabilities.setOnscreen(false);
        System.err.println("Requested: " + gLCapabilities);
        System.err.println("Requested: " + Region.getRenderModeString(n));
        int n3 = 25 * (bl ? 3 : 6) * fontArray.length;
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(gLCapabilities, 800, n3, true);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        Assert.assertEquals(0L, gL2ES2.glGetError());
        System.err.println("Chosen: " + windowContext.window.getChosenCapabilities());
        RegionRenderer regionRenderer = RegionRenderer.create(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
        regionRenderer.setHintBits(2);
        TextRegionUtil textRegionUtil = new TextRegionUtil(n);
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        regionRenderer.init(gL2ES2);
        regionRenderer.setColorStatic(0.1f, 0.1f, 0.1f, 1.0f);
        this.screenshot = new GLReadBufferUtil(false, false);
        gL2ES2.glViewport(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
        regionRenderer.reshapeOrtho(gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), 0.1f, 1000.0f);
        int[] nArray = new int[]{n2};
        gL2ES2.glClear(16640);
        for (int i = 0; i < fontArray.length; ++i) {
            Font font = fontArray[i];
            this.renderString(gLDrawable, gL2ES2, regionRenderer, font, textRegionUtil, font.getFullFamilyName() + ": " + issues, 0, 0 == i ? 0 : -1, -1000, nArray);
            if (!bl) {
                this.renderString(gLDrawable, gL2ES2, regionRenderer, font, textRegionUtil, "012345678901234567890123456789", 0, -1, -1000, nArray);
                this.renderString(gLDrawable, gL2ES2, regionRenderer, font, textRegionUtil, "abcdefghijklmnopqrstuvwxyz", 0, -1, -1000, nArray);
                this.renderString(gLDrawable, gL2ES2, regionRenderer, font, textRegionUtil, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", 0, -1, -1000, nArray);
            }
            this.renderString(gLDrawable, gL2ES2, regionRenderer, font, textRegionUtil, "", 0, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, font, textRegionUtil, "", 0, -1, -1000, nArray);
        }
        gLDrawable.swapBuffers();
        this.printScreen(n, gLDrawable, gL2ES2, false, n2);
        TestTextRendererNEWTBugXXXX.sleep();
        this.screenshot.dispose(gL2ES2);
        regionRenderer.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    void renderString(GLDrawable gLDrawable, GL2ES2 gL2ES2, RegionRenderer regionRenderer, Font font, TextRegionUtil textRegionUtil, String string, int n, int n2, int n3, int[] nArray) {
        int n4 = gLDrawable.getSurfaceHeight();
        float f = 0.0f;
        float f2 = n4;
        if (0 > n2) {
            n2 = this.lastRow + 1;
        }
        AABBox aABBox = font.getMetricBounds(string);
        PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
        pMVMatrix4f.loadMvIdentity();
        pMVMatrix4f.translateMv(f += 24.0f * font.getAdvanceWidth(font.getGlyphID('X')) * (float)n, f2 -= 24.0f * aABBox.getHeight() * (float)(n2 + 1), n3);
        float f3 = 24.0f / (float)font.getMetrics().getUnitsPerEM();
        pMVMatrix4f.scaleMv(f3, f3, 1.0f);
        textRegionUtil.drawString3D(gL2ES2, regionRenderer, font, string, null);
        this.lastRow = n2;
    }

    public void printScreen(int n, GLDrawable gLDrawable, GL gL, boolean bl, int n2) throws GLException, IOException {
        String string = this.getSimpleTestName(".") + "-snap" + this.screenshot_num;
        ++this.screenshot_num;
        String string2 = Region.getRenderModeString(n);
        String string3 = String.format((Locale)null, "%s-msaa%02d-fontsz%02.1f-%03dx%03d-%s%04d", string, gLDrawable.getChosenGLCapabilities().getNumSamples(), Float.valueOf(24.0f), gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), string2, n2);
        String string4 = "./" + string3 + ".png";
        if (this.screenshot.readPixels(gL, false)) {
            this.screenshot.write(new File(string4));
        }
    }
}

