/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.os.Platform;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontScale;
import com.jogamp.junit.util.JunitTracer;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.test.junit.graph.TextRendererGLELBase;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWT10
extends UITestCase {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long Duration = 2000L;
    static int win_width = 1024;
    static int win_height = 640;
    static boolean WaitStartEnd = false;
    static boolean TextAnim = false;
    static int SceneMSAASamples = 0;
    static int GraphVBAASamples = 0;
    static int GraphMSAASamples = 0;
    static boolean ManualTest = false;
    static int SwapInterval = 1;
    static String fontFileName = null;
    static URL fontURL = null;
    static int fontSet = 0;
    static int fontFamily = 0;
    static int fontStylebits = 0;
    static float fontSizeFixed = 14.0f;
    int screenshot_num = 0;
    static final String textX2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus. \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices ultricies nec a elit. \nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia pharetra at venenatis est.\nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat nec, volutpat nec nisi.\nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum id tempus quis, semper \nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin. Quisque sit amet neque lorem,\n-------Press H to change text---------\n";

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        ManualTest = stringArray.length > 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                Duration = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                win_width = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                win_height = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-fontURL")) {
                fontURL = new URL(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-fontFile")) {
                fontFileName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-fontSet")) {
                fontSet = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-fontFamily")) {
                fontFamily = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-fontStyle")) {
                fontStylebits = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-fontSize")) {
                fontSizeFixed = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-smsaa")) {
                SceneMSAASamples = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-gmsaa")) {
                GraphMSAASamples = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-gvbaa")) {
                GraphVBAASamples = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-textAnim")) {
                TextAnim = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                SwapInterval = MiscUtils.atoi(stringArray[++i], SwapInterval);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            WaitStartEnd = true;
        }
        System.err.println("Font [set " + fontSet + ", family " + fontFamily + ", style " + fontStylebits + ", size " + fontSizeFixed + "], fontFileName " + fontFileName);
        System.err.println("Scene MSAA Samples " + SceneMSAASamples);
        System.err.println("Graph MSAA Samples " + GraphMSAASamples);
        System.err.println("Graph VBAA Samples " + GraphVBAASamples);
        System.err.println("swapInterval " + SwapInterval);
        String string = TestTextRendererNEWT10.class.getName();
        JUnitCore.main(string);
    }

    static void sleep() {
        TestTextRendererNEWT10.sleep(Duration);
    }

    static void sleep(long l) {
        try {
            System.err.println("** new frame ** (sleep: " + l + "ms)");
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    static GLWindow createWindow(String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2) {
        Assert.assertNotNull(gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create(gLCapabilitiesImmutable);
        gLWindow.setSize(n, n2);
        gLWindow.setPosition(10, 10);
        gLWindow.setTitle(string);
        Assert.assertNotNull(gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    @Test
    public void test00Manual() throws InterruptedException {
        if (ManualTest) {
            this.testImpl(SceneMSAASamples, GraphMSAASamples, GraphVBAASamples);
        }
    }

    @Test
    public void test00SceneNoAA() throws InterruptedException {
        if (!ManualTest) {
            this.testImpl(0, 0, 0);
        }
    }

    @Test
    public void test01SceneMSAA04() throws InterruptedException {
        if (!ManualTest) {
            this.testImpl(4, 0, 0);
        }
    }

    @Test
    public void test02GraphMSAA04() throws InterruptedException {
        if (!ManualTest) {
            this.testImpl(0, 4, 0);
        }
    }

    @Test
    public void test03GraphVBAA04() throws InterruptedException {
        if (!ManualTest) {
            this.testImpl(0, 0, 4);
        }
    }

    public void testImpl(int n, int n2, int n3) throws InterruptedException {
        int n4;
        int n5;
        GLProfile gLProfile = GLProfile.get("GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        if (0 < n) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n);
        }
        System.err.println("Requested: " + gLCapabilities + ", graph[msaaSamples " + n2 + ", vbaaSamples " + n3 + "]");
        GLWindow gLWindow = TestTextRendererNEWT10.createWindow("text-gvbaa" + n3 + "-gmsaa" + n2 + "-smsaa" + n, gLCapabilities, win_width, win_height);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        if (WaitStartEnd) {
            JunitTracer.waitForKey("Start");
        }
        if (n3 > 0) {
            n5 = 2;
            n4 = n3;
        } else if (n2 > 0) {
            n5 = 1;
            n4 = n2;
        } else {
            n5 = 0;
            n4 = 0;
        }
        final TextRendererGLEL textRendererGLEL = new TextRendererGLEL(gLProfile, n5, n4);
        System.err.println(textRendererGLEL.getFontInfo());
        gLWindow.addGLEventListener(textRendererGLEL);
        Animator animator = new Animator(0);
        animator.add(gLWindow);
        animator.start();
        animator.setUpdateFPSFrames(60, null);
        TestTextRendererNEWT10.sleep();
        gLWindow.invoke(true, new GLRunnable(){

            @Override
            public boolean run(GLAutoDrawable gLAutoDrawable) {
                try {
                    textRendererGLEL.printScreen(n5, gLAutoDrawable, "./", "TestTextRendererNEWT00-snap" + TestTextRendererNEWT10.this.screenshot_num, false);
                    ++TestTextRendererNEWT10.this.screenshot_num;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return true;
            }
        });
        animator.stop();
        if (WaitStartEnd) {
            JunitTracer.waitForKey("Stop");
        }
        TestTextRendererNEWT10.destroyWindow(gLWindow);
    }

    private static final class TextRendererGLEL
    extends TextRendererGLELBase {
        private final GLReadBufferUtil screenshot;
        private final GLRegion regionFPS;
        private final GLRegion regionFPSAnim;
        final Font font;
        final float fontSizeMin;
        final float fontSizeMax;
        private long t0;
        float fontSizeAnim;
        float fontSizeDelta;
        float dpiV;
        float ppmmV;

        TextRendererGLEL(GLProfile gLProfile, int n, int n2) {
            super(n, new int[]{n2});
            this.setRendererCallbacks(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
            this.regionFPS = GLRegion.create(gLProfile, n, null, 0, 0);
            this.regionFPSAnim = GLRegion.create(gLProfile, n, null, 0, 0);
            if (null != fontURL) {
                Font font = null;
                try {
                    font = FontFactory.get(fontURL.openStream(), true);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.font = font;
            } else if (null != fontFileName) {
                Font font = null;
                try {
                    font = FontFactory.get(this.getClass(), fontFileName, false);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.font = font;
            } else {
                this.font = TextRendererGLEL.getFont(fontSet, fontFamily, fontStylebits);
            }
            this.staticRGBAColor[0] = 0.1f;
            this.staticRGBAColor[1] = 0.1f;
            this.staticRGBAColor[2] = 0.1f;
            this.staticRGBAColor[3] = 1.0f;
            this.screenshot = new GLReadBufferUtil(false, false);
            this.fontSizeMin = fontSizeFixed;
            this.fontSizeMax = fontSizeFixed + 8.0f;
            this.fontSizeAnim = fontSizeFixed;
            this.fontSizeDelta = 0.01f;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.setSwapInterval(SwapInterval);
            gL2ES2.glEnable(2929);
            this.t0 = Platform.currentTimeMillis();
            Window window = (Window)gLAutoDrawable.getUpstreamWidget();
            float[] fArray = window.getPixelsPerMM(new float[2]);
            float[] fArray2 = FontScale.ppmmToPPI(fArray, new float[2]);
            this.dpiV = fArray2[1];
            this.ppmmV = fArray[1];
            System.err.println(this.getFontInfo());
            System.err.println("fontSize " + fontSizeFixed + ", dotsPerMM " + fArray[0] + "x" + fArray[1] + ", dpi " + fArray2[0] + "x" + fArray2[1] + ", pixelSize " + FontScale.toPixels(fontSizeFixed, fArray2[1]));
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            this.screenshot.dispose(gL2ES2);
            this.regionFPS.destroy(gL2ES2);
            this.regionFPSAnim.destroy(gL2ES2);
            super.dispose(gLAutoDrawable);
        }

        public void printScreen(int n, GLAutoDrawable gLAutoDrawable, String string, String string2, boolean bl) throws GLException, IOException {
            String string3 = Region.getRenderModeString(n);
            String string4 = String.format((Locale)null, "%s-msaa%02d-fontsz%02.1f-%03dx%03d-%s%04d", string2, gLAutoDrawable.getChosenGLCapabilities().getNumSamples(), Float.valueOf(fontSizeFixed), gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), string3, this.vbaaSampleCount[0]);
            String string5 = string + string4 + ".png";
            if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
                this.screenshot.write(new File(string5));
            }
        }

        String getFontInfo() {
            float f = FontScale.toPixels(fontSizeFixed, this.dpiV);
            float f2 = f / this.ppmmV;
            int n = this.font.getMetrics().getUnitsPerEM();
            return String.format("Resolution dpiV %.2f, %.2f px/mm%nFont %s, unitsPerEM %d, size %.2f pt %.2f px %2f mm%n", Float.valueOf(this.dpiV), Float.valueOf(this.ppmmV), this.font.getFullFamilyName(), n, Float.valueOf(fontSizeFixed), Float.valueOf(f), Float.valueOf(f2));
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
            gL2ES2.glClear(16640);
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            float f = null != gLAnimatorControl ? gLAnimatorControl.getLastFPS() : 0.0f;
            float f2 = null != gLAnimatorControl ? gLAnimatorControl.getTotalFPS() : 0.0f;
            long l = Platform.currentTimeMillis();
            this.fontSizeAnim += this.fontSizeDelta;
            if (this.fontSizeMin >= this.fontSizeAnim || this.fontSizeAnim >= this.fontSizeMax) {
                this.fontSizeDelta *= -1.0f;
            }
            float f3 = FontScale.toPixels(fontSizeFixed, this.dpiV);
            float f4 = FontScale.toPixels(this.fontSizeAnim, this.dpiV);
            String string = Region.getRenderModeString(this.renderModes);
            String string2 = String.format("%03.1f/%03.1f fps, vsync %d, elapsed %4.1f s, fontSize %2.2f, msaa %d, %s-samples %d", Float.valueOf(f), Float.valueOf(f2), gL2ES2.getSwapInterval(), (double)(l - this.t0) / 1000.0, Float.valueOf(fontSizeFixed), gLAutoDrawable.getChosenGLCapabilities().getNumSamples(), string, this.vbaaSampleCount[0]);
            this.renderString(gLAutoDrawable, this.font, f3, this.getFontInfo(), 0, 0, 0.0f, 0.0f, -1000.0f, true);
            this.renderString(gLAutoDrawable, this.font, f3, "012345678901234567890123456789", 0, 0.0f, 0.0f, -1000.0f, true);
            this.renderString(gLAutoDrawable, this.font, f3, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", 0, 0.0f, 0.0f, -1000.0f, true);
            this.renderString(gLAutoDrawable, this.font, f3, "Hello World", 0, 0.0f, 0.0f, -1000.0f, true);
            this.renderString(gLAutoDrawable, this.font, f3, "4567890123456", 4, 0.0f, 0.0f, -1000.0f, true);
            this.renderString(gLAutoDrawable, this.font, f3, "I like JogAmp", 4, 0.0f, 0.0f, -1000.0f, true);
            this.renderString(gLAutoDrawable, this.font, f3, "Hello World", 0, 0.0f, 0.0f, -1000.0f, true);
            this.renderString(gLAutoDrawable, this.font, f3, TestTextRendererNEWT10.textX2, 0, 0.0f, 0.0f, -1000.0f, true);
            this.renderString(gLAutoDrawable, this.font, f3, string2, 0, 0.0f, 0.0f, -1000.0f, this.regionFPS.clear(gL2ES2));
            if (TextAnim) {
                this.renderString(gLAutoDrawable, this.font, f4, string2, 0, 0.0f, 0.0f, -1000.0f, this.regionFPSAnim.clear(gL2ES2));
            }
        }
    }
}

