/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontScale;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.graph.GPURendererListenerBase01;
import java.io.IOException;

public abstract class GPUTextRendererListenerBase01
extends GPURendererListenerBase01 {
    public final TextRegionUtil textRegionUtil;
    private final GLRegion regionFPS;
    private final GLRegion regionHead;
    private final GLRegion regionBottom;
    int fontSet = 0;
    Font font;
    int headType = 1;
    boolean drawFPS = true;
    final float fontSizeFName = 10.0f;
    final float fontSizeFPS = 10.0f;
    final int[] sampleCountFPS = new int[]{8};
    float fontSizeHead = 12.0f;
    float fontSizeCenter = 16.0f;
    float dpiV = 96.0f;
    float ppmmV = 1.0f;
    final int fontSizeModulo = 100;
    String fontName;
    AABBox fontNameBox;
    String headtext;
    AABBox headbox;
    protected final AffineTransform tempT1 = new AffineTransform();
    protected final AffineTransform tempT2 = new AffineTransform();
    static final String text2 = "The quick brown fox jumps over the lazy dog";
    public static final String text_help = "JOGL: Java\u2122 Binding for OpenGL\u00ae, providing hardware-accelerated 3D graphics.\n\nJOGAMP graph demo using Resolution Independent NURBS\nJOGAMP JOGL - OpenGL ES2 profile\nPress 1/2 to zoom in/out the below text\nPress 3/4 to incr/decs font size (alt: head, w/o bottom)\nPress 6/7 to edit texture size if using VBAA\nPress 0/9 to rotate the below string\nPress s to screenshot\nPress v to toggle vsync\nPress i for live input text input (CR ends it, backspace supported)\nPress f to toggle fps. H for different text, space for font type\n";
    public static final String textX1 = "JOGL: Java\u2122 Binding for OpenGL\u00ae, providing hardware-accelerated 3D graphics.\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus. \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices ultricies nec a elit. \nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia pharetra at venenatis est. \nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat nec, volutpat nec nisi. \nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum id tempus quis, semper \nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin. Quisque sit amet neque lorem, \n-------Press H to change text---------";
    public static final String textX2 = "I \u201cAsk Jeff\u201d or \u2018Ask Jeff\u2019. Take the chef d\u2019\u0153uvre! Two of [of] (of) \u2018of\u2019 \u201cof\u201d of? of! of*.\nLes Wo\u00ebvres, the F\u00f4ret de W\u0153vres, the Voire and Vauvise. Yves is in heaven; D\u2019Amboise is in jail.\nLyford\u2019s in Texas & L\u2019Anse-aux-Griffons in Qu\u00e9bec; the \u0141yna in Poland. Yriarte, Yciar and Ysa\u00ffe are at Yale.\nKyoto and Ryotsu are both in Japan, Kwikpak on the Yukon delta, Kv\u00e6ven in Norway, Kyulu in Kenya, not in Rwanda.\u2026\nVon-Vincke-Stra\u00dfe in M\u00fcnster, Vdovino in Russia, Ytterbium in the periodic table. Are Toussaint L\u2019Ouverture, W\u00f6lfflin, Wolfe,\nMi\u0142osz and W\u016b W\u016d all in the library? 1510\u20131620, 11:00 pm, and the 1980s are over. X\n-------Press H to change text---------";
    public static final String textX20 = "I \u201cAsk Jeff\u201d or \u2018Ask Jeff\u2019. Take the chef d\u2019\u0153uvre! Two of [of] (of) \u2018of\u2019 \u201cof\u201d of? of! of*.\nTwo of [of] (of) \u2018of\u2019 \u201cof\u201d of? of! of*. Ydes, Yffignac and Ygrande are in France: so are Ypres,\nLes Wo\u00ebvres, the F\u00f4ret de W\u0153vres, the Voire and Vauvise. Yves is in heaven; D\u2019Amboise is in jail.\nLyford\u2019s in Texas & L\u2019Anse-aux-Griffons in Qu\u00e9bec; the \u0141yna in Poland. Yriarte, Yciar and Ysa\u00ffe are at Yale.\nKyoto and Ryotsu are both in Japan, Kwikpak on the Yukon delta, Kv\u00e6ven in Norway, Kyulu in Kenya, not in Rwanda.\u2026\nWalton\u2019s in West Virginia, but \u00abWren\u00bb is in Oregon. Tl\u00e1lpan is near Xochimilco in M\u00e9xico.\nThe Zygos & Xylophagou are in Cyprus, Zwettl in Austria, F\u00e6n\u00f8 in Denmark, the V\u00f8ringsfossen and V\u00e6r\u00f8y in Norway.\nTchula is in Mississippi, the Tittabawassee in Michigan. Twodot is here in Montana, Ywamun in Burma.\nYggdrasil and Ymir, Yngvi and V\u00f3den, V\u00eddri\u00f0 and Skeggj\u00f6ld and T\u00fdr are all in the Eddas.\nT\u00f8rberget and V\u00e5g, of course, are in Norway, Ktipas and Tmolos in Greece, but V\u00e1zquez is in Argentina, Vreden in Germany,\nVon-Vincke-Stra\u00dfe in M\u00fcnster, Vdovino in Russia, Ytterbium in the periodic table. Are Toussaint L\u2019Ouverture, W\u00f6lfflin, Wolfe,\nMi\u0142osz and W\u016b W\u016d all in the library? 1510\u20131620, 11:00 pm, and the 1980s are over.\nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \n-------Press H to change text---------";
    static final String textXLast = "abcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\n0123456789.:,;(*!?/\\\")$%^&-+@~#<>{}[]";
    Window upstream_window = null;
    StringBuilder userString = new StringBuilder("JOGL: Java\u2122 Binding for OpenGL\u00ae, providing hardware-accelerated 3D graphics.\n\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus. \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices ultricies nec a elit. \nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia pharetra at venenatis est. \nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat nec, volutpat nec nisi. \nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum id tempus quis, semper \nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin. Quisque sit amet neque lorem, \n-------Press H to change text---------");
    boolean userInput = false;
    float nearPlaneX0;
    float nearPlaneY0;
    float nearPlaneZ0;
    float nearPlaneSx;
    float nearPlaneSy;
    float nearPlaneS;
    final boolean bottomTextUseFrustum = true;
    KeyAction keyAction = null;
    float fontHeadScale = 1.0f;

    public GPUTextRendererListenerBase01(GLProfile gLProfile, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        super(RegionRenderer.create(bl ? RegionRenderer.defaultBlendEnable : null, bl ? RegionRenderer.defaultBlendDisable : null), n, bl2, bl3);
        this.getRenderer().setHintBits(2);
        this.textRegionUtil = new TextRegionUtil(n);
        this.regionFPS = GLRegion.create(gLProfile, n, null, 0, 0);
        this.regionHead = GLRegion.create(gLProfile, n, null, 0, 0);
        this.regionBottom = GLRegion.create(gLProfile, n, null, 0, 0);
        this.setFontSet(this.fontSet, 1, 0);
        this.setMatrix(0.0f, 0.0f, 0.0f, 0.0f);
        this.getRenderer().setAAQuality(n2);
        this.getRenderer().setSampleCount(n3);
    }

    void switchHeadBox() {
        this.setHeadBox((this.headType + 1) % 5, true);
    }

    public int getHeadBoxType() {
        return this.headType;
    }

    public AABBox getHeadBox() {
        return this.headbox;
    }

    public void setHeadBox(int n, boolean bl) {
        this.headType = n % 5;
        switch (this.headType) {
            case 0: {
                this.headtext = null;
                break;
            }
            case 1: {
                this.headtext = textX1;
                break;
            }
            case 2: {
                this.headtext = textX2;
                break;
            }
            case 3: {
                this.headtext = text_help;
                break;
            }
            default: {
                this.headtext = textXLast;
            }
        }
        if (bl && null != this.headtext) {
            this.headbox = this.font.getMetricBounds(this.headtext);
            if (this.headtext != text_help) {
                float f = FontScale.toPixels(this.fontSizeHead, this.dpiV);
                GPUTextRendererListenerBase01.upsizeWindowSurface(this.upstream_window, true, (int)(this.headbox.getWidth() * f * 1.1f), (int)(this.headbox.getHeight() * f * 2.0f));
            }
        }
    }

    public void setHeadBox(String string, boolean bl) {
        this.headtext = string;
        if (bl && null != this.headtext) {
            this.headbox = this.font.getMetricBounds(this.headtext);
            if (this.headtext != text_help) {
                float f = FontScale.toPixels(this.fontSizeHead, this.dpiV);
                GPUTextRendererListenerBase01.upsizeWindowSurface(this.upstream_window, true, (int)(this.headbox.getWidth() * f * 1.1f), (int)(this.headbox.getHeight() * f * 2.0f));
            }
        }
    }

    public static void upsizeWindowSurface(final Window window, boolean bl, int n, int n2) {
        if (null == window) {
            return;
        }
        final int n3 = Math.max(window.getSurfaceWidth(), n);
        final int n4 = Math.max(window.getSurfaceHeight(), n2);
        System.err.println("upsizeWindowSurface: " + window.getSurfaceWidth() + "x" + window.getSurfaceHeight() + " -> " + n + "x" + n2 + " -> " + n3 + "x" + n4);
        if (bl) {
            new InterruptSource.Thread(){

                @Override
                public void run() {
                    window.setSurfaceSize(n3, n4);
                }
            }.start();
        } else {
            window.setSurfaceSize(n3, n4);
        }
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        super.init(gLAutoDrawable);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            this.upstream_window = (Window)object;
            float[] fArray = this.upstream_window.getPixelsPerMM(new float[2]);
            float[] fArray2 = FontScale.ppmmToPPI(new float[]{fArray[0], fArray[1]});
            this.dpiV = fArray2[1];
            this.ppmmV = fArray[1];
            System.err.println("Using vertical screen DPI of " + this.dpiV + ", " + this.ppmmV + " pixel/mm");
        } else {
            System.err.println("Using vertical default DPI of " + this.dpiV + ", " + this.ppmmV + " pixel/mm");
        }
        this.fontNameBox = this.font.getGlyphBounds(this.fontName, this.tempT1, this.tempT2);
        this.setHeadBox(this.headType, true);
        float f = FontScale.toPixels(10.0f, this.dpiV);
        System.err.println("XXX: fontName size 10.0pt, dpiV " + this.dpiV + " -> " + f + "px");
        System.err.println("XXX: fontName boxM fu " + this.font.getMetricBoundsFU(this.fontName));
        System.err.println("XXX: fontName boxG fu " + this.font.getGlyphBoundsFU(this.fontName, this.tempT1, this.tempT2));
        System.err.println("XXX: fontName boxM em " + this.font.getMetricBounds(this.fontName));
        System.err.println("XXX: fontName boxG em " + this.font.getGlyphBounds(this.fontName, this.tempT1, this.tempT2));
        System.err.println("XXX: fontName box height px " + this.fontNameBox.getHeight() * f);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        super.reshape(gLAutoDrawable, n, n2, n3, n4);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            this.upstream_window = (Window)object;
        }
        this.nearPlaneX0 = this.nearPlane1Box.getMinX() * 100.0f;
        this.nearPlaneY0 = this.nearPlane1Box.getMinY() * 100.0f;
        this.nearPlaneZ0 = this.nearPlane1Box.getMinZ() * 100.0f;
        float f = this.nearPlane1Box.getWidth() * 100.0f;
        float f2 = this.nearPlane1Box.getHeight() * 100.0f;
        this.nearPlaneSx = f / (float)n3;
        this.nearPlaneS = this.nearPlaneSy = f2 / (float)n4;
        System.err.printf("Scale: [%f x %f] / [%d x %d] = [%f, %f] -> %f%n", Float.valueOf(f), Float.valueOf(f2), n3, n4, Float.valueOf(this.nearPlaneSx), Float.valueOf(this.nearPlaneSy), Float.valueOf(this.nearPlaneS));
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.upstream_window = null;
        this.regionFPS.destroy(gLAutoDrawable.getGL().getGL2ES2());
        this.regionHead.destroy(gLAutoDrawable.getGL().getGL2ES2());
        this.regionBottom.destroy(gLAutoDrawable.getGL().getGL2ES2());
        super.dispose(gLAutoDrawable);
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        float f;
        float f2;
        float f3;
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            this.upstream_window = (Window)object;
        }
        int n = gLAutoDrawable.getSurfaceWidth();
        int n2 = gLAutoDrawable.getSurfaceHeight();
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL2ES2.glClear(16640);
        RegionRenderer regionRenderer = this.getRenderer();
        PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
        pMVMatrix4f.loadMvIdentity();
        regionRenderer.setColorStatic(0.1f, 0.1f, 0.1f, 1.0f);
        float f4 = FontScale.toPixels(10.0f, this.dpiV);
        float f5 = FontScale.toPixels(this.fontSizeHead, this.dpiV);
        float f6 = f5 / this.ppmmV;
        float f7 = FontScale.toPixels(this.fontSizeCenter, this.dpiV);
        float f8 = f7 / this.ppmmV;
        int n3 = this.getRenderer().getAAQuality();
        int n4 = this.getRenderer().getSampleCount();
        regionRenderer.enable(gL2ES2, true);
        if (this.drawFPS) {
            pMVMatrix4f.pushMv();
            f3 = FontScale.toPixels(10.0f, this.dpiV);
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            if (null != gLAnimatorControl) {
                f2 = gLAnimatorControl.getLastFPS();
                f = gLAnimatorControl.getTotalFPS();
            } else {
                f2 = 0.0f;
                f = 0.0f;
            }
            String string = Region.getRenderModeString(this.regionFPS.getRenderModes()) + "-q" + n3;
            String string2 = String.format("%03.1f/%03.1f fps, v-sync %d, dpiV %.2f %.2f px/mm, font[head %.1fpt %.2fpx %.2fmm, center %.1fpt %.2fpx %.2fmm], %s-samples[%d], blend %b, alpha %d", Float.valueOf(f2), Float.valueOf(f), gL2ES2.getSwapInterval(), Float.valueOf(this.dpiV), Float.valueOf(this.ppmmV), Float.valueOf(this.fontSizeHead), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(this.fontSizeCenter), Float.valueOf(f7), Float.valueOf(f8), string, n4, regionRenderer.hintBitsSet(1), gLAutoDrawable.getChosenGLCapabilities().getAlphaBits());
            pMVMatrix4f.translateMv(this.nearPlaneX0, this.nearPlaneY0 + this.nearPlaneS * f3 / 2.0f, this.nearPlaneZ0);
            float f9 = this.nearPlaneS * f3;
            pMVMatrix4f.scaleMv(f9, f9, 1.0f);
            TextRegionUtil.drawString3D(gL2ES2, this.regionFPS.clear(gL2ES2), regionRenderer, this.font, (CharSequence)string2, null, this.tempT1, this.tempT2);
            pMVMatrix4f.popMv();
        }
        f3 = (float)n - (this.fontNameBox.getWidth() + 2.0f * this.font.getAdvanceWidth(this.font.getGlyphID('X'))) * f4;
        f2 = (float)n2 - this.fontNameBox.getHeight() * f4;
        pMVMatrix4f.pushMv();
        pMVMatrix4f.translateMv(this.nearPlaneX0 + f3 * this.nearPlaneSx, this.nearPlaneY0 + f2 * this.nearPlaneSy, this.nearPlaneZ0);
        f = this.nearPlaneS * f4;
        pMVMatrix4f.scaleMv(f, f, 1.0f);
        this.textRegionUtil.drawString3D(gL2ES2, regionRenderer, this.font, this.fontName, null);
        pMVMatrix4f.popMv();
        f3 = 10.0f;
        f2 += -this.fontNameBox.getHeight() * f4 - 10.0f;
        if (null != this.headtext) {
            pMVMatrix4f.pushMv();
            pMVMatrix4f.translateMv(this.nearPlaneX0 + f3 * this.nearPlaneSx, this.nearPlaneY0 + f2 * this.nearPlaneSy, this.nearPlaneZ0);
            f = this.nearPlaneS * f5;
            pMVMatrix4f.scaleMv(f, f, 1.0f);
            this.textRegionUtil.drawString3D(gL2ES2, regionRenderer, this.font, this.headtext, null);
            pMVMatrix4f.popMv();
        }
        String string = this.font.getGlyph('M').toString() + "\n" + this.font.getGlyph('X').toString();
        pMVMatrix4f.pushMv();
        pMVMatrix4f.translateMv(this.nearPlaneX0 + f3 * this.nearPlaneSx, this.nearPlaneY0 + (f2 += (-this.headbox.getHeight() - this.font.getLineHeight()) * f7) * this.nearPlaneSy, this.nearPlaneZ0);
        float f10 = this.nearPlaneS * f4;
        pMVMatrix4f.scaleMv(f10, f10, 1.0f);
        AABBox aABBox = this.textRegionUtil.drawString3D(gL2ES2, regionRenderer, this.font, string, null);
        pMVMatrix4f.popMv();
        pMVMatrix4f.pushMv();
        pMVMatrix4f.translateMv(this.nearPlaneX0 + f3 * this.nearPlaneSx, this.nearPlaneY0 + (f2 += (-aABBox.getHeight() - this.font.getLineHeight()) * f4) * this.nearPlaneSy, this.nearPlaneZ0);
        pMVMatrix4f.translateMv(this.getXTran(), this.getYTran(), this.getZTran());
        pMVMatrix4f.rotateMv(this.getAngleRad(), 0.0f, 1.0f, 0.0f);
        float f11 = this.nearPlaneS * f7;
        pMVMatrix4f.scaleMv(f11, f11, 1.0f);
        regionRenderer.setColorStatic(0.9f, 0.0f, 0.0f, 1.0f);
        this.regionBottom.setFrustum(pMVMatrix4f.getFrustum());
        if (!this.userInput) {
            TextRegionUtil.drawString3D(gL2ES2, this.regionBottom.clear(gL2ES2), regionRenderer, this.font, (CharSequence)text2, null, this.tempT1, this.tempT2);
        } else {
            TextRegionUtil.drawString3D(gL2ES2, this.regionBottom.clear(gL2ES2), regionRenderer, this.font, (CharSequence)this.userString.toString(), null, this.tempT1, this.tempT2);
        }
        pMVMatrix4f.popMv();
        regionRenderer.enable(gL2ES2, false);
    }

    public Font getFont() {
        return this.font;
    }

    public float getFontSizeHead() {
        return this.fontSizeHead;
    }

    public void fontBottomIncr(int n) {
        this.fontSizeCenter = Math.abs((this.fontSizeCenter + (float)n) % 100.0f);
        this.dumpMatrix(true);
    }

    public void fontHeadIncr(int n) {
        this.fontSizeHead = Math.abs((this.fontSizeHead + (float)n) % 100.0f);
        this.updateFontNameBox();
        if (null != this.headtext) {
            this.headbox = this.font.getMetricBounds(this.headtext);
        }
    }

    public void setFontHeadSize(int n) {
        if (0 < n) {
            this.fontSizeHead = n % 100;
            this.updateFontNameBox();
            if (null != this.headtext) {
                this.headbox = this.font.getMetricBounds(this.headtext);
            }
        }
    }

    public boolean nextFontSet() {
        try {
            int n = this.fontSet == 0 ? 0 : 0;
            Font font = FontFactory.get(n).getDefault();
            if (null != font) {
                this.fontSet = n;
                this.font = font;
                this.updateFontNameBox();
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println("Caught: " + iOException.getMessage());
        }
        return false;
    }

    public boolean setFontSet(int n, int n2, int n3) {
        try {
            Font font = FontFactory.get(n).get(n2, n3);
            if (null != font) {
                this.fontSet = n;
                this.font = font;
                this.updateFontNameBox();
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println("Caught: " + iOException.getMessage());
        }
        return false;
    }

    public boolean setFont(Font font) {
        if (null != font) {
            this.font = font;
            this.updateFontNameBox();
            return true;
        }
        return false;
    }

    private void updateFontNameBox() {
        this.fontName = this.font.getFullFamilyName() + " (head " + this.fontSizeHead + "pt)";
        this.fontNameBox = this.font.getMetricBounds(this.fontName);
    }

    public boolean isUserInputMode() {
        return this.userInput;
    }

    void dumpMatrix(boolean bl) {
        System.err.println("Matrix: " + this.getXTran() + "/" + this.getYTran() + " x" + this.getZTran() + " @" + this.getAngleDeg() + " fontSize " + this.fontSizeCenter);
        if (bl) {
            System.err.println("bbox em: " + this.font.getMetricBounds(text2));
            System.err.println("bbox px: " + this.font.getMetricBounds(text2).scale(this.nearPlaneS * FontScale.toPixels(this.fontSizeCenter, this.dpiV)));
        }
    }

    @Override
    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener(this.keyAction);
            super.attachInputListenerTo(gLWindow);
        }
    }

    @Override
    public void detachInputListenerFrom(GLWindow gLWindow) {
        super.detachInputListenerFrom(gLWindow);
        if (null == this.keyAction) {
            return;
        }
        gLWindow.removeKeyListener(this.keyAction);
    }

    @Override
    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, String string3, boolean bl) throws GLException, IOException {
        String string4 = this.font.getFullFamilyName().replace(' ', '_').replace('-', '_');
        String string5 = Region.getRenderModeString(this.getRenderModes());
        String string6 = "fsaa" + gLAutoDrawable.getChosenGLCapabilities().getNumSamples();
        super.printScreen(gLAutoDrawable, string, string2 + "-" + string5, string6 + "-" + string4 + "-text" + this.getHeadBoxType() + "-" + string3, bl);
    }

    public class KeyAction
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (GPUTextRendererListenerBase01.this.userInput) {
                return;
            }
            short s = keyEvent.getKeySymbol();
            if (s == 51) {
                if (keyEvent.isAltDown()) {
                    GPUTextRendererListenerBase01.this.fontHeadIncr(1);
                } else {
                    GPUTextRendererListenerBase01.this.fontBottomIncr(1);
                }
            } else if (s == 52) {
                if (keyEvent.isAltDown()) {
                    GPUTextRendererListenerBase01.this.fontHeadIncr(-1);
                } else {
                    GPUTextRendererListenerBase01.this.fontBottomIncr(-1);
                }
            } else if (s == 72) {
                GPUTextRendererListenerBase01.this.switchHeadBox();
            } else if (s == 70) {
                GPUTextRendererListenerBase01.this.drawFPS = !GPUTextRendererListenerBase01.this.drawFPS;
            } else if (s == 32) {
                GPUTextRendererListenerBase01.this.nextFontSet();
            } else if (s == 73) {
                GPUTextRendererListenerBase01.this.userInput = true;
                GPUTextRendererListenerBase01.this.setIgnoreInput(true);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                return;
            }
            if (GPUTextRendererListenerBase01.this.userInput) {
                short s = keyEvent.getKeySymbol();
                if (13 == s) {
                    GPUTextRendererListenerBase01.this.userInput = false;
                    GPUTextRendererListenerBase01.this.setIgnoreInput(false);
                } else if (8 == s && GPUTextRendererListenerBase01.this.userString.length() > 0) {
                    GPUTextRendererListenerBase01.this.userString.deleteCharAt(GPUTextRendererListenerBase01.this.userString.length() - 1);
                } else {
                    char c = keyEvent.getKeyChar();
                    if (GPUTextRendererListenerBase01.this.font.isPrintableChar(c)) {
                        GPUTextRendererListenerBase01.this.userString.append(c);
                    }
                }
            }
        }
    }
}

