/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontScale;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.BoxLayout;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.graph.ui.layout.GridLayout;
import com.jogamp.graph.ui.shapes.GlyphShape;
import com.jogamp.math.geom.AABBox;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;

public class FontViewListener01
implements GLEventListener {
    private float mmPerCell = 8.0f;
    private int pixelPerCell = 30;
    private boolean useDPI = false;
    private final int renderModes;
    private final char startCharSymbol;
    private final Font font;
    private final Scene scene;
    private Group grid;

    public FontViewListener01(int n, int n2, int n3, Font font, char c) {
        this.renderModes = n;
        this.startCharSymbol = c;
        this.font = font;
        this.scene = new Scene(n3);
        this.scene.setClearParams(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 16640);
        this.scene.setPMvCullingEnabled(true);
        this.scene.setAAQuality(n2);
    }

    public void setMMPerCell(float f) {
        this.mmPerCell = f;
        this.useDPI = true;
    }

    public void setPixelPerCell(int n) {
        this.pixelPerCell = n;
        this.useDPI = false;
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        this.scene.attachInputListenerTo(gLWindow);
    }

    public void printScreenOnGLThread(GLAutoDrawable gLAutoDrawable, String string, String string2, String string3, boolean bl) {
        String string4 = this.font.getFullFamilyName().replace(' ', '_').replace('-', '_');
        this.scene.screenshot(true, this.scene.nextScreenshotFile(null, string2, this.renderModes, gLAutoDrawable.getChosenGLCapabilities(), string4));
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        this.scene.init(gLAutoDrawable);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.scene.dispose(gLAutoDrawable);
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        this.scene.display(gLAutoDrawable);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Object object;
        this.scene.reshape(gLAutoDrawable, n, n2, n3, n4);
        System.err.println("Reshape " + n3 + " x " + n4 + ", " + this.scene.getViewport());
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.grid) {
            this.scene.removeShape(gL2ES2, this.grid);
        }
        if (this.useDPI && gLAutoDrawable instanceof GLWindow) {
            GLWindow gLWindow = (GLWindow)gLAutoDrawable;
            float[] fArray = gLWindow.getPixelsPerMM(new float[2]);
            float[] fArray2 = FontScale.ppmmToPPI(new float[]{fArray[0], fArray[1]});
            System.err.println("DPI " + fArray2[0] + " x " + fArray2[1] + ", " + fArray[0] + " x " + fArray[1] + " pixel/mm");
            object = gLWindow.getCurrentSurfaceScale(new float[2]);
            System.err.println("HiDPI PixelScale: " + object[0] + "x" + object[1] + " (has)");
            System.err.println("mmPerCell " + this.mmPerCell);
            n6 = (int)(0.9f * ((float)n3 / fArray[0]) / this.mmPerCell);
            n5 = (int)(0.9f * ((float)n4 / fArray[1]) / this.mmPerCell);
        } else {
            n6 = (int)(0.9f * (float)n3 / (float)this.pixelPerCell);
            n5 = (int)(0.9f * (float)n4 / (float)this.pixelPerCell);
        }
        int n7 = n6 * n5;
        float f = n6 > n5 ? 1.0f / (float)n6 : 1.0f / (float)n5;
        System.err.println("Reshape Grid " + n6 + " x " + n5 + ", " + n7 + " cells, netGridSize " + f);
        this.grid = new Group(new GridLayout(n6, f, f, Alignment.FillCenter, new Gap(f / 0.9f * 0.1f)));
        this.scene.addShape(this.grid);
        for (int i = 0; i < 65535 && this.grid.getShapeCount() < n7; ++i) {
            char c = (char)(this.startCharSymbol + i);
            Font.Glyph glyph = this.font.getGlyph(c);
            if (glyph.isNonContour()) continue;
            GlyphShape glyphShape = new GlyphShape(this.renderModes, glyph, 0.0f, 0.0f);
            glyphShape.setColor(0.1f, 0.1f, 0.1f, 1.0f);
            glyphShape.setDragAndResizable(false);
            glyphShape.onClicked((shape, vec3f, mouseEvent) -> System.err.println(((GlyphShape)shape).getGlyph().toString()));
            glyphShape.validate(gL2ES2);
            Group group = new Group(new BoxLayout(1.0f, 1.0f, Alignment.Center));
            group.setBorder(0.02f).setBorderColor(0.0f, 0.0f, 0.0f, 1.0f).setInteractive(false);
            AABBox aABBox = glyphShape.getBounds();
            glyphShape.move((1.0f - aABBox.getWidth()) / 2.0f, (1.0f - aABBox.getHeight()) / 2.0f, 0.0f);
            glyphShape.move(aABBox.getLow().mul(-1.0f));
            group.addShape(glyphShape);
            this.grid.addShape(group);
        }
        this.grid.validate(gL2ES2);
        AABBox aABBox = this.scene.getBounds();
        object = this.grid.getBounds();
        float f2 = aABBox.getWidth() / ((AABBox)object).getWidth();
        float f3 = aABBox.getHeight() / ((AABBox)object).getHeight();
        float f4 = Math.min(f2, f3);
        this.grid.scale(f4, f4, 1.0f).moveTo(aABBox.getLow());
        System.err.println("SceneBox " + aABBox);
        System.err.println("GridBox " + object);
        System.err.println("scale sx " + f2 + ", sy " + f3 + ", sxy " + f4);
        System.err.println("Grid " + this.grid);
        System.err.println("Grid " + this.grid.getLayout());
        System.err.println("Grid[0] " + this.grid.getShapes().get(0));
    }
}

