/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.bugs;

import com.jogamp.common.os.Clock;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.test.junit.jogl.demos.es2.LandscapeES2;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Bug735Inv0AppletAWT
extends Applet
implements Runnable {
    public static final int AWT = 0;
    public static final int NEWT = 1;
    public static final int APPLET_WIDTH = 500;
    public static final int APPLET_HEIGHT = 290;
    public static final int TARGET_FPS = 120;
    public static final int TOOLKIT = 1;
    public static final boolean MANUAL_FRAME_HANDLING = true;
    private static Frame frame;
    private static Bug735Inv0AppletAWT applet;
    private GLCanvas awtCanvas;
    private GLWindow newtWindow;
    private NewtCanvasAWT newtCanvas;
    private DrawRunnable drawRunnable;
    private GLContext context;
    private GLU glu;
    private int width;
    private int height;
    private Thread thread;
    private boolean doneInit = false;
    private boolean doneSetup = false;
    private final long frameRatePeriod = 8333333L;
    private long millisOffset;
    private int frameCount;
    private float frameRate;
    private ShaderCode vertShader;
    private ShaderCode fragShader;
    private ShaderProgram shaderProg;
    private ShaderState shaderState;
    private GLUniformData resolution;
    private GLUniformData time;
    private GLArrayDataServer vertices;
    private int fcount = 0;
    private int lastm = 0;
    private final int fint = 1;

    @Override
    public void init() {
        this.setSize(500, 290);
        this.setPreferredSize(new Dimension(500, 290));
        this.width = 500;
        this.height = 290;
    }

    @Override
    public void start() {
        this.thread = new InterruptSource.Thread(null, this, "Animation Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        int n = 0;
        long l = Clock.currentNanos();
        long l2 = 0L;
        this.millisOffset = System.currentTimeMillis();
        this.frameCount = 1;
        while (Thread.currentThread() == this.thread) {
            long l3;
            long l4;
            long l5;
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.requestDraw(countDownLatch);
            try {
                countDownLatch.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.frameCount == 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Bug735Inv0AppletAWT.this.requestFocusInWindow();
                    }
                });
            }
            if ((l5 = 8333333L - (l4 = (l3 = Clock.currentNanos()) - l) - l2) > 0L) {
                try {
                    Thread.sleep(l5 / 1000000L, (int)(l5 % 1000000L));
                    n = 0;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = Clock.currentNanos() - l3 - l5;
            } else {
                l2 = 0L;
                if (++n > 15) {
                    Thread.yield();
                    n = 0;
                }
            }
            l = Clock.currentNanos();
        }
    }

    public void requestDraw(CountDownLatch countDownLatch) {
        if (!this.doneInit) {
            this.initDraw();
        }
        this.newtWindow.invoke(true, this.drawRunnable);
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
    }

    private void initGL() {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setBackgroundOpaque(true);
        gLCapabilities.setOnscreen(true);
        gLCapabilities.setSampleBuffers(false);
        this.newtWindow = GLWindow.create(gLCapabilities);
        this.newtCanvas = new NewtCanvasAWT(this.newtWindow);
        this.newtCanvas.setBounds(0, 0, Bug735Inv0AppletAWT.applet.width, Bug735Inv0AppletAWT.applet.height);
        this.newtCanvas.setBackground(new Color(-3355444, true));
        this.newtCanvas.setFocusable(true);
        applet.setLayout(new BorderLayout());
        applet.add((Component)this.newtCanvas, "Center");
        this.newtCanvas.setIgnoreRepaint(true);
        this.newtWindow.setAutoSwapBufferMode(false);
    }

    private void initDraw() {
        this.newtCanvas.setVisible(true);
        this.newtWindow.display();
        if (this.newtWindow.isRealized()) {
            this.newtCanvas.requestFocus();
            this.context = this.newtWindow.getContext();
        }
        this.drawRunnable = new DrawRunnable();
        this.doneInit = true;
    }

    private void setup(GL2ES2 gL2ES2) {
        gL2ES2.setSwapInterval(0);
        this.glu = new GLU();
        this.vertShader = ShaderCode.create(gL2ES2, 35633, LandscapeES2.class, "shader", "shader/bin", "landscape", true);
        this.fragShader = ShaderCode.create(gL2ES2, 35632, LandscapeES2.class, "shader", "shader/bin", "landscape", true);
        this.vertShader.defaultShaderCustomization(gL2ES2, true, true);
        this.fragShader.defaultShaderCustomization(gL2ES2, true, true);
        this.shaderProg = new ShaderProgram();
        this.shaderProg.add(gL2ES2, this.vertShader, System.err);
        this.shaderProg.add(gL2ES2, this.fragShader, System.err);
        this.shaderState = new ShaderState();
        this.shaderState.attachShaderProgram(gL2ES2, this.shaderProg, true);
        this.resolution = new GLUniformData("iResolution", 3, FloatBuffer.wrap(new float[]{this.width, this.height, 0.0f}));
        this.shaderState.ownUniform(this.resolution);
        this.shaderState.uniform(gL2ES2, this.resolution);
        this.time = new GLUniformData("iGlobalTime", 0.0f);
        this.shaderState.ownUniform(this.time);
        this.vertices = GLArrayDataServer.createGLSL("inVertex", 2, 5126, false, 4, 35044);
        this.vertices.putf(-1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(1.0f);
        this.vertices.seal(gL2ES2, true);
        this.shaderState.ownAttribute(this.vertices, true);
        this.shaderState.useProgram(gL2ES2, false);
        this.doneSetup = true;
    }

    private void draw(GL2ES2 gL2ES2) {
        this.shaderState.useProgram(gL2ES2, true);
        this.time.setData((float)(System.currentTimeMillis() - this.millisOffset) / 1000.0f);
        this.shaderState.uniform(gL2ES2, this.time);
        this.vertices.enableBuffer(gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.vertices.enableBuffer(gL2ES2, false);
        this.shaderState.useProgram(gL2ES2, false);
        ++this.frameCount;
        ++this.fcount;
        int n = (int)(System.currentTimeMillis() - this.millisOffset);
        if (n - this.lastm > 1000) {
            this.frameRate = (float)this.fcount / 1.0f;
            this.fcount = 0;
            this.lastm = n;
        }
        if (this.frameCount % 120 == 0) {
            System.out.println("FrameCount: " + this.frameCount + " - FrameRate: " + this.frameRate);
        }
    }

    private void checkGLErrors(GL gL) {
        int n = gL.glGetError();
        if (n != 0) {
            String string = this.glu.gluErrorString(n);
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        frame = new Frame(graphicsDevice.getDefaultConfiguration());
        frame.setBackground(new Color(204, 204, 204));
        frame.setTitle("TestBug735Inv0AppletAWT");
        try {
            serializable = Thread.currentThread().getContextClassLoader().loadClass(Bug735Inv0AppletAWT.class.getName());
            applet = (Bug735Inv0AppletAWT)serializable.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        frame.setLayout(null);
        frame.add(applet);
        frame.pack();
        frame.setResizable(false);
        applet.init();
        serializable = frame.getInsets();
        int n = Bug735Inv0AppletAWT.applet.width + ((Insets)serializable).left + ((Insets)serializable).right;
        int n2 = Bug735Inv0AppletAWT.applet.height + ((Insets)serializable).top + ((Insets)serializable).bottom;
        frame.setSize(n, n2);
        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        frame.setLocation(rectangle.x + (rectangle.width - Bug735Inv0AppletAWT.applet.width) / 2, rectangle.y + (rectangle.height - Bug735Inv0AppletAWT.applet.height) / 2);
        int n3 = n2 - ((Insets)serializable).top - ((Insets)serializable).bottom;
        applet.setBounds((n - Bug735Inv0AppletAWT.applet.width) / 2, ((Insets)serializable).top + (n3 - Bug735Inv0AppletAWT.applet.height) / 2, Bug735Inv0AppletAWT.applet.width, Bug735Inv0AppletAWT.applet.height);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        applet.initGL();
        frame.setVisible(true);
        applet.start();
    }

    private class DrawRunnable
    implements GLRunnable {
        private boolean notCurrent;

        private DrawRunnable() {
        }

        @Override
        public boolean run(GLAutoDrawable gLAutoDrawable) {
            this.makeContextCurrent();
            if (Bug735Inv0AppletAWT.this.doneSetup) {
                Bug735Inv0AppletAWT.this.draw(gLAutoDrawable.getGL().getGL2ES2());
            } else {
                Bug735Inv0AppletAWT.this.setup(gLAutoDrawable.getGL().getGL2ES2());
            }
            Bug735Inv0AppletAWT.this.checkGLErrors(gLAutoDrawable.getGL());
            this.swapBuffers();
            this.releaseCurrentContext();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeContextCurrent() {
            if (Bug735Inv0AppletAWT.this.context.isCurrent()) {
                this.notCurrent = false;
            } else {
                this.notCurrent = true;
                int n = 0;
                int n2 = 0;
                do {
                    block10: {
                        try {
                            n = Bug735Inv0AppletAWT.this.context.makeCurrent();
                            System.out.println("Made context current");
                        }
                        catch (GLException gLException) {
                            gLException.printStackTrace();
                        }
                        finally {
                            if (++n2 != 10) break block10;
                            throw new RuntimeException("Failed to claim OpenGL context.");
                        }
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                } while (n == 0);
            }
        }

        private void swapBuffers() {
            GL gL = GLContext.getCurrentGL();
            gL.glFlush();
            GLContext.getCurrent().getGLDrawable().swapBuffers();
        }

        private void releaseCurrentContext() {
            if (this.notCurrent) {
                try {
                    Bug735Inv0AppletAWT.this.context.release();
                    System.out.println("Released context");
                }
                catch (GLException gLException) {
                    gLException.printStackTrace();
                }
            }
        }
    }
}

