/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLImage2d;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.test.util.UITestCase;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CLImageTest
extends UITestCase {
    private static int[] pixels;

    @BeforeClass
    public static void init() throws IOException {
        BufferedImage bufferedImage = ImageIO.read(CLImageTest.class.getResourceAsStream("jogamp.png"));
        pixels = new int[65536];
        bufferedImage.getData().getPixels(0, 0, 128, 128, pixels);
    }

    public CLDevice getCompatibleDevice() {
        CLPlatform[] cLPlatformArray;
        for (CLPlatform cLPlatform : cLPlatformArray = CLPlatform.listCLPlatforms()) {
            CLDevice[] cLDeviceArray;
            for (CLDevice cLDevice : cLDeviceArray = cLPlatform.listCLDevices()) {
                if (!cLDevice.isImageSupportAvailable()) continue;
                return cLDevice;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void supportedImageFormatsTest() {
        CLDevice cLDevice = this.getCompatibleDevice();
        if (cLDevice == null) {
            System.out.println("WARNING: can not test image api.");
            return;
        }
        CLContext cLContext = CLContext.create(cLDevice);
        try {
            CLImageFormat[] cLImageFormatArray = cLContext.getSupportedImage2dFormats(new CLMemory.Mem[0]);
            Assert.assertTrue(cLImageFormatArray.length > 0);
            System.out.println("sample image format: " + cLImageFormatArray[0]);
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void image2dCopyTest() throws IOException {
        CLDevice cLDevice = this.getCompatibleDevice();
        if (cLDevice == null) {
            System.out.println("WARNING: can not test image api.");
            return;
        }
        CLContext cLContext = CLContext.create(cLDevice);
        CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
        try {
            CLImageFormat cLImageFormat = new CLImageFormat(CLImageFormat.ChannelOrder.RGBA, CLImageFormat.ChannelType.UNSIGNED_INT32);
            CLImage2d<IntBuffer> cLImage2d = cLContext.createImage2d(Buffers.newDirectIntBuffer(pixels), 128, 128, cLImageFormat, new CLMemory.Mem[0]);
            CLImage2d<IntBuffer> cLImage2d2 = cLContext.createImage2d(Buffers.newDirectIntBuffer(pixels.length), 128, 128, cLImageFormat, new CLMemory.Mem[0]);
            cLCommandQueue.putWriteImage(cLImage2d, false).putCopyImage(cLImage2d, cLImage2d2).putReadImage(cLImage2d2, true);
            IntBuffer intBuffer = (IntBuffer)cLImage2d.getBuffer();
            IntBuffer intBuffer2 = (IntBuffer)cLImage2d2.getBuffer();
            while (intBuffer.hasRemaining()) {
                Assert.assertEquals(intBuffer.get(), intBuffer2.get());
            }
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void image2dKernelCopyTest() throws IOException {
        CLDevice cLDevice = this.getCompatibleDevice();
        if (cLDevice == null) {
            System.out.println("WARNING: can not test image api.");
            return;
        }
        CLContext cLContext = CLContext.create(cLDevice);
        CLKernel cLKernel = cLContext.createProgram("constant sampler_t imageSampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP | CLK_FILTER_NEAREST; \nkernel void image2dCopy(read_only image2d_t input, write_only image2d_t output) { \n    int2 coord = (int2)(get_global_id(0), get_global_id(1)); \n    uint4 temp = read_imageui(input, imageSampler, coord); \n    write_imageui(output, coord, temp); \n} \n").build().createCLKernel("image2dCopy");
        CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
        try {
            CLImageFormat cLImageFormat = new CLImageFormat(CLImageFormat.ChannelOrder.RGBA, CLImageFormat.ChannelType.UNSIGNED_INT32);
            CLImage2d<IntBuffer> cLImage2d = cLContext.createImage2d(Buffers.newDirectIntBuffer(pixels), 128, 128, cLImageFormat, new CLMemory.Mem[0]);
            CLImage2d<IntBuffer> cLImage2d2 = cLContext.createImage2d(Buffers.newDirectIntBuffer(pixels.length), 128, 128, cLImageFormat, new CLMemory.Mem[0]);
            cLKernel.putArgs(cLImage2d, cLImage2d2);
            cLCommandQueue.putWriteImage(cLImage2d, false).put2DRangeKernel(cLKernel, 0L, 0L, 128L, 128L, 0L, 0L).putReadImage(cLImage2d2, true);
            IntBuffer intBuffer = (IntBuffer)cLImage2d.getBuffer();
            IntBuffer intBuffer2 = (IntBuffer)cLImage2d2.getBuffer();
            while (intBuffer.hasRemaining()) {
                Assert.assertEquals(intBuffer.get(), intBuffer2.get());
            }
        }
        finally {
            cLContext.release();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CLImageTest.class.getName();
        JUnitCore.main(string);
    }
}

