/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.Bitstream;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLMemObjectListener;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLSubBuffer;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.test.util.MiscUtils;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLPlatformFilters;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CLBufferTest
extends UITestCase {
    @Test
    public void createBufferFromLimitedBuffer() {
        CLContext cLContext = CLContext.create();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(40000152);
        byteBuffer.position(76);
        IntBuffer intBuffer = byteBuffer.slice().order(ByteOrder.nativeOrder()).asIntBuffer();
        intBuffer.limit(10000000);
        CLBuffer<IntBuffer> cLBuffer = cLContext.createBuffer(intBuffer, new CLMemory.Mem[0]);
        Assert.assertEquals(10000000L, cLBuffer.getCLCapacity());
        Assert.assertEquals(40000000L, cLBuffer.getNIOSize());
        Assert.assertEquals(10000000L, cLBuffer.getNIOCapacity());
    }

    @Test
    public void cloneWithLimitedBufferTest() {
        CLContext cLContext = CLContext.create();
        IntBuffer intBuffer = ByteBuffer.allocateDirect(40001248).asIntBuffer();
        intBuffer.limit(10000000);
        CLMemory cLMemory = cLContext.createBuffer(40000000, new CLMemory.Mem[0]).cloneWith(intBuffer);
        Assert.assertEquals(10000000L, cLMemory.getCLCapacity());
        Assert.assertEquals(40000000L, cLMemory.getNIOSize());
        Assert.assertEquals(10000000L, cLMemory.getNIOCapacity());
        cLContext.release();
    }

    @Test
    public void copyLimitedSlicedBuffersTest() {
        CLContext cLContext = CLContext.create();
        CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(17107);
        byteBuffer.position(153);
        byteBuffer = byteBuffer.slice();
        byteBuffer.limit(16800);
        byteBuffer.order(ByteOrder.nativeOrder());
        MiscUtils.fillBuffer(byteBuffer, 12345);
        CLMemory cLMemory = cLContext.createBuffer(16800, new CLMemory.Mem[0]).cloneWith(byteBuffer);
        CLBuffer<ByteBuffer> cLBuffer = cLContext.createByteBuffer(16800, new CLMemory.Mem[0]);
        cLCommandQueue.putWriteBuffer((CLBuffer<?>)cLMemory, false).putCopyBuffer((CLBuffer<?>)cLMemory, cLBuffer, cLMemory.getNIOSize()).putReadBuffer(cLBuffer, true).finish();
        byteBuffer.rewind();
        ((ByteBuffer)cLBuffer.buffer).rewind();
        MiscUtils.checkIfEqual(byteBuffer, (ByteBuffer)cLBuffer.buffer, 4200);
        cLContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBufferTest() {
        System.out.println(" - - - highLevelTest; create buffer test - - - ");
        CLContext cLContext = CLContext.create();
        try {
            CLBuffer<ByteBuffer> cLBuffer = cLContext.createByteBuffer(6, new CLMemory.Mem[0]);
            CLBuffer<ShortBuffer> cLBuffer2 = cLContext.createShortBuffer(6, new CLMemory.Mem[0]);
            CLBuffer<IntBuffer> cLBuffer3 = cLContext.createIntBuffer(6, new CLMemory.Mem[0]);
            CLBuffer<LongBuffer> cLBuffer4 = cLContext.createLongBuffer(6, new CLMemory.Mem[0]);
            CLBuffer<FloatBuffer> cLBuffer5 = cLContext.createFloatBuffer(6, new CLMemory.Mem[0]);
            CLBuffer<DoubleBuffer> cLBuffer6 = cLContext.createDoubleBuffer(6, new CLMemory.Mem[0]);
            List<CLMemory<? extends Buffer>> list = cLContext.getMemoryObjects();
            Assert.assertEquals(6L, list.size());
            Assert.assertEquals(1L, cLBuffer.getElementSize());
            Assert.assertEquals(2L, cLBuffer2.getElementSize());
            Assert.assertEquals(4L, cLBuffer3.getElementSize());
            Assert.assertEquals(8L, cLBuffer4.getElementSize());
            Assert.assertEquals(4L, cLBuffer5.getElementSize());
            Assert.assertEquals(8L, cLBuffer6.getElementSize());
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(2);
            for (CLMemory<? extends Buffer> cLMemory : list) {
                CLBuffer cLBuffer7 = (CLBuffer)cLMemory;
                Object b = cLBuffer7.getBuffer();
                Assert.assertEquals(((Buffer)b).capacity(), cLBuffer7.getCLCapacity());
                Assert.assertEquals(cLBuffer7.getNIOSize(), cLBuffer7.getCLSize());
                Assert.assertEquals(Buffers.sizeOfBufferElem(b), cLBuffer7.getElementSize());
                Assert.assertEquals(((Buffer)b).capacity() * Buffers.sizeOfBufferElem(b), cLBuffer7.getCLSize());
                CLMemory cLMemory2 = cLBuffer7.cloneWith(byteBuffer);
                Assert.assertEquals(cLBuffer7.ID, ((CLBuffer)cLMemory2).ID);
                Assert.assertTrue(cLMemory2.equals(cLBuffer7));
                Assert.assertTrue(cLBuffer7.equals(cLMemory2));
                Assert.assertEquals(cLBuffer7.getCLSize(), cLMemory2.getCLCapacity());
                Assert.assertEquals(cLBuffer7.getCLSize(), cLMemory2.getCLSize());
                Assert.assertEquals(byteBuffer.capacity(), cLMemory2.getNIOCapacity());
            }
        }
        finally {
            cLContext.release();
        }
    }

    @Test
    public void writeCopyReadBufferTest() {
        System.out.println(" - - - highLevelTest; copy buffer test - - - ");
        CLContext cLContext = CLContext.create();
        CLBuffer<ByteBuffer> cLBuffer = cLContext.createByteBuffer(40000000, CLMemory.Mem.READ_ONLY);
        CLBuffer<ByteBuffer> cLBuffer2 = cLContext.createByteBuffer(40000000, CLMemory.Mem.READ_ONLY);
        MiscUtils.fillBuffer((ByteBuffer)cLBuffer.buffer, 12345);
        CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue();
        cLCommandQueue.putWriteBuffer(cLBuffer, false).putCopyBuffer(cLBuffer, cLBuffer2, ((ByteBuffer)cLBuffer.buffer).capacity()).putReadBuffer(cLBuffer2, true).finish();
        cLContext.release();
        System.out.println("validating computed results...");
        MiscUtils.checkIfEqual((ByteBuffer)cLBuffer.buffer, (ByteBuffer)cLBuffer2.buffer, 10000000);
        System.out.println("results are valid");
    }

    @Test
    public void bufferWithHostPointerTest() {
        System.out.println(" - - - highLevelTest; host pointer test - - - ");
        CLContext cLContext = CLContext.create();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(40000000);
        MiscUtils.fillBuffer(byteBuffer, 12345);
        CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue();
        CLMemory.Mem[] memArray = new CLMemory.Mem[]{CLMemory.Mem.COPY_BUFFER, CLMemory.Mem.USE_BUFFER};
        for (int i = 0; i < memArray.length; ++i) {
            System.out.println("testing with " + (Object)((Object)memArray[i]) + " config");
            CLBuffer<ByteBuffer> cLBuffer = cLContext.createBuffer(byteBuffer, CLMemory.Mem.READ_ONLY, memArray[i]);
            CLBuffer<ByteBuffer> cLBuffer2 = cLContext.createByteBuffer(40000000, CLMemory.Mem.READ_ONLY);
            cLCommandQueue.putCopyBuffer(cLBuffer, cLBuffer2, ((ByteBuffer)cLBuffer.buffer).capacity()).putReadBuffer(cLBuffer2, true).finish();
            Assert.assertEquals(2L, cLContext.getMemoryObjects().size());
            cLBuffer.release();
            Assert.assertEquals(1L, cLContext.getMemoryObjects().size());
            cLBuffer2.release();
            Assert.assertEquals(0L, cLContext.getMemoryObjects().size());
            System.out.println("validating computed results...");
            MiscUtils.checkIfEqual((ByteBuffer)cLBuffer.buffer, (ByteBuffer)cLBuffer2.buffer, 10000000);
            System.out.println("results are valid");
        }
        cLContext.release();
    }

    @Test
    public void mapBufferTest() {
        CLBuffer<Object> cLBuffer;
        CLBuffer<Object> cLBuffer2;
        CLContext cLContext;
        System.out.println(" - - - highLevelTest; map buffer test - - - ");
        if (CLPlatform.getDefault().listCLDevices(CLDevice.Type.CPU).length > 0) {
            cLContext = CLContext.create(CLDevice.Type.CPU);
            cLBuffer2 = cLContext.createBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
            cLBuffer = cLContext.createBuffer(40000000, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        } else {
            cLContext = CLContext.create();
            cLBuffer2 = cLContext.createByteBuffer(40000000, CLMemory.Mem.READ_WRITE, CLMemory.Mem.USE_BUFFER);
            cLBuffer = cLContext.createByteBuffer(40000000, CLMemory.Mem.READ_WRITE, CLMemory.Mem.USE_BUFFER);
        }
        CLCommandQueue cLCommandQueue = cLContext.getDevices()[0].createCommandQueue();
        ByteBuffer byteBuffer = cLCommandQueue.putMapBuffer(cLBuffer2, CLMemory.Map.WRITE, true);
        Assert.assertEquals(40000000L, byteBuffer.capacity());
        MiscUtils.fillBuffer(byteBuffer, 12345);
        cLCommandQueue.putUnmapMemory(cLBuffer2, byteBuffer).putCopyBuffer(cLBuffer2, cLBuffer);
        ByteBuffer byteBuffer2 = cLCommandQueue.putMapBuffer(cLBuffer, CLMemory.Map.READ, true);
        Assert.assertEquals(40000000L, byteBuffer2.capacity());
        System.out.println("validating computed results...");
        MiscUtils.checkIfEqual(byteBuffer, byteBuffer2, 10000000);
        System.out.println("results are valid");
        cLCommandQueue.putUnmapMemory(cLBuffer, byteBuffer2);
        cLContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subBufferTest01ByteBuffer() {
        System.out.println(" - - - subBufferTest - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault(CLPlatformFilters.version(CLVersion.CL_1_1));
        if (cLPlatform == null) {
            System.out.println("aborting subBufferTest");
            return;
        }
        CLContext cLContext = CLContext.create(cLPlatform);
        try {
            long l = cLContext.getMaxMemBaseAddrAlign();
            int n = Bitstream.uint32LongToInt(l);
            System.err.println("XXX: maxAlignment " + l + ", 0x" + Long.toHexString(l) + ", (int)" + n + ", (int)0x" + Integer.toHexString(n));
            if (-1 == n) {
                throw new RuntimeException("Cannot handle MaxMemBaseAddrAlign > MAX_INT, has 0x" + Long.toHexString(l));
            }
            CLBuffer<int> cLBuffer = cLContext.createBuffer(n + 5, new CLMemory.Mem[0]);
            Assert.assertFalse(cLBuffer.isSubBuffer());
            Assert.assertNotNull(cLBuffer.getSubBuffers());
            Assert.assertTrue(cLBuffer.getSubBuffers().isEmpty());
            CLSubBuffer<int> cLSubBuffer = cLBuffer.createSubBuffer(n, 5, new CLMemory.Mem[0]);
            Assert.assertTrue(cLSubBuffer.isSubBuffer());
            Assert.assertEquals(5L, cLSubBuffer.getCLSize());
            Assert.assertEquals(n, cLSubBuffer.getOffset());
            Assert.assertEquals(n, cLSubBuffer.getCLOffset());
            Assert.assertEquals(cLBuffer, cLSubBuffer.getParent());
            Assert.assertEquals(1L, cLBuffer.getSubBuffers().size());
            cLSubBuffer.release();
            Assert.assertEquals(0L, cLBuffer.getSubBuffers().size());
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subBufferTest02FloatBuffer() {
        System.out.println(" - - - subBufferTest - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault(CLPlatformFilters.version(CLVersion.CL_1_1));
        if (cLPlatform == null) {
            System.out.println("aborting subBufferTest");
            return;
        }
        CLContext cLContext = CLContext.create(cLPlatform);
        try {
            long l = cLContext.getMaxMemBaseAddrAlign();
            int n = Bitstream.uint32LongToInt(l);
            System.err.println("XXX: maxAlignment " + l + ", 0x" + Long.toHexString(l) + ", (int)" + n + ", (int)0x" + Integer.toHexString(n));
            if (-1 == n) {
                throw new RuntimeException("Cannot handle MaxMemBaseAddrAlign > MAX_INT, has 0x" + Long.toHexString(l));
            }
            int n2 = n / 4;
            CLBuffer<FloatBuffer> cLBuffer = cLContext.createFloatBuffer(n2 + 5, new CLMemory.Mem[0]);
            Assert.assertFalse(cLBuffer.isSubBuffer());
            Assert.assertNotNull(cLBuffer.getSubBuffers());
            Assert.assertTrue(cLBuffer.getSubBuffers().isEmpty());
            CLSubBuffer<FloatBuffer> cLSubBuffer = cLBuffer.createSubBuffer(n2, 5, new CLMemory.Mem[0]);
            Assert.assertTrue(cLSubBuffer.isSubBuffer());
            Assert.assertEquals(5L, ((FloatBuffer)cLSubBuffer.getBuffer()).capacity());
            Assert.assertEquals(n2, cLSubBuffer.getOffset());
            Assert.assertEquals(n, cLSubBuffer.getCLOffset());
            Assert.assertEquals(cLBuffer, cLSubBuffer.getParent());
            Assert.assertEquals(1L, cLBuffer.getSubBuffers().size());
            Assert.assertEquals(cLSubBuffer.getCLCapacity(), ((FloatBuffer)cLSubBuffer.getBuffer()).capacity());
            cLSubBuffer.release();
            Assert.assertEquals(0L, cLBuffer.getSubBuffers().size());
        }
        finally {
            cLContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void destructorCallbackTest() throws InterruptedException {
        System.out.println(" - - - destructorCallbackTest - - - ");
        CLPlatform cLPlatform = CLPlatform.getDefault(CLPlatformFilters.version(CLVersion.CL_1_1));
        if (cLPlatform == null) {
            System.out.println("aborting destructorCallbackTest");
            return;
        }
        CLContext cLContext = CLContext.create(cLPlatform);
        try {
            final CLBuffer<int> cLBuffer = cLContext.createBuffer(32, new CLMemory.Mem[0]);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            cLBuffer.registerDestructorCallback(new CLMemObjectListener(){

                @Override
                public void memoryDeallocated(CLMemory<?> cLMemory) {
                    System.out.println("buffer released");
                    Assert.assertEquals(cLMemory, cLBuffer);
                    countDownLatch.countDown();
                }
            });
            cLBuffer.release();
            countDownLatch.await(2L, TimeUnit.SECONDS);
            Assert.assertEquals(countDownLatch.getCount(), 0L);
        }
        finally {
            cLContext.release();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CLBufferTest.class.getName();
        JUnitCore.main(string);
    }
}

