/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.junit;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.sound3d.AudioSystem3D;
import com.jogamp.openal.test.util.UITestCase;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ALDebugExtTest
extends UITestCase {
    @Test
    public void test01DebugExt() {
        ALCdevice aLCdevice;
        ALC aLC = ALFactory.getALC();
        if (!aLC.alcIsExtensionPresent(aLCdevice = aLC.alcOpenDevice(null), "ALC_EXT_debug")) {
            System.err.println("ALCdevice has no ALC_EXT_debug extension");
            return;
        }
        int[] nArray = new int[]{6607, 1};
        ALCcontext aLCcontext = aLC.alcCreateContext(aLCdevice, nArray, 0);
        if (!aLC.alcMakeContextCurrent(aLCcontext)) {
            System.err.println("makeCurrent() failed");
            return;
        }
        System.err.println("-----------------------------------------------------------------------------------------------------");
        AL aL = ALFactory.getAL();
        if (!aL.alIsExtensionPresent("AL_EXT_debug")) {
            System.err.println("Current context has no AL_EXT_debug extension");
            return;
        }
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        final AtomicReference atomicReference = new AtomicReference();
        ALExt.ALDEBUGPROCEXT aLDEBUGPROCEXT = new ALExt.ALDEBUGPROCEXT(){

            @Override
            public void callback(int n, int n2, int n3, int n4, String string, ALCcontext aLCcontext) {
                int n5 = atomicInteger.incrementAndGet();
                if (1 == n5) {
                    atomicReference.set(string);
                }
                System.err.println("AL-Debug[" + n5 + "]: src 0x" + Integer.toHexString(n) + ", type 0x" + Integer.toHexString(n2) + ", id " + n3 + ", severity 0x" + Integer.toHexString(n4) + ", msg '" + string + "', ctx " + aLCcontext);
            }
        };
        AudioSystem3D.getALExt().alDebugMessageCallbackEXT(aLDEBUGPROCEXT, aLCcontext);
        AudioSystem3D.getALExt().alDebugMessageControlEXT(6585, 6594, 6598, 0, null, 0, true);
        AudioSystem3D.getALExt().alDebugMessageInsertEXT(6584, 6594, 0, 6598, "Test Message");
        Assert.assertEquals(1L, atomicInteger.get());
        Assert.assertEquals("Test Message", atomicReference.get());
        aLC.alcDestroyContext(aLCcontext);
        aLC.alcCloseDevice(aLCdevice);
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        ALC aLC = ALFactory.getALC();
        ALCcontext aLCcontext = aLC.alcGetCurrentContext();
        if (null != aLCcontext) {
            aLC.alcDestroyContext(aLCcontext);
            ALCdevice aLCdevice = aLC.alcGetContextsDevice(aLCcontext);
            if (null != aLCdevice) {
                aLC.alcCloseDevice(aLCdevice);
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main(ALDebugExtTest.class.getName());
    }
}

