/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.junit.util;

import com.jogamp.common.net.Uri;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.VersionNumberString;
import japicmp.cmp.JApiCmpArchive;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.output.stdout.StdoutOutputGenerator;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;

public class VersionSemanticsUtil {
    public static void testVersion2(CompatibilityType compatibilityType, File file, VersionNumberString versionNumberString, Class<?> clazz, ClassLoader classLoader, VersionNumberString versionNumberString2, String string, boolean bl) throws IllegalArgumentException, URISyntaxException, IOException {
        Uri uri = JarUtil.getJarUri(clazz.getName(), classLoader).getContainedUri();
        VersionSemanticsUtil.testVersion2(compatibilityType, file, versionNumberString, uri.toFile(), versionNumberString2, string, bl);
    }

    public static void testVersion2(CompatibilityType compatibilityType, File file, VersionNumberString versionNumberString, File file2, VersionNumberString versionNumberString2, String string, boolean bl) throws IllegalArgumentException, IOException, URISyntaxException {
        boolean bl2;
        Options options = Options.newDefault();
        options.setSemanticVersioning(true);
        options.setIgnoreMissingClasses(true);
        options.setReportOnlySummary(bl);
        options.setOutputOnlyBinaryIncompatibleModifications(true);
        if (null != string && string.length() > 0) {
            options.addExcludeFromArgument(Optional.ofNullable(string), false);
        }
        JApiCmpArchive jApiCmpArchive = new JApiCmpArchive(file, versionNumberString.getVersionString());
        JApiCmpArchive jApiCmpArchive2 = new JApiCmpArchive(file2, versionNumberString2.getVersionString());
        Optional optional = jApiCmpArchive.getVersion().getSemanticVersion();
        Optional optional2 = jApiCmpArchive2.getVersion().getSemanticVersion();
        JarArchiveComparatorOptions jarArchiveComparatorOptions = JarArchiveComparatorOptions.of((Options)options);
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(jarArchiveComparatorOptions);
        CompatibilityType compatibilityType2 = CompatibilityType.BACKWARD_COMPATIBLE_IMPLEMENTER;
        List list = jarArchiveComparator.compare(jApiCmpArchive, jApiCmpArchive2);
        ArrayList<JApiClass> arrayList = new ArrayList<JApiClass>(list.size());
        for (JApiClass jApiClass : list) {
            boolean bl3 = jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED && jApiClass.getChangeStatus() != JApiChangeStatus.MODIFIED;
            if (bl3) continue;
            arrayList.add(jApiClass);
            switch (compatibilityType2.ordinal()) {
                case 0: {
                    if (!jApiClass.isBinaryCompatible()) {
                        compatibilityType2 = CompatibilityType.NON_BACKWARD_COMPATIBLE;
                        break;
                    }
                    if (!jApiClass.isSourceCompatible()) {
                        compatibilityType2 = CompatibilityType.BACKWARD_COMPATIBLE_BINARY;
                        break;
                    }
                    compatibilityType2 = CompatibilityType.BACKWARD_COMPATIBLE_SOURCE;
                    break;
                }
                case 1: {
                    if (!jApiClass.isBinaryCompatible()) {
                        compatibilityType2 = CompatibilityType.NON_BACKWARD_COMPATIBLE;
                        break;
                    }
                    if (jApiClass.isSourceCompatible()) break;
                    compatibilityType2 = CompatibilityType.BACKWARD_COMPATIBLE_BINARY;
                    break;
                }
                case 2: {
                    if (jApiClass.isBinaryCompatible()) break;
                    compatibilityType2 = CompatibilityType.NON_BACKWARD_COMPATIBLE;
                    break;
                }
            }
        }
        int n = compatibilityType2.compareTo(compatibilityType);
        boolean bl4 = bl2 = 0 >= n;
        String string2 = 0 > n ? "< " : (0 == n ? "==" : "> ");
        System.err.println("Semantic Version Test (japicmp)");
        System.err.println(" Previous version: " + optional + " - " + file.toString());
        System.err.println(" Current  version: " + optional2 + " - " + file2.toString());
        System.err.println(" Compat. expected: " + (Object)((Object)compatibilityType));
        System.err.println(" Compat. detected: " + (Object)((Object)compatibilityType2));
        System.err.println(" Compat. result:   detected " + string2 + " expected -> " + (bl2 ? "OK" : "ERROR"));
        String string3 = bl2 ? " Current version " + versionNumberString2 + " is " + (Object)((Object)compatibilityType) + " to previous version " + versionNumberString + ", actually " + (Object)((Object)compatibilityType2) : " Current version " + versionNumberString2 + " is not " + (Object)((Object)compatibilityType) + " to previous version " + versionNumberString + ", but " + (Object)((Object)compatibilityType2);
        System.err.println(string3);
        System.err.printf("%n%n", new Object[0]);
        StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options, arrayList);
        System.err.println(stdoutOutputGenerator.generate());
        Assert.assertTrue(string3, bl2);
    }

    public static enum CompatibilityType {
        BACKWARD_COMPATIBLE_IMPLEMENTER,
        BACKWARD_COMPATIBLE_SOURCE,
        BACKWARD_COMPATIBLE_BINARY,
        NON_BACKWARD_COMPATIBLE;

    }
}

