/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.junit.util;

import com.jogamp.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MiscUtils {
    public static CopyStats copy(File file, File file2, int n, boolean bl) throws IOException {
        CopyStats copyStats = new CopyStats();
        copyStats.maxDepth = n;
        copyStats.trackFiles = bl;
        MiscUtils.copy(file, file2, copyStats);
        return copyStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file, File file2, CopyStats copyStats) throws IOException {
        if (file.isDirectory()) {
            if (copyStats.maxDepth >= 0 && copyStats.currentDepth >= copyStats.maxDepth) {
                return;
            }
            ++copyStats.totalFolders;
            if (copyStats.trackFiles) {
                copyStats.srcFiles.add(file);
                copyStats.dstFiles.add(file2);
            }
            ++copyStats.currentDepth;
            if (!file2.exists()) {
                file2.mkdirs();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                File file3 = new File(file, string);
                File file4 = new File(file2, string);
                MiscUtils.copy(file3, file4, copyStats);
            }
            --copyStats.currentDepth;
        } else {
            ++copyStats.totalFiles;
            if (copyStats.trackFiles) {
                copyStats.srcFiles.add(file);
                copyStats.dstFiles.add(file2);
            }
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                copyStats.totalBytes += IOUtil.copyStream2File(bufferedInputStream, file2);
            }
        }
    }

    public static class CopyStats {
        public int totalBytes = 0;
        public int totalFiles = 0;
        public int totalFolders = 0;
        public int currentDepth = 0;
        public int maxDepth = 0;
        public boolean trackFiles;
        public final List<File> srcFiles = new ArrayList<File>();
        public final List<File> dstFiles = new ArrayList<File>();

        public void dump(String string, boolean bl) {
            System.err.println(string + "Total bytes: " + this.totalBytes);
            System.err.println(string + "Total files: " + this.totalFiles);
            System.err.println(string + "Total folder: " + this.totalFolders);
            System.err.println(string + "Depth: " + this.currentDepth / this.maxDepth);
            System.err.println(string + "Tracking: " + this.trackFiles);
            if (this.trackFiles) {
                for (int i = 0; i < this.srcFiles.size(); ++i) {
                    File file = this.srcFiles.get(i);
                    File file2 = this.dstFiles.get(i);
                    if (bl && !file.isDirectory()) continue;
                    System.err.printf("%s\t src %4d: %s%n", string, i, file.toString());
                    System.err.printf("%s\t dst %4d: %s%n%n", string, i, file2.toString());
                }
            }
        }
    }
}

