/**
 * Copyright 2014 JogAmp Community. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JogAmp Community ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JogAmp Community OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of JogAmp Community.
 */
package com.jogamp.plugin.applet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;

/**
 * Provided by Plugin implementation.
 */
public interface Applet3Context {
    /**
     * Returns the {@link Applet3} bound to this context
     */
    Applet3 getApplet();
    
    String getAppletName();
    
    boolean isActive();
    String getParameter(String name);
    URL getDocumentBase();
    URL getCodeBase();
    
    /**
     * Requests that this applet be resized.
     *
     * @param   width    the new requested width for the applet.
     * @param   height   the new requested height for the applet.
     */
    void resize(int width, int height);

    /**
     * Returns the {@link Applet3Context} within this context domain,
     * referenced by the document, codebase and the given <code>name</code>.
     * <p> 
     * The <code>name</code> can be set in the HTML tag by setting the <code>name</code> attribute.
     * </p>
     */
    Applet3Context getAppletContext(String name);

    /**
     * Returns all {@link Applet3Context} within this context domain,
     * referenced by the document and codebase. 
     */
    Enumeration<Applet3Context> getAllAppletContexts();
    
    void showDocument(URL url);

    void showDocument(URL url, String target);

    void showStatus(String status);

    void setStream(String key, InputStream stream)throws IOException;

    InputStream getStream(String key);

    Iterator<String> getStreamKeys();

}
