/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLContext;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;

public class EGLUpstreamSurfaceHook
implements UpstreamSurfaceHook.MutableSize {
    protected static final boolean DEBUG = EGLDrawableFactory.DEBUG;
    private final NativeSurface upstreamSurface;
    private final UpstreamSurfaceHook.MutableSize upstreamSurfaceHookMutableSize;

    public EGLUpstreamSurfaceHook(NativeSurface nativeSurface) {
        UpstreamSurfaceHook upstreamSurfaceHook;
        this.upstreamSurface = nativeSurface;
        this.upstreamSurfaceHookMutableSize = this.upstreamSurface instanceof ProxySurface ? ((upstreamSurfaceHook = ((ProxySurface)this.upstreamSurface).getUpstreamSurfaceHook()) instanceof UpstreamSurfaceHook.MutableSize ? (UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook : null) : null;
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }

    @Override
    public final NativeSurface getUpstreamSurface() {
        return this.upstreamSurface;
    }

    @Override
    public final void setSurfaceSize(int n, int n2) {
        if (null != this.upstreamSurfaceHookMutableSize) {
            this.upstreamSurfaceHookMutableSize.setSurfaceSize(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void create(ProxySurface proxySurface) {
        String string;
        if (DEBUG) {
            string = EGLUpstreamSurfaceHook.getThreadName() + ": EGLUpstreamSurfaceHook.create( up " + this.upstreamSurface.getClass().getSimpleName() + " -> this " + proxySurface.getClass().getSimpleName() + " ): ";
            System.err.println(string + this);
        } else {
            string = null;
        }
        if (this.upstreamSurface instanceof ProxySurface) {
            ((ProxySurface)this.upstreamSurface).createNotify();
        }
        if (1 >= this.upstreamSurface.lockSurface()) {
            throw new GLException("Could not lock: " + this.upstreamSurface);
        }
        try {
            this.evalUpstreamSurface(string, proxySurface);
        }
        finally {
            this.upstreamSurface.unlockSurface();
        }
    }

    private final void evalUpstreamSurface(String string, ProxySurface proxySurface) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        EGLGraphicsDevice eGLGraphicsDevice;
        Cloneable cloneable;
        boolean bl = true;
        VisualIDHolder visualIDHolder = proxySurface.getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = cloneable = null != visualIDHolder ? visualIDHolder.getScreen().getDevice() : null;
        if (DEBUG) {
            System.err.println(string + "SurfaceDevice: " + cloneable.getClass().getSimpleName() + ", hash 0x" + Integer.toHexString(cloneable.hashCode()) + ", " + cloneable);
            System.err.println(string + "SurfaceConfig: " + visualIDHolder.getClass().getSimpleName() + ", hash 0x" + Integer.toHexString(visualIDHolder.hashCode()) + ", " + visualIDHolder);
        }
        Cloneable cloneable2 = this.upstreamSurface.getGraphicsConfiguration();
        Cloneable cloneable3 = cloneable2.getScreen().getDevice();
        if (DEBUG) {
            System.err.println(string + "UpstreamDevice: " + cloneable3.getClass().getSimpleName() + ", hash 0x" + Integer.toHexString(cloneable3.hashCode()) + ", " + cloneable3);
            System.err.println(string + "UpstreamConfig: " + cloneable2.getClass().getSimpleName() + ", hash 0x" + Integer.toHexString(cloneable2.hashCode()) + ", " + cloneable2);
        }
        if (cloneable instanceof EGLGraphicsDevice) {
            eGLGraphicsDevice = (EGLGraphicsDevice)cloneable;
            abstractGraphicsConfiguration = visualIDHolder;
            if (DEBUG) {
                System.err.println(string + "Reusing this eglDevice: " + eGLGraphicsDevice + ", using this config " + abstractGraphicsConfiguration.getClass().getSimpleName() + " " + abstractGraphicsConfiguration);
            }
            if (0L == eGLGraphicsDevice.getHandle()) {
                eGLGraphicsDevice.open();
                bl = false;
                proxySurface.addUpstreamOptionBits(128);
            }
        } else if (cloneable3 instanceof EGLGraphicsDevice) {
            eGLGraphicsDevice = (EGLGraphicsDevice)cloneable3;
            abstractGraphicsConfiguration = cloneable2;
            if (DEBUG) {
                System.err.println(string + "Reusing upstream eglDevice: " + eGLGraphicsDevice + ", using upstream config " + abstractGraphicsConfiguration.getClass().getSimpleName() + " " + abstractGraphicsConfiguration);
            }
            if (0L == eGLGraphicsDevice.getHandle()) {
                eGLGraphicsDevice.open();
                bl = false;
                proxySurface.addUpstreamOptionBits(128);
            }
        } else {
            eGLGraphicsDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(this.upstreamSurface);
            eGLGraphicsDevice.open();
            abstractGraphicsConfiguration = cloneable2;
            bl = false;
            proxySurface.addUpstreamOptionBits(128);
        }
        visualIDHolder = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getRequestedCapabilities();
        if (abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration) {
            cloneable2 = (EGLGLCapabilities)abstractGraphicsConfiguration.getChosenCapabilities();
            if (!bl || !EGLGraphicsConfiguration.isEGLConfigValid(eGLGraphicsDevice.getHandle(), ((EGLGLCapabilities)cloneable2).getEGLConfig())) {
                ((EGLGLCapabilities)cloneable2).setEGLConfig(EGLGraphicsConfiguration.EGLConfigId2EGLConfig(eGLGraphicsDevice.getHandle(), ((EGLGLCapabilities)cloneable2).getEGLConfigID()));
                if (0L == ((EGLGLCapabilities)cloneable2).getEGLConfig()) {
                    throw new GLException("Refreshing native EGLConfig handle failed with error " + EGLContext.toHexString(EGL.eglGetError()) + ": " + eGLGraphicsDevice + ", " + cloneable2 + " of " + abstractGraphicsConfiguration);
                }
                cloneable3 = new DefaultGraphicsScreen(eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
                cloneable = new EGLGraphicsConfiguration((AbstractGraphicsScreen)cloneable3, (EGLGLCapabilities)cloneable2, (GLCapabilitiesImmutable)visualIDHolder, null);
                if (DEBUG) {
                    System.err.println(string + "Refreshing eglConfig: " + cloneable);
                }
                bl = false;
            } else {
                cloneable = (EGLGraphicsConfiguration)abstractGraphicsConfiguration;
                if (DEBUG) {
                    System.err.println(string + "Reusing eglConfig: " + cloneable);
                }
            }
        } else {
            cloneable2 = new DefaultGraphicsScreen(eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
            cloneable = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)visualIDHolder, (GLCapabilitiesImmutable)visualIDHolder, null, (AbstractGraphicsScreen)cloneable2, abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE), false);
            if (null == cloneable) {
                throw new GLException("Couldn't create EGLGraphicsConfiguration from " + cloneable2);
            }
            if (DEBUG) {
                System.err.println(string + "Chosen eglConfig: " + cloneable);
            }
            bl = false;
        }
        proxySurface.setGraphicsConfiguration((AbstractGraphicsConfiguration)cloneable);
        if (bl) {
            bl = EGLDrawable.isValidEGLSurface(eGLGraphicsDevice.getHandle(), this.upstreamSurface.getSurfaceHandle());
        }
        if (bl) {
            proxySurface.setSurfaceHandle(this.upstreamSurface.getSurfaceHandle());
            proxySurface.clearUpstreamOptionBits(64);
            if (DEBUG) {
                System.err.println(string + "Fin: Already valid EGL surface - use as-is: " + this.upstreamSurface);
            }
        } else {
            proxySurface.setSurfaceHandle(0L);
            proxySurface.addUpstreamOptionBits(64);
            if (DEBUG) {
                System.err.println(string + "Fin: EGL surface n/a - TBD: " + this.upstreamSurface);
            }
        }
    }

    @Override
    public final void destroy(ProxySurface proxySurface) {
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLUpstreamSurfaceHook.destroy(" + proxySurface.getClass().getSimpleName() + "): " + this);
        }
        proxySurface.clearUpstreamOptionBits(64);
        if (this.upstreamSurface instanceof ProxySurface) {
            ((ProxySurface)this.upstreamSurface).destroyNotify();
        }
    }

    @Override
    public final int getSurfaceWidth(ProxySurface proxySurface) {
        return this.upstreamSurface.getSurfaceWidth();
    }

    @Override
    public final int getSurfaceHeight(ProxySurface proxySurface) {
        return this.upstreamSurface.getSurfaceHeight();
    }

    public String toString() {
        int n;
        int n2;
        String string;
        if (null != this.upstreamSurface) {
            string = this.upstreamSurface.getClass().getName() + ": 0x" + Long.toHexString(this.upstreamSurface.getSurfaceHandle());
            n2 = this.upstreamSurface.getSurfaceWidth();
            n = this.upstreamSurface.getSurfaceHeight();
        } else {
            string = "nil";
            n2 = -1;
            n = -1;
        }
        return "EGLUpstreamSurfaceHook[ " + n2 + "x" + n + ", " + string + "]";
    }
}

