/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.opengl.math.geom.AABBox;

public class TypecastGlyph
implements Font.Glyph {
    public static final short INVALID_ID = -1;
    public static final short MAX_ID = -2;
    private final Font font;
    private final char symbol;
    private final OutlineShape shape;
    private final short id;
    private final int advance;
    private final Metrics metrics;

    protected TypecastGlyph(Font font, char c, short s, AABBox aABBox, int n, OutlineShape outlineShape) {
        this.font = font;
        this.symbol = c;
        this.shape = outlineShape;
        this.id = s;
        this.advance = n;
        this.metrics = new Metrics(this.font, aABBox, this.advance);
    }

    @Override
    public final Font getFont() {
        return this.font;
    }

    @Override
    public final char getSymbol() {
        return this.symbol;
    }

    final AABBox getBBoxUnsized() {
        return this.metrics.getBBox();
    }

    @Override
    public final AABBox getBBox() {
        return this.metrics.getBBox();
    }

    public final Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public final short getID() {
        return this.id;
    }

    @Override
    public final float getScale(float f) {
        return this.metrics.getScale(f);
    }

    @Override
    public final AABBox getBBox(AABBox aABBox, float f, float[] fArray) {
        return aABBox.copy(this.getBBox()).scale(this.getScale(f), fArray);
    }

    protected final void addAdvance(float f, float f2) {
        this.metrics.addAdvance(f, f2);
    }

    @Override
    public final float getAdvance(float f, boolean bl) {
        return this.metrics.getAdvance(f, bl);
    }

    @Override
    public final OutlineShape getShape() {
        return this.shape;
    }

    @Override
    public final int hashCode() {
        int n = 31 + this.font.getName(3).hashCode();
        return (n << 5) - n + this.id;
    }

    public static class Metrics {
        private final AABBox bbox;
        private final Advance advance;

        public Metrics(Font font, AABBox aABBox, float f) {
            this.bbox = aABBox;
            this.advance = new Advance(font, f);
        }

        public void reset() {
            this.advance.reset();
        }

        public float getScale(float f) {
            return this.advance.getScale(f);
        }

        public AABBox getBBox() {
            return this.bbox;
        }

        public void addAdvance(float f, float f2) {
            this.advance.add(f, f2);
        }

        public float getAdvance(float f, boolean bl) {
            return this.advance.get(f, bl);
        }

        public String toString() {
            return "\nMetrics:\n  bbox: " + this.bbox + this.advance;
        }
    }

    public static class Advance {
        private final Font font;
        private final float advance;
        private final IntIntHashMap size2advanceI = new IntIntHashMap();

        public Advance(Font font, float f) {
            this.font = font;
            this.advance = f;
            this.size2advanceI.setKeyNotFoundValue(0);
        }

        public void reset() {
            this.size2advanceI.clear();
        }

        public float getScale(float f) {
            return this.font.getMetrics().getScale(f);
        }

        public void add(float f, float f2) {
            this.size2advanceI.put(Float.floatToIntBits(f2), Float.floatToIntBits(f));
        }

        public float get(float f, boolean bl) {
            int n = Float.floatToIntBits(f);
            int n2 = this.size2advanceI.get(n);
            if (0 != n2) {
                return Float.intBitsToFloat(n2);
            }
            float f2 = bl ? this.advance * this.getScale(f) : (float)Math.round(this.advance * this.getScale(f));
            this.size2advanceI.put(n, Float.floatToIntBits(f2));
            return f2;
        }

        public String toString() {
            return "\nAdvance:\n  advance: " + this.advance + "\n advances: \n" + this.size2advanceI;
        }
    }
}

