/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Quaternion;

public class Matrix4 {
    private final float[] matrix = new float[16];
    private final float[] matrixTxSx = new float[16];
    private final float[] mat4Tmp1 = new float[16];
    private final float[] vec4Tmp1 = new float[4];

    public Matrix4() {
        FloatUtil.makeIdentity(this.matrixTxSx);
        this.loadIdentity();
    }

    public final float[] getMatrix() {
        return this.matrix;
    }

    public final void loadIdentity() {
        FloatUtil.makeIdentity(this.matrix);
    }

    public final void multMatrix(float[] fArray, int n) {
        FloatUtil.multMatrix(this.matrix, 0, fArray, n);
    }

    public final void multMatrix(float[] fArray) {
        FloatUtil.multMatrix(this.matrix, fArray);
    }

    public final void multMatrix(Matrix4 matrix4) {
        FloatUtil.multMatrix(this.matrix, matrix4.getMatrix());
    }

    public final void multVec(float[] fArray, float[] fArray2) {
        FloatUtil.multMatrixVec(this.matrix, fArray, fArray2);
    }

    public final void multVec(float[] fArray, int n, float[] fArray2, int n2) {
        FloatUtil.multMatrixVec(this.matrix, 0, fArray, n, fArray2, n2);
    }

    public final void translate(float f, float f2, float f3) {
        this.multMatrix(FloatUtil.makeTranslation(this.matrixTxSx, false, f, f2, f3));
    }

    public final void scale(float f, float f2, float f3) {
        this.multMatrix(FloatUtil.makeScale(this.matrixTxSx, false, f, f2, f3));
    }

    public final void rotate(float f, float f2, float f3, float f4) {
        this.multMatrix(FloatUtil.makeRotationAxis(this.mat4Tmp1, 0, f, f2, f3, f4, this.vec4Tmp1));
    }

    public final void rotate(Quaternion quaternion) {
        this.multMatrix(quaternion.toMatrix(this.mat4Tmp1, 0));
    }

    public final void transpose() {
        System.arraycopy(this.matrix, 0, this.mat4Tmp1, 0, 16);
        FloatUtil.transposeMatrix(this.mat4Tmp1, this.matrix);
    }

    public final float determinant() {
        return FloatUtil.matrixDeterminant(this.matrix);
    }

    public final boolean invert() {
        return null != FloatUtil.invertMatrix(this.matrix, this.matrix);
    }

    public final void makeOrtho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.multMatrix(FloatUtil.makeOrtho(this.mat4Tmp1, 0, true, f, f2, f3, f4, f5, f6));
    }

    public final void makeFrustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.multMatrix(FloatUtil.makeFrustum(this.mat4Tmp1, 0, true, f, f2, f3, f4, f5, f6));
    }

    public final void makePerspective(float f, float f2, float f3, float f4) {
        this.multMatrix(FloatUtil.makePerspective(this.mat4Tmp1, 0, true, f, f2, f3, f4));
    }
}

