/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.tess.Triangulation;
import com.jogamp.graph.curve.tess.Triangulator;
import com.jogamp.graph.geom.Outline;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jogamp.graph.geom.plane.AffineTransform;

public class OutlineShape
implements Comparable<OutlineShape> {
    public static final float DEFAULT_SHARPNESS = 0.5f;
    public static final int DIRTY_BOUNDS = 1;
    public static final int DIRTY_VERTICES = 2;
    public static final int DIRTY_TRIANGLES = 4;
    private final Vertex.Factory<? extends Vertex> vertexFactory;
    final ArrayList<Outline> outlines;
    private final AABBox bbox;
    private final ArrayList<Triangle> triangles;
    private final ArrayList<Vertex> vertices;
    private int addedVerticeCount;
    private VerticesState outlineState;
    private int dirtyBits;
    private float sharpness;
    private final float[] tmpV1 = new float[3];
    private final float[] tmpV2 = new float[3];
    private final float[] tmpV3 = new float[3];
    private static Comparator<Outline> reversSizeComparator = new Comparator<Outline>(){

        @Override
        public int compare(Outline outline, Outline outline2) {
            return outline2.compareTo(outline);
        }
    };

    public OutlineShape(Vertex.Factory<? extends Vertex> factory) {
        this.vertexFactory = factory;
        this.outlines = new ArrayList(3);
        this.outlines.add(new Outline());
        this.outlineState = VerticesState.UNDEFINED;
        this.bbox = new AABBox();
        this.triangles = new ArrayList();
        this.vertices = new ArrayList();
        this.addedVerticeCount = 0;
        this.dirtyBits = 0;
        this.sharpness = 0.5f;
    }

    public int getAddedVerticeCount() {
        return this.addedVerticeCount;
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public void setSharpness(float f) {
        if (this.sharpness != f) {
            this.clearCache();
            this.sharpness = f;
        }
    }

    public void clear() {
        this.outlines.clear();
        this.outlines.add(new Outline());
        this.outlineState = VerticesState.UNDEFINED;
        this.bbox.reset();
        this.vertices.clear();
        this.triangles.clear();
        this.addedVerticeCount = 0;
        this.dirtyBits = 0;
    }

    public void clearCache() {
        this.vertices.clear();
        this.triangles.clear();
        this.dirtyBits |= 6;
    }

    public final Vertex.Factory<? extends Vertex> vertexFactory() {
        return this.vertexFactory;
    }

    public final int getOutlineNumber() {
        return this.outlines.size();
    }

    public final void addEmptyOutline() {
        if (!this.getLastOutline().isEmpty()) {
            this.outlines.add(new Outline());
        }
    }

    public final void addOutline(Outline outline) throws NullPointerException {
        this.addOutline(this.outlines.size(), outline);
    }

    public final void addOutline(int n, Outline outline) throws NullPointerException, IndexOutOfBoundsException {
        if (null == outline) {
            throw new NullPointerException("outline is null");
        }
        if (this.outlines.size() == n) {
            Outline outline2 = this.getLastOutline();
            if (outline.isEmpty() && outline2.isEmpty()) {
                return;
            }
            if (outline2.isEmpty()) {
                this.outlines.set(n - 1, outline);
                if (0 == (this.dirtyBits & 1)) {
                    this.bbox.resize(outline.getBounds());
                }
                this.dirtyBits |= 6;
                return;
            }
        }
        this.outlines.add(n, outline);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(outline.getBounds());
        }
        this.dirtyBits |= 6;
    }

    public final void addOutlineShape(OutlineShape outlineShape) throws NullPointerException {
        if (null == outlineShape) {
            throw new NullPointerException("OutlineShape is null");
        }
        this.closeLastOutline(true);
        for (int i = 0; i < outlineShape.getOutlineNumber(); ++i) {
            this.addOutline(outlineShape.getOutline(i));
        }
    }

    public final void setOutline(int n, Outline outline) throws NullPointerException, IndexOutOfBoundsException {
        if (null == outline) {
            throw new NullPointerException("outline is null");
        }
        this.outlines.set(n, outline);
        this.dirtyBits |= 7;
    }

    public final Outline removeOutline(int n) throws IndexOutOfBoundsException {
        this.dirtyBits |= 7;
        return this.outlines.remove(n);
    }

    public final Outline getLastOutline() {
        return this.outlines.get(this.outlines.size() - 1);
    }

    public final Outline getOutline(int n) throws IndexOutOfBoundsException {
        return this.outlines.get(n);
    }

    public final void addVertex(Vertex vertex) {
        Outline outline = this.getLastOutline();
        outline.addVertex(vertex);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(vertex.getCoord());
        }
        this.dirtyBits |= 6;
    }

    public final void addVertex(int n, Vertex vertex) {
        Outline outline = this.getLastOutline();
        outline.addVertex(n, vertex);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(vertex.getCoord());
        }
        this.dirtyBits |= 6;
    }

    public final void addVertex(float f, float f2, boolean bl) {
        this.addVertex(this.vertexFactory.create(f, f2, 0.0f, bl));
    }

    public final void addVertex(float f, float f2, float f3, boolean bl) {
        this.addVertex(this.vertexFactory.create(f, f2, f3, bl));
    }

    public final void addVertex(float[] fArray, int n, int n2, boolean bl) {
        this.addVertex(this.vertexFactory.create(fArray, n, n2, bl));
    }

    public final void closeLastOutline(boolean bl) {
        if (this.getLastOutline().setClosed(true)) {
            this.dirtyBits |= 6;
        }
    }

    public final VerticesState getOutlineState() {
        return this.outlineState;
    }

    public final void setIsQuadraticNurbs() {
        this.outlineState = VerticesState.QUADRATIC_NURBS;
    }

    private void subdivideTriangle(Outline outline, Vertex vertex, Vertex vertex2, Vertex vertex3, int n) {
        VectorUtil.midVec3(this.tmpV1, vertex.getCoord(), vertex2.getCoord());
        VectorUtil.midVec3(this.tmpV3, vertex2.getCoord(), vertex3.getCoord());
        VectorUtil.midVec3(this.tmpV2, this.tmpV1, this.tmpV3);
        vertex2.setCoord(this.tmpV2, 0, 3);
        vertex2.setOnCurve(true);
        outline.addVertex(n, this.vertexFactory.create(this.tmpV1, 0, 3, false));
        outline.addVertex(n + 2, this.vertexFactory.create(this.tmpV3, 0, 3, false));
        this.addedVerticeCount += 2;
    }

    private void checkOverlaps() {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>(3);
        int n = this.getOutlineNumber();
        boolean bl = true;
        do {
            for (int i = 0; i < n; ++i) {
                Outline outline = this.getOutline(i);
                int n2 = outline.getVertexCount();
                for (int j = 0; j < outline.getVertexCount(); ++j) {
                    Vertex vertex = outline.getVertex(j);
                    if (vertex.isOnCurve()) continue;
                    Vertex vertex2 = outline.getVertex((j + 1) % n2);
                    Vertex vertex3 = outline.getVertex((j + n2 - 1) % n2);
                    Vertex vertex4 = bl ? this.checkTriOverlaps0(vertex3, vertex, vertex2) : null;
                    if (!arrayList.contains(vertex) && vertex4 == null) continue;
                    arrayList.remove(vertex);
                    this.subdivideTriangle(outline, vertex3, vertex, vertex2, j);
                    j += 3;
                    n2 += 2;
                    this.addedVerticeCount += 2;
                    if (vertex4 == null || vertex4.isOnCurve() || arrayList.contains(vertex4)) continue;
                    arrayList.add(vertex4);
                }
            }
            bl = false;
        } while (!arrayList.isEmpty());
    }

    private Vertex checkTriOverlaps0(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        int n = this.getOutlineNumber();
        for (int i = 0; i < n; ++i) {
            Outline outline = this.getOutline(i);
            int n2 = outline.getVertexCount();
            for (int j = 0; j < n2; ++j) {
                Vertex vertex4 = outline.getVertex(j);
                if (vertex4.isOnCurve() || vertex4 == vertex || vertex4 == vertex2 || vertex4 == vertex3) continue;
                Vertex vertex5 = outline.getVertex((j + 1) % n2);
                Vertex vertex6 = outline.getVertex((j + n2 - 1) % n2);
                if (vertex6 == vertex3 || vertex5 == vertex) continue;
                if (VectorUtil.isVec3InTriangle3(vertex.getCoord(), vertex2.getCoord(), vertex3.getCoord(), vertex4.getCoord(), vertex5.getCoord(), vertex6.getCoord(), this.tmpV1, this.tmpV2, this.tmpV3)) {
                    return vertex4;
                }
                if (!VectorUtil.testTri2SegIntersection(vertex, vertex2, vertex3, vertex6, vertex4) && !VectorUtil.testTri2SegIntersection(vertex, vertex2, vertex3, vertex4, vertex5) && !VectorUtil.testTri2SegIntersection(vertex, vertex2, vertex3, vertex6, vertex5)) continue;
                return vertex4;
            }
        }
        return null;
    }

    private Vertex checkTriOverlaps1(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        int n = this.getOutlineNumber();
        for (int i = 0; i < n; ++i) {
            Outline outline = this.getOutline(i);
            int n2 = outline.getVertexCount();
            for (int j = 0; j < n2; ++j) {
                Vertex vertex4 = outline.getVertex(j);
                if (vertex4.isOnCurve() || vertex4 == vertex || vertex4 == vertex2 || vertex4 == vertex3) continue;
                Vertex vertex5 = outline.getVertex((j + 1) % n2);
                Vertex vertex6 = outline.getVertex((j + n2 - 1) % n2);
                if (vertex6 == vertex3 || vertex5 == vertex) continue;
                if (VectorUtil.isVec3InTriangle3(vertex.getCoord(), vertex2.getCoord(), vertex3.getCoord(), vertex4.getCoord(), vertex5.getCoord(), vertex6.getCoord(), this.tmpV1, this.tmpV2, this.tmpV3, 1.1920929E-7f)) {
                    return vertex4;
                }
                if (!VectorUtil.testTri2SegIntersection(vertex, vertex2, vertex3, vertex6, vertex4, 1.1920929E-7f) && !VectorUtil.testTri2SegIntersection(vertex, vertex2, vertex3, vertex4, vertex5, 1.1920929E-7f) && !VectorUtil.testTri2SegIntersection(vertex, vertex2, vertex3, vertex6, vertex5, 1.1920929E-7f)) continue;
                return vertex4;
            }
        }
        return null;
    }

    private void cleanupOutlines() {
        boolean bl = VerticesState.QUADRATIC_NURBS != this.outlineState;
        int n = this.getOutlineNumber();
        for (int i = 0; i < n; ++i) {
            Outline outline = this.getOutline(i);
            int n2 = outline.getVertexCount();
            if (bl) {
                for (int j = 0; j < n2; ++j) {
                    Vertex vertex = outline.getVertex(j);
                    int n3 = (j + 1) % n2;
                    Vertex vertex2 = outline.getVertex(n3);
                    if (vertex.isOnCurve() || vertex2.isOnCurve()) continue;
                    VectorUtil.midVec3(this.tmpV1, vertex.getCoord(), vertex2.getCoord());
                    System.err.println("XXX: Cubic: " + j + ": " + vertex + ", " + n3 + ": " + vertex2);
                    Vertex vertex3 = this.vertexFactory.create(this.tmpV1, 0, 3, true);
                    ++n2;
                    ++this.addedVerticeCount;
                    outline.addVertex(++j, vertex3);
                }
            }
            if (0 >= n2) {
                this.outlines.remove(outline);
                --i;
                --n;
                continue;
            }
            if (0 >= n2 || !VectorUtil.isVec3Equal(outline.getVertex(0).getCoord(), 0, outline.getLastVertex().getCoord(), 0, 1.1920929E-7f)) continue;
            outline.removeVertex(n2 - 1);
        }
        this.outlineState = VerticesState.QUADRATIC_NURBS;
        this.checkOverlaps();
    }

    private int generateVertexIds() {
        int n = 0;
        for (int i = 0; i < this.outlines.size(); ++i) {
            ArrayList<Vertex> arrayList = this.outlines.get(i).getVertices();
            for (int j = 0; j < arrayList.size(); ++j) {
                arrayList.get(j).setId(n++);
            }
        }
        return n;
    }

    public final ArrayList<Vertex> getVertices() {
        boolean bl;
        if (0 != (2 & this.dirtyBits)) {
            this.vertices.clear();
            for (int i = 0; i < this.outlines.size(); ++i) {
                this.vertices.addAll(this.outlines.get(i).getVertices());
            }
            this.dirtyBits &= 0xFFFFFFFD;
            bl = true;
        } else {
            bl = false;
        }
        if (Region.DEBUG_INSTANCE) {
            System.err.println("OutlineShape.getVertices(): o " + this.outlines.size() + ", v " + this.vertices.size() + ", updated " + bl);
        }
        return this.vertices;
    }

    private void triangulateImpl() {
        if (0 < this.outlines.size()) {
            this.sortOutlines();
            this.generateVertexIds();
            this.triangles.clear();
            Triangulator triangulator = Triangulation.create();
            for (int i = 0; i < this.outlines.size(); ++i) {
                triangulator.addCurve(this.triangles, this.outlines.get(i), this.sharpness);
            }
            triangulator.generate(this.triangles);
            this.addedVerticeCount += triangulator.getAddedVerticeCount();
            triangulator.reset();
        }
    }

    public ArrayList<Triangle> getTriangles(VerticesState verticesState) {
        boolean bl;
        if (verticesState != VerticesState.QUADRATIC_NURBS) {
            throw new IllegalStateException("destinationType " + verticesState.name() + " not supported (currently " + this.outlineState.name() + ")");
        }
        if (0 != (4 & this.dirtyBits)) {
            this.cleanupOutlines();
            this.triangulateImpl();
            bl = true;
            this.dirtyBits |= 2;
            this.dirtyBits &= 0xFFFFFFFB;
        } else {
            bl = false;
        }
        if (Region.DEBUG_INSTANCE) {
            System.err.println("OutlineShape.getTriangles().X: " + this.triangles.size() + ", updated " + bl);
        }
        return this.triangles;
    }

    public final OutlineShape transform(AffineTransform affineTransform) {
        OutlineShape outlineShape = new OutlineShape(this.vertexFactory);
        int n = this.outlines.size();
        for (int i = 0; i < n; ++i) {
            outlineShape.addOutline(this.outlines.get(i).transform(affineTransform, this.vertexFactory));
        }
        return outlineShape;
    }

    private void sortOutlines() {
        Collections.sort(this.outlines, reversSizeComparator);
    }

    @Override
    public final int compareTo(OutlineShape outlineShape) {
        float f;
        float f2 = this.getBounds().getSize();
        if (FloatUtil.isEqual(f2, f = outlineShape.getBounds().getSize(), 1.1920929E-7f)) {
            return 0;
        }
        if (f2 < f) {
            return -1;
        }
        return 1;
    }

    private void validateBoundingBox() {
        this.dirtyBits &= 0xFFFFFFFE;
        this.bbox.reset();
        for (int i = 0; i < this.outlines.size(); ++i) {
            this.bbox.resize(this.outlines.get(i).getBounds());
        }
    }

    public final AABBox getBounds() {
        if (0 == (this.dirtyBits & 1)) {
            this.validateBoundingBox();
        }
        return this.bbox;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof OutlineShape)) {
            return false;
        }
        OutlineShape outlineShape = (OutlineShape)object;
        if (this.getOutlineState() != outlineShape.getOutlineState()) {
            return false;
        }
        if (this.getOutlineNumber() != outlineShape.getOutlineNumber()) {
            return false;
        }
        if (!this.getBounds().equals(outlineShape.getBounds())) {
            return false;
        }
        for (int i = this.getOutlineNumber() - 1; i >= 0; --i) {
            if (this.getOutline(i).equals(outlineShape.getOutline(i))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public static enum VerticesState {
        UNDEFINED(0),
        QUADRATIC_NURBS(1);

        public final int state;

        private VerticesState(int n2) {
            this.state = n2;
        }
    }
}

