/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections.transformation;

import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.collections.WeakListChangeListener;

public abstract class TransformationList<E, F>
extends ObservableListBase<E>
implements ObservableList<E> {
    private ObservableList<? extends F> source;
    private ListChangeListener<F> sourceListener;

    protected TransformationList(ObservableList<? extends F> source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
        source.addListener(new WeakListChangeListener<F>(this.getListener()));
    }

    public final ObservableList<? extends F> getSource() {
        return this.source;
    }

    public final boolean isInTransformationChain(ObservableList<?> list) {
        if (this.source == list) {
            return true;
        }
        ObservableList<Object> currentSource = this.source;
        while (currentSource instanceof TransformationList) {
            currentSource = ((TransformationList)currentSource).source;
            if (currentSource != list) continue;
            return true;
        }
        return false;
    }

    private ListChangeListener<F> getListener() {
        if (this.sourceListener == null) {
            this.sourceListener = c -> this.sourceChanged(c);
        }
        return this.sourceListener;
    }

    protected abstract void sourceChanged(ListChangeListener.Change<? extends F> var1);

    public abstract int getSourceIndex(int var1);

    public final int getSourceIndexFor(ObservableList<?> list, int index) {
        if (!this.isInTransformationChain(list)) {
            throw new IllegalArgumentException("Provided list is not in the transformation chain of thistransformation list");
        }
        ObservableList<? extends F> currentSource = this.source;
        int idx = this.getSourceIndex(index);
        while (currentSource != list && currentSource instanceof TransformationList) {
            TransformationList tSource = (TransformationList)currentSource;
            idx = tSource.getSourceIndex(idx);
            currentSource = tSource.source;
        }
        return idx;
    }

    public abstract int getViewIndex(int var1);
}

