/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.NumberExpressionBase;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableFloatValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class FloatExpression
extends NumberExpressionBase
implements ObservableFloatValue {
    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.get());
    }

    public static FloatExpression floatExpression(final ObservableFloatValue value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof FloatExpression ? (FloatExpression)value : new FloatBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected float computeValue() {
                return value.get();
            }

            @Override
            public ObservableList<ObservableFloatValue> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    public static <T extends Number> FloatExpression floatExpression(final ObservableValue<T> value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof FloatExpression ? (FloatExpression)value : new FloatBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected float computeValue() {
                Number val = (Number)value.getValue();
                return val == null ? 0.0f : val.floatValue();
            }

            @Override
            public ObservableList<ObservableValue<T>> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    @Override
    public FloatBinding negate() {
        return (FloatBinding)Bindings.negate(this);
    }

    @Override
    public DoubleBinding add(double other) {
        return Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding add(float other) {
        return (FloatBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding add(long other) {
        return (FloatBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding add(int other) {
        return (FloatBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding subtract(double other) {
        return Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding subtract(float other) {
        return (FloatBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding subtract(long other) {
        return (FloatBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding subtract(int other) {
        return (FloatBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding multiply(double other) {
        return Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding multiply(float other) {
        return (FloatBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding multiply(long other) {
        return (FloatBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding multiply(int other) {
        return (FloatBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding divide(double other) {
        return Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding divide(float other) {
        return (FloatBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding divide(long other) {
        return (FloatBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public FloatBinding divide(int other) {
        return (FloatBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    public ObjectExpression<Float> asObject() {
        return new ObjectBinding<Float>(){
            {
                this.bind(FloatExpression.this);
            }

            @Override
            public void dispose() {
                this.unbind(FloatExpression.this);
            }

            @Override
            protected Float computeValue() {
                return FloatExpression.this.getValue();
            }
        };
    }
}

