/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.stereo;

import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.StereoGLEventListener;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.RectangleImmutable;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import jogamp.opengl.GLDrawableHelper;

public class StereoClientRenderer
implements GLEventListener {
    private final GLDrawableHelper helper;
    private final StereoDeviceRenderer deviceRenderer;
    private final boolean ownsDevice;
    private final FBObject[] fbos;
    private final int magFilter;
    private final int minFilter;
    private int numSamples;
    private final FBObject.TextureAttachment[] fboTexs;

    public StereoClientRenderer(StereoDeviceRenderer stereoDeviceRenderer, boolean bl, int n, int n2, int n3) {
        int n4 = stereoDeviceRenderer.getTextureCount();
        if (0 > n4 || 2 < n4) {
            throw new IllegalArgumentException("fboCount must be within [0..2], has " + n4 + ", due to " + stereoDeviceRenderer);
        }
        this.helper = new GLDrawableHelper();
        this.deviceRenderer = stereoDeviceRenderer;
        this.ownsDevice = bl;
        this.magFilter = n;
        this.minFilter = n2;
        this.numSamples = n3;
        this.fbos = new FBObject[n4];
        for (int i = 0; i < n4; ++i) {
            this.fbos[i] = new FBObject();
        }
        this.fboTexs = new FBObject.TextureAttachment[n4];
    }

    private void initFBOs(GL gL, DimensionImmutable dimensionImmutable) {
        for (int i = 0; i < this.fbos.length; ++i) {
            this.fbos[i].detachAllColorbuffer(gL);
            this.fbos[i].reset(gL, dimensionImmutable.getWidth(), dimensionImmutable.getHeight(), this.numSamples, false);
            if (i > 0 && this.fbos[i - 1].getNumSamples() != this.fbos[i].getNumSamples()) {
                throw new InternalError("sample size mismatch: \n\t0: " + this.fbos[i - 1] + "\n\t1: " + this.fbos[i]);
            }
            this.numSamples = this.fbos[i].getNumSamples();
            if (this.numSamples > 0) {
                this.fbos[i].attachColorbuffer(gL, 0, true);
                this.fbos[i].attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 24);
                FBObject fBObject = new FBObject();
                fBObject.reset(gL, dimensionImmutable.getWidth(), dimensionImmutable.getHeight());
                fBObject.attachTexture2D(gL, 0, false, this.magFilter, this.minFilter, 33071, 33071);
                fBObject.attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 24);
                this.fbos[i].setSamplingSink(fBObject);
                this.fbos[i].resetSamplingSink(gL);
                this.fboTexs[i] = this.fbos[i].getSamplingSink().getTextureAttachment();
            } else {
                this.fboTexs[i] = this.fbos[i].attachTexture2D(gL, 0, false, this.magFilter, this.minFilter, 33071, 33071);
                this.fbos[i].attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, 24);
            }
            this.fbos[i].unbind(gL);
            System.err.println("FBO[" + i + "]: " + this.fbos[i]);
        }
    }

    private void resetFBOs(GL gL, DimensionImmutable dimensionImmutable) {
        for (int i = 0; i < this.fbos.length; ++i) {
            this.fbos[i].reset(gL, dimensionImmutable.getWidth(), dimensionImmutable.getHeight(), this.numSamples, true);
            if (i > 0 && this.fbos[i - 1].getNumSamples() != this.fbos[i].getNumSamples()) {
                throw new InternalError("sample size mismatch: \n\t0: " + this.fbos[i - 1] + "\n\t1: " + this.fbos[i]);
            }
            this.numSamples = this.fbos[i].getNumSamples();
            this.fboTexs[i] = this.numSamples > 0 ? this.fbos[i].getSamplingSink().getTextureAttachment() : this.fbos[i].getColorbuffer(0).getTextureAttachment();
        }
    }

    public final StereoDeviceRenderer getStereoDeviceRenderer() {
        return this.deviceRenderer;
    }

    public final void addGLEventListener(StereoGLEventListener stereoGLEventListener) {
        this.helper.addGLEventListener(stereoGLEventListener);
    }

    public final void removeGLEventListener(StereoGLEventListener stereoGLEventListener) {
        this.helper.removeGLEventListener(stereoGLEventListener);
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.deviceRenderer.init(gL2ES2);
        DimensionImmutable dimensionImmutable = this.deviceRenderer.getTextureCount() > 1 ? this.deviceRenderer.getSingleSurfaceSize() : this.deviceRenderer.getTotalSurfaceSize();
        this.initFBOs(gL2ES2, dimensionImmutable);
        this.helper.init(gLAutoDrawable, false);
        gL2ES2.setSwapInterval(1);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.helper.disposeAllGLEventListener(gLAutoDrawable, false);
        for (int i = 0; i < this.fbos.length; ++i) {
            this.fbos[i].destroy(gL2ES2);
            this.fboTexs[i] = null;
        }
        if (this.ownsDevice) {
            this.deviceRenderer.dispose(gL2ES2);
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        int n;
        int n2;
        int n3;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.deviceRenderer.beginFrame(gL2ES2);
        if (0 < this.numSamples) {
            gL2ES2.glEnable(32925);
        }
        int n4 = 1 >= (n3 = this.fbos.length) ? 2 : 0;
        int[] nArray = this.deviceRenderer.getDevice().getEyeRenderOrder();
        int n5 = nArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            this.deviceRenderer.updateEyePose(n2);
        }
        if (1 == n3) {
            this.fbos[0].bind(gL2ES2);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n = nArray[n2];
            if (1 < n3) {
                this.fbos[n].bind(gL2ES2);
            }
            final StereoDeviceRenderer.Eye eye = this.deviceRenderer.getEye(n);
            final RectangleImmutable rectangleImmutable = eye.getViewport();
            gL2ES2.glViewport(rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getWidth(), rectangleImmutable.getHeight());
            final int n6 = n2 > 0 ? 1 | n4 : 0;
            GLDrawableHelper.GLEventListenerAction gLEventListenerAction = new GLDrawableHelper.GLEventListenerAction(){

                @Override
                public void run(GLAutoDrawable gLAutoDrawable, GLEventListener gLEventListener) {
                    StereoGLEventListener stereoGLEventListener = (StereoGLEventListener)gLEventListener;
                    stereoGLEventListener.reshapeForEye(gLAutoDrawable, rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getWidth(), rectangleImmutable.getHeight(), eye.getEyeParameter(), eye.getLastEyePose());
                    stereoGLEventListener.display(gLAutoDrawable, n6);
                }
            };
            this.helper.runForAllGLEventListener(gLAutoDrawable, gLEventListenerAction);
            if (1 >= n3) continue;
            this.fbos[n].unbind(gL2ES2);
        }
        if (1 == n3) {
            this.fbos[0].unbind(gL2ES2);
        }
        gL2ES2.glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        if (this.deviceRenderer.ppAvailable()) {
            this.deviceRenderer.ppBegin(gL2ES2);
            if (1 == n3) {
                this.fbos[0].use(gL2ES2, this.fboTexs[0]);
                for (n2 = 0; n2 < n5; ++n2) {
                    this.deviceRenderer.ppOneEye(gL2ES2, nArray[n2]);
                }
                this.fbos[0].unuse(gL2ES2);
            } else {
                for (n2 = 0; n2 < n5; ++n2) {
                    n = nArray[n2];
                    this.fbos[n].use(gL2ES2, this.fboTexs[n]);
                    this.deviceRenderer.ppOneEye(gL2ES2, n);
                    this.fbos[n].unuse(gL2ES2);
                }
            }
            this.deviceRenderer.ppEnd(gL2ES2);
        }
        if (!gLAutoDrawable.getAutoSwapBufferMode()) {
            gLAutoDrawable.swapBuffers();
        }
        this.deviceRenderer.endFrame(gL2ES2);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (!gLAutoDrawable.getAutoSwapBufferMode()) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glViewport(0, 0, n3, n4);
        }
    }
}

