/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import javafx.beans.NamedArg;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.stage.Window;

public class WindowEvent
extends Event {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<WindowEvent> ANY = new EventType(Event.ANY, "WINDOW");
    public static final EventType<WindowEvent> WINDOW_SHOWING = new EventType(ANY, "WINDOW_SHOWING");
    public static final EventType<WindowEvent> WINDOW_SHOWN = new EventType(ANY, "WINDOW_SHOWN");
    public static final EventType<WindowEvent> WINDOW_HIDING = new EventType(ANY, "WINDOW_HIDING");
    public static final EventType<WindowEvent> WINDOW_HIDDEN = new EventType(ANY, "WINDOW_HIDDEN");
    public static final EventType<WindowEvent> WINDOW_CLOSE_REQUEST = new EventType(ANY, "WINDOW_CLOSE_REQUEST");

    public WindowEvent(@NamedArg(value="source") Window source, @NamedArg(value="eventType") EventType<? extends Event> eventType) {
        super((Object)source, (EventTarget)source, eventType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WindowEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        return sb.append("]").toString();
    }

    public WindowEvent copyFor(Object newSource, EventTarget newTarget) {
        return (WindowEvent)super.copyFor(newSource, newTarget);
    }

    public WindowEvent copyFor(Object newSource, EventTarget newTarget, EventType<WindowEvent> type) {
        WindowEvent e = this.copyFor(newSource, newTarget);
        e.eventType = type;
        return e;
    }

    public EventType<WindowEvent> getEventType() {
        return super.getEventType();
    }
}

