/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.FXPermissions;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.VetoableListDecorator;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.stage.StageHelper;
import com.sun.javafx.stage.StagePeerListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCombination;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class Stage
extends Window {
    private boolean inNestedEventLoop = false;
    private static final StagePeerListener.StageAccessor STAGE_ACCESSOR;
    private boolean primary = false;
    private boolean securityDialog = false;
    private boolean important = true;
    private StageStyle style;
    private Modality modality = Modality.NONE;
    private Window owner = null;
    private ReadOnlyBooleanWrapper fullScreen;
    private ObservableList<Image> icons = new VetoableListDecorator<Image>((ObservableList)new TrackableObservableList<Image>(){

        protected void onChanged(ListChangeListener.Change<Image> c) {
            ArrayList<Object> platformImages = new ArrayList<Object>();
            for (Image icon : Stage.this.icons) {
                platformImages.add(Toolkit.getImageAccessor().getPlatformImage(icon));
            }
            if (Stage.this.getPeer() != null) {
                Stage.this.getPeer().setIcons(platformImages);
            }
        }
    }){

        protected void onProposedChange(List<Image> toBeAddedIcons, int[] indices) {
            for (Image icon : toBeAddedIcons) {
                if (icon != null) continue;
                throw new NullPointerException("icon can not be null.");
            }
        }
    };
    private StringProperty title;
    private ReadOnlyBooleanWrapper iconified;
    private ReadOnlyBooleanWrapper maximized;
    private ReadOnlyBooleanWrapper alwaysOnTop;
    private BooleanProperty resizable;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private final ObjectProperty<KeyCombination> fullScreenExitCombination = new SimpleObjectProperty((Object)this, "fullScreenExitCombination", null);
    private final ObjectProperty<String> fullScreenExitHint = new SimpleObjectProperty((Object)this, "fullScreenExitHint", null);

    public Stage() {
        this(StageStyle.DECORATED);
    }

    public Stage(@NamedArg(value="style", defaultValue="DECORATED") StageStyle style) {
        Toolkit.getToolkit().checkFxUserThread();
        this.initStyle(style);
        StageHelper.initHelper(this);
    }

    @Override
    public final void setScene(Scene value) {
        Toolkit.getToolkit().checkFxUserThread();
        super.setScene(value);
    }

    @Override
    public final void show() {
        super.show();
    }

    final void initSecurityDialog(boolean securityDialog) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set securityDialog once stage has been set visible");
        }
        this.securityDialog = securityDialog;
    }

    final boolean isSecurityDialog() {
        return this.securityDialog;
    }

    void setPrimary(boolean primary) {
        this.primary = primary;
    }

    boolean isPrimary() {
        return this.primary;
    }

    void setImportant(boolean important) {
        this.important = important;
    }

    private boolean isImportant() {
        return this.important;
    }

    public void showAndWait() {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot call this method on primary stage");
        }
        if (this.isShowing()) {
            throw new IllegalStateException("Stage already visible");
        }
        if (!Toolkit.getToolkit().canStartNestedEventLoop()) {
            throw new IllegalStateException("showAndWait is not allowed during animation or layout processing");
        }
        assert (!this.inNestedEventLoop);
        this.show();
        this.inNestedEventLoop = true;
        Toolkit.getToolkit().enterNestedEventLoop(this);
    }

    public final void initStyle(StageStyle style) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set style once stage has been set visible");
        }
        this.style = style;
    }

    public final StageStyle getStyle() {
        return this.style;
    }

    public final void initModality(Modality modality) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set modality once stage has been set visible");
        }
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot set modality for the primary stage");
        }
        this.modality = modality;
    }

    public final Modality getModality() {
        return this.modality;
    }

    public final void initOwner(Window owner) {
        if (this.hasBeenVisible) {
            throw new IllegalStateException("Cannot set owner once stage has been set visible");
        }
        if (this.isPrimary()) {
            throw new IllegalStateException("Cannot set owner for the primary stage");
        }
        this.owner = owner;
        Scene sceneValue = this.getScene();
        if (sceneValue != null) {
            SceneHelper.parentEffectiveOrientationInvalidated(sceneValue);
        }
    }

    public final Window getOwner() {
        return this.owner;
    }

    public final void setFullScreen(boolean value) {
        Toolkit.getToolkit().checkFxUserThread();
        this.fullScreenPropertyImpl().set(value);
        if (this.getPeer() != null) {
            this.getPeer().setFullScreen(value);
        }
    }

    public final boolean isFullScreen() {
        return this.fullScreen == null ? false : this.fullScreen.get();
    }

    public final ReadOnlyBooleanProperty fullScreenProperty() {
        return this.fullScreenPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper fullScreenPropertyImpl() {
        if (this.fullScreen == null) {
            this.fullScreen = new ReadOnlyBooleanWrapper((Object)this, "fullScreen");
        }
        return this.fullScreen;
    }

    public final ObservableList<Image> getIcons() {
        return this.icons;
    }

    public final void setTitle(String value) {
        this.titleProperty().set((Object)value);
    }

    public final String getTitle() {
        return this.title == null ? null : (String)this.title.get();
    }

    public final StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new StringPropertyBase(){

                protected void invalidated() {
                    if (Stage.this.getPeer() != null) {
                        Stage.this.getPeer().setTitle(this.get());
                    }
                }

                public Object getBean() {
                    return Stage.this;
                }

                public String getName() {
                    return "title";
                }
            };
        }
        return this.title;
    }

    public final void setIconified(boolean value) {
        this.iconifiedPropertyImpl().set(value);
        if (this.getPeer() != null) {
            this.getPeer().setIconified(value);
        }
    }

    public final boolean isIconified() {
        return this.iconified == null ? false : this.iconified.get();
    }

    public final ReadOnlyBooleanProperty iconifiedProperty() {
        return this.iconifiedPropertyImpl().getReadOnlyProperty();
    }

    private final ReadOnlyBooleanWrapper iconifiedPropertyImpl() {
        if (this.iconified == null) {
            this.iconified = new ReadOnlyBooleanWrapper((Object)this, "iconified");
        }
        return this.iconified;
    }

    public final void setMaximized(boolean value) {
        this.maximizedPropertyImpl().set(value);
        if (this.getPeer() != null) {
            this.getPeer().setMaximized(value);
        }
    }

    public final boolean isMaximized() {
        return this.maximized == null ? false : this.maximized.get();
    }

    public final ReadOnlyBooleanProperty maximizedProperty() {
        return this.maximizedPropertyImpl().getReadOnlyProperty();
    }

    private final ReadOnlyBooleanWrapper maximizedPropertyImpl() {
        if (this.maximized == null) {
            this.maximized = new ReadOnlyBooleanWrapper((Object)this, "maximized");
        }
        return this.maximized;
    }

    public final void setAlwaysOnTop(boolean value) {
        this.alwaysOnTopPropertyImpl().set(value);
        if (this.getPeer() != null) {
            this.getPeer().setAlwaysOnTop(value);
        }
    }

    public final boolean isAlwaysOnTop() {
        return this.alwaysOnTop == null ? false : this.alwaysOnTop.get();
    }

    public final ReadOnlyBooleanProperty alwaysOnTopProperty() {
        return this.alwaysOnTopPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper alwaysOnTopPropertyImpl() {
        if (this.alwaysOnTop == null) {
            this.alwaysOnTop = new ReadOnlyBooleanWrapper((Object)this, "alwaysOnTop");
        }
        return this.alwaysOnTop;
    }

    public final void setResizable(boolean value) {
        this.resizableProperty().set(value);
    }

    public final boolean isResizable() {
        return this.resizable == null ? true : this.resizable.get();
    }

    public final BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new ResizableProperty();
        }
        return this.resizable;
    }

    public final void setMinWidth(double value) {
        this.minWidthProperty().set(value);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? 0.0 : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(0.0){

                protected void invalidated() {
                    if (Stage.this.getPeer() != null) {
                        Stage.this.getPeer().setMinimumSize((int)Math.ceil(this.get()), (int)Math.ceil(Stage.this.getMinHeight()));
                    }
                    if (Stage.this.getWidth() < Stage.this.getMinWidth()) {
                        Stage.this.setWidth(Stage.this.getMinWidth());
                    }
                }

                public Object getBean() {
                    return Stage.this;
                }

                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinHeight(double value) {
        this.minHeightProperty().set(value);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? 0.0 : this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(0.0){

                protected void invalidated() {
                    if (Stage.this.getPeer() != null) {
                        Stage.this.getPeer().setMinimumSize((int)Math.ceil(Stage.this.getMinWidth()), (int)Math.ceil(this.get()));
                    }
                    if (Stage.this.getHeight() < Stage.this.getMinHeight()) {
                        Stage.this.setHeight(Stage.this.getMinHeight());
                    }
                }

                public Object getBean() {
                    return Stage.this;
                }

                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setMaxWidth(double value) {
        this.maxWidthProperty().set(value);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? Double.MAX_VALUE : this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(Double.MAX_VALUE){

                protected void invalidated() {
                    if (Stage.this.getPeer() != null) {
                        Stage.this.getPeer().setMaximumSize((int)Math.floor(this.get()), (int)Math.floor(Stage.this.getMaxHeight()));
                    }
                    if (Stage.this.getWidth() > Stage.this.getMaxWidth()) {
                        Stage.this.setWidth(Stage.this.getMaxWidth());
                    }
                }

                public Object getBean() {
                    return Stage.this;
                }

                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double value) {
        this.maxHeightProperty().set(value);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? Double.MAX_VALUE : this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(Double.MAX_VALUE){

                protected void invalidated() {
                    if (Stage.this.getPeer() != null) {
                        Stage.this.getPeer().setMaximumSize((int)Math.floor(Stage.this.getMaxWidth()), (int)Math.floor(this.get()));
                    }
                    if (Stage.this.getHeight() > Stage.this.getMaxHeight()) {
                        Stage.this.setHeight(Stage.this.getMaxHeight());
                    }
                }

                public Object getBean() {
                    return Stage.this;
                }

                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    private void doVisibleChanging(boolean value) {
        Toolkit toolkit = Toolkit.getToolkit();
        if (value && this.getPeer() == null) {
            SecurityManager securityManager;
            Window window = this.getOwner();
            TKStage tkStage = window == null ? null : window.getPeer();
            Scene scene = this.getScene();
            boolean rtl = scene != null && scene.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
            StageStyle stageStyle = this.getStyle();
            if (stageStyle == StageStyle.TRANSPARENT && (securityManager = System.getSecurityManager()) != null) {
                try {
                    securityManager.checkPermission((Permission)FXPermissions.CREATE_TRANSPARENT_WINDOW_PERMISSION);
                }
                catch (SecurityException e) {
                    stageStyle = StageStyle.UNDECORATED;
                }
            }
            this.setPeer(toolkit.createTKStage(this, this.isSecurityDialog(), stageStyle, this.isPrimary(), this.getModality(), tkStage, rtl, this.acc));
            this.getPeer().setMinimumSize((int)Math.ceil(this.getMinWidth()), (int)Math.ceil(this.getMinHeight()));
            this.getPeer().setMaximumSize((int)Math.floor(this.getMaxWidth()), (int)Math.floor(this.getMaxHeight()));
            this.setPeerListener(new StagePeerListener(this, STAGE_ACCESSOR));
        }
    }

    private void doVisibleChanged(boolean value) {
        if (value) {
            TKStage peer = this.getPeer();
            peer.setImportant(this.isImportant());
            peer.setResizable(this.isResizable());
            peer.setFullScreen(this.isFullScreen());
            peer.setAlwaysOnTop(this.isAlwaysOnTop());
            peer.setIconified(this.isIconified());
            peer.setMaximized(this.isMaximized());
            peer.setTitle(this.getTitle());
            ArrayList<Object> platformImages = new ArrayList<Object>();
            for (Image icon : this.icons) {
                platformImages.add(Toolkit.getImageAccessor().getPlatformImage(icon));
            }
            if (peer != null) {
                peer.setIcons(platformImages);
            }
        }
        if (!value && this.inNestedEventLoop) {
            this.inNestedEventLoop = false;
            Toolkit.getToolkit().exitNestedEventLoop(this, null);
        }
    }

    public void toFront() {
        if (this.getPeer() != null) {
            this.getPeer().toFront();
        }
    }

    public void toBack() {
        if (this.getPeer() != null) {
            this.getPeer().toBack();
        }
    }

    public void close() {
        this.hide();
    }

    @Override
    Window getWindowOwner() {
        return this.getOwner();
    }

    public final void setFullScreenExitKeyCombination(KeyCombination keyCombination) {
        this.fullScreenExitCombination.set((Object)keyCombination);
    }

    public final KeyCombination getFullScreenExitKeyCombination() {
        return (KeyCombination)this.fullScreenExitCombination.get();
    }

    public final ObjectProperty<KeyCombination> fullScreenExitKeyProperty() {
        return this.fullScreenExitCombination;
    }

    public final void setFullScreenExitHint(String value) {
        this.fullScreenExitHint.set((Object)value);
    }

    public final String getFullScreenExitHint() {
        return (String)this.fullScreenExitHint.get();
    }

    public final ObjectProperty<String> fullScreenExitHintProperty() {
        return this.fullScreenExitHint;
    }

    static {
        StageHelper.setStageAccessor(new StageHelper.StageAccessor(){

            @Override
            public void doVisibleChanging(Window window, boolean visible) {
                ((Stage)window).doVisibleChanging(visible);
            }

            @Override
            public void doVisibleChanged(Window window, boolean visible) {
                ((Stage)window).doVisibleChanged(visible);
            }

            @Override
            public void initSecurityDialog(Stage stage, boolean securityDialog) {
                stage.initSecurityDialog(securityDialog);
            }

            @Override
            public void setPrimary(Stage stage, boolean primary) {
                stage.setPrimary(primary);
            }

            @Override
            public void setImportant(Stage stage, boolean important) {
                stage.setImportant(important);
            }
        });
        STAGE_ACCESSOR = new StagePeerListener.StageAccessor(){

            @Override
            public void setIconified(Stage stage, boolean iconified) {
                stage.iconifiedPropertyImpl().set(iconified);
            }

            @Override
            public void setMaximized(Stage stage, boolean maximized) {
                stage.maximizedPropertyImpl().set(maximized);
            }

            @Override
            public void setResizable(Stage stage, boolean resizable) {
                ((ResizableProperty)stage.resizableProperty()).setNoInvalidate(resizable);
            }

            @Override
            public void setFullScreen(Stage stage, boolean fs) {
                stage.fullScreenPropertyImpl().set(fs);
            }

            @Override
            public void setAlwaysOnTop(Stage stage, boolean aot) {
                stage.alwaysOnTopPropertyImpl().set(aot);
            }
        };
    }

    private class ResizableProperty
    extends SimpleBooleanProperty {
        private boolean noInvalidate;

        public ResizableProperty() {
            super((Object)Stage.this, "resizable", true);
        }

        void setNoInvalidate(boolean value) {
            this.noInvalidate = true;
            this.set(value);
            this.noInvalidate = false;
        }

        protected void invalidated() {
            if (this.noInvalidate) {
                return;
            }
            if (Stage.this.getPeer() != null) {
                Stage.this.applyBounds();
                Stage.this.getPeer().setResizable(this.get());
            }
        }

        public void bind(ObservableValue<? extends Boolean> rawObservable) {
            throw new RuntimeException("Resizable property cannot be bound");
        }
    }
}

