/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

public enum FontWeight {
    THIN(100, "Thin"),
    EXTRA_LIGHT(200, "Extra Light", "Ultra Light"),
    LIGHT(300, "Light"),
    NORMAL(400, "Normal", "Regular"),
    MEDIUM(500, "Medium"),
    SEMI_BOLD(600, "Semi Bold", "Demi Bold"),
    BOLD(700, "Bold"),
    EXTRA_BOLD(800, "Extra Bold", "Ultra Bold"),
    BLACK(900, "Black", "Heavy");

    private final int weight;
    private final String[] names;

    private FontWeight(int weight, String ... names) {
        this.weight = weight;
        this.names = names;
    }

    public int getWeight() {
        return this.weight;
    }

    public static FontWeight findByName(String name) {
        if (name == null) {
            return null;
        }
        for (FontWeight w : FontWeight.values()) {
            for (String n : w.names) {
                if (!n.equalsIgnoreCase(name)) continue;
                return w;
            }
        }
        return null;
    }

    public static FontWeight findByWeight(int weight) {
        if (weight <= 150) {
            return THIN;
        }
        if (weight <= 250) {
            return EXTRA_LIGHT;
        }
        if (weight < 350) {
            return LIGHT;
        }
        if (weight <= 450) {
            return NORMAL;
        }
        if (weight <= 550) {
            return MEDIUM;
        }
        if (weight < 650) {
            return SEMI_BOLD;
        }
        if (weight <= 750) {
            return BOLD;
        }
        if (weight <= 850) {
            return EXTRA_BOLD;
        }
        return BLACK;
    }
}

