/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.collections.FloatArraySyncer;
import com.sun.javafx.collections.IntegerArraySyncer;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.shape.ObservableFaceArrayImpl;
import com.sun.javafx.scene.shape.TriangleMeshHelper;
import com.sun.javafx.sg.prism.NGTriangleMesh;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ArrayChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableArray;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.ObservableFaceArray;
import javafx.scene.shape.VertexFormat;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;

public class TriangleMesh
extends Mesh {
    private final ObservableFloatArray points = FXCollections.observableFloatArray();
    private final ObservableFloatArray normals = FXCollections.observableFloatArray();
    private final ObservableFloatArray texCoords = FXCollections.observableFloatArray();
    private final ObservableFaceArray faces = new ObservableFaceArrayImpl();
    private final ObservableIntegerArray faceSmoothingGroups = FXCollections.observableIntegerArray();
    private final Listener pointsSyncer = new Listener(this, (ObservableArray)this.points);
    private final Listener normalsSyncer = new Listener(this, (ObservableArray)this.normals);
    private final Listener texCoordsSyncer = new Listener(this, (ObservableArray)this.texCoords);
    private final Listener facesSyncer = new Listener(this, (ObservableArray)this.faces);
    private final Listener faceSmoothingGroupsSyncer = new Listener(this, (ObservableArray)this.faceSmoothingGroups);
    private final boolean isPredefinedShape;
    private boolean isValidDirty = true;
    private boolean isPointsValid;
    private boolean isNormalsValid;
    private boolean isTexCoordsValid;
    private boolean isFacesValid;
    private boolean isFaceSmoothingGroupValid;
    private int refCount = 1;
    private BaseBounds cachedBounds;
    private ObjectProperty<VertexFormat> vertexFormat;
    private NGTriangleMesh peer;

    public TriangleMesh() {
        this(false);
        TriangleMeshHelper.initHelper(this);
    }

    public TriangleMesh(VertexFormat vertexFormat) {
        this(false);
        this.setVertexFormat(vertexFormat);
        TriangleMeshHelper.initHelper(this);
    }

    TriangleMesh(boolean isPredefinedShape) {
        this.isPredefinedShape = isPredefinedShape;
        if (isPredefinedShape) {
            this.isPointsValid = true;
            this.isNormalsValid = true;
            this.isTexCoordsValid = true;
            this.isFacesValid = true;
            this.isFaceSmoothingGroupValid = true;
        } else {
            this.isPointsValid = false;
            this.isNormalsValid = false;
            this.isTexCoordsValid = false;
            this.isFacesValid = false;
            this.isFaceSmoothingGroupValid = false;
        }
        TriangleMeshHelper.initHelper(this);
    }

    public final void setVertexFormat(VertexFormat value) {
        this.vertexFormatProperty().set((Object)value);
    }

    public final VertexFormat getVertexFormat() {
        return this.vertexFormat == null ? VertexFormat.POINT_TEXCOORD : (VertexFormat)this.vertexFormat.get();
    }

    public final ObjectProperty<VertexFormat> vertexFormatProperty() {
        if (this.vertexFormat == null) {
            this.vertexFormat = new SimpleObjectProperty<VertexFormat>((Object)this, "vertexFormat"){

                protected void invalidated() {
                    TriangleMesh.this.setDirty(true);
                    TriangleMesh.this.facesSyncer.setDirty(true);
                    TriangleMesh.this.faceSmoothingGroupsSyncer.setDirty(true);
                }
            };
        }
        return this.vertexFormat;
    }

    public final int getPointElementSize() {
        return this.getVertexFormat().getPointElementSize();
    }

    public final int getNormalElementSize() {
        return this.getVertexFormat().getNormalElementSize();
    }

    public final int getTexCoordElementSize() {
        return this.getVertexFormat().getTexCoordElementSize();
    }

    public final int getFaceElementSize() {
        return this.getVertexFormat().getVertexIndexSize() * 3;
    }

    public final ObservableFloatArray getPoints() {
        return this.points;
    }

    public final ObservableFloatArray getNormals() {
        return this.normals;
    }

    public final ObservableFloatArray getTexCoords() {
        return this.texCoords;
    }

    public final ObservableFaceArray getFaces() {
        return this.faces;
    }

    public final ObservableIntegerArray getFaceSmoothingGroups() {
        return this.faceSmoothingGroups;
    }

    @Override
    void setDirty(boolean value) {
        super.setDirty(value);
        if (!value) {
            this.pointsSyncer.setDirty(false);
            this.normalsSyncer.setDirty(false);
            this.texCoordsSyncer.setDirty(false);
            this.facesSyncer.setDirty(false);
            this.faceSmoothingGroupsSyncer.setDirty(false);
        }
    }

    int getRefCount() {
        return this.refCount;
    }

    synchronized void incRef() {
        ++this.refCount;
    }

    synchronized void decRef() {
        --this.refCount;
    }

    NGTriangleMesh getPGTriangleMesh() {
        if (this.peer == null) {
            this.peer = new NGTriangleMesh();
        }
        return this.peer;
    }

    @Override
    NGTriangleMesh getPGMesh() {
        return this.getPGTriangleMesh();
    }

    private boolean validatePoints() {
        if (this.points.size() == 0) {
            return false;
        }
        if (this.points.size() % this.getVertexFormat().getPointElementSize() != 0) {
            String logname = TriangleMesh.class.getName();
            PlatformLogger.getLogger((String)logname).warning("points.size() has to be divisible by getPointElementSize(). It is to store multiple x, y, and z coordinates of this mesh");
            return false;
        }
        return true;
    }

    private boolean validateNormals() {
        if (this.getVertexFormat() != VertexFormat.POINT_NORMAL_TEXCOORD) {
            return true;
        }
        if (this.normals.size() == 0) {
            return false;
        }
        if (this.normals.size() % this.getVertexFormat().getNormalElementSize() != 0) {
            String logname = TriangleMesh.class.getName();
            PlatformLogger.getLogger((String)logname).warning("normals.size() has to be divisible by getNormalElementSize(). It is to store multiple nx, ny, and nz coordinates of this mesh");
            return false;
        }
        return true;
    }

    private boolean validateTexCoords() {
        if (this.texCoords.size() == 0) {
            return false;
        }
        if (this.texCoords.size() % this.getVertexFormat().getTexCoordElementSize() != 0) {
            String logname = TriangleMesh.class.getName();
            PlatformLogger.getLogger((String)logname).warning("texCoords.size() has to be divisible by getTexCoordElementSize(). It is to store multiple u and v texture coordinates of this mesh");
            return false;
        }
        return true;
    }

    private boolean validateFaces() {
        if (this.faces.size() == 0) {
            return false;
        }
        String logname = TriangleMesh.class.getName();
        if (this.faces.size() % this.getFaceElementSize() != 0) {
            PlatformLogger.getLogger((String)logname).warning("faces.size() has to be divisible by getFaceElementSize().");
            return false;
        }
        if (this.getVertexFormat() == VertexFormat.POINT_TEXCOORD) {
            int nVerts = this.points.size() / this.getVertexFormat().getPointElementSize();
            int nTVerts = this.texCoords.size() / this.getVertexFormat().getTexCoordElementSize();
            for (int i = 0; i < this.faces.size(); ++i) {
                if ((i % 2 != 0 || this.faces.get(i) < nVerts && this.faces.get(i) >= 0) && (i % 2 == 0 || this.faces.get(i) < nTVerts && this.faces.get(i) >= 0)) continue;
                PlatformLogger.getLogger((String)logname).warning("The values in the faces array must be within the range of the number of vertices in the points array (0 to points.length / 3 - 1) for the point indices and within the range of the number of the vertices in the texCoords array (0 to texCoords.length / 2 - 1) for the texture coordinate indices.");
                return false;
            }
        } else if (this.getVertexFormat() == VertexFormat.POINT_NORMAL_TEXCOORD) {
            int nVerts = this.points.size() / this.getVertexFormat().getPointElementSize();
            int nNVerts = this.normals.size() / this.getVertexFormat().getNormalElementSize();
            int nTVerts = this.texCoords.size() / this.getVertexFormat().getTexCoordElementSize();
            for (int i = 0; i < this.faces.size(); i += 3) {
                if (this.faces.get(i) < nVerts && this.faces.get(i) >= 0 && this.faces.get(i + 1) < nNVerts && this.faces.get(i + 1) >= 0 && this.faces.get(i + 2) < nTVerts && this.faces.get(i + 2) >= 0) continue;
                PlatformLogger.getLogger((String)logname).warning("The values in the faces array must be within the range of the number of vertices in the points array (0 to points.length / 3 - 1) for the point indices, and within the range of the number of the vertices in the normals array (0 to normals.length / 3 - 1) for the normals indices, and number of the vertices in the texCoords array (0 to texCoords.length / 2 - 1) for the texture coordinate indices.");
                return false;
            }
        } else {
            PlatformLogger.getLogger((String)logname).warning("Unsupported VertexFormat: " + this.getVertexFormat().toString());
            return false;
        }
        return true;
    }

    private boolean validateFaceSmoothingGroups() {
        if (this.faceSmoothingGroups.size() != 0 && this.faceSmoothingGroups.size() != this.faces.size() / this.getFaceElementSize()) {
            String logname = TriangleMesh.class.getName();
            PlatformLogger.getLogger((String)logname).warning("faceSmoothingGroups.size() has to equal to number of faces.");
            return false;
        }
        return true;
    }

    private boolean validate() {
        if (this.isPredefinedShape) {
            return true;
        }
        if (this.isValidDirty) {
            if (this.pointsSyncer.dirtyInFull) {
                this.isPointsValid = this.validatePoints();
            }
            if (this.normalsSyncer.dirtyInFull) {
                this.isNormalsValid = this.validateNormals();
            }
            if (this.texCoordsSyncer.dirtyInFull) {
                this.isTexCoordsValid = this.validateTexCoords();
            }
            if (this.facesSyncer.dirty || this.pointsSyncer.dirtyInFull || this.normalsSyncer.dirtyInFull || this.texCoordsSyncer.dirtyInFull) {
                boolean bl = this.isFacesValid = this.isPointsValid && this.isNormalsValid && this.isTexCoordsValid && this.validateFaces();
            }
            if (this.faceSmoothingGroupsSyncer.dirtyInFull || this.facesSyncer.dirtyInFull) {
                this.isFaceSmoothingGroupValid = this.isFacesValid && this.validateFaceSmoothingGroups();
            }
            this.isValidDirty = false;
        }
        return this.isPointsValid && this.isNormalsValid && this.isTexCoordsValid && this.isFaceSmoothingGroupValid && this.isFacesValid;
    }

    @Override
    void updatePG() {
        if (!this.isDirty()) {
            return;
        }
        NGTriangleMesh pgTriMesh = this.getPGTriangleMesh();
        if (this.validate()) {
            pgTriMesh.setUserDefinedNormals(this.getVertexFormat() == VertexFormat.POINT_NORMAL_TEXCOORD);
            pgTriMesh.syncPoints(this.pointsSyncer);
            pgTriMesh.syncNormals(this.normalsSyncer);
            pgTriMesh.syncTexCoords(this.texCoordsSyncer);
            pgTriMesh.syncFaces(this.facesSyncer);
            pgTriMesh.syncFaceSmoothingGroups(this.faceSmoothingGroupsSyncer);
        } else {
            pgTriMesh.setUserDefinedNormals(false);
            pgTriMesh.syncPoints(null);
            pgTriMesh.syncNormals(null);
            pgTriMesh.syncTexCoords(null);
            pgTriMesh.syncFaces(null);
            pgTriMesh.syncFaceSmoothingGroups(null);
        }
        this.setDirty(false);
    }

    @Override
    BaseBounds computeBounds(BaseBounds bounds) {
        if (this.isDirty() || this.cachedBounds == null) {
            this.cachedBounds = new BoxBounds();
            if (this.validate()) {
                int len = this.points.size();
                int pointElementSize = this.getVertexFormat().getPointElementSize();
                for (int i = 0; i < len; i += pointElementSize) {
                    this.cachedBounds.add(this.points.get(i), this.points.get(i + 1), this.points.get(i + 2));
                }
            }
        }
        return bounds.deriveWithNewBounds(this.cachedBounds);
    }

    private Point3D computeCentroid(double v0x, double v0y, double v0z, double v1x, double v1y, double v1z, double v2x, double v2y, double v2z) {
        return new Point3D(v0x + (v2x + (v1x - v2x) / 2.0 - v0x) / 3.0, v0y + (v2y + (v1y - v2y) / 2.0 - v0y) / 3.0, v0z + (v2z + (v1z - v2z) / 2.0 - v0z) / 3.0);
    }

    private Point2D computeCentroid(Point2D v0, Point2D v1, Point2D v2) {
        Point2D center = v1.midpoint(v2);
        Point2D vec = center.subtract(v0);
        return v0.add(new Point2D(vec.getX() / 3.0, vec.getY() / 3.0));
    }

    private boolean computeIntersectsFace(PickRay pickRay, Vec3d origin, Vec3d dir, int faceIndex, CullFace cullFace, Node candidate, boolean reportFace, PickResultChooser result) {
        double hz;
        float e1z;
        float e2x;
        double hy;
        float e1y;
        float e2y;
        int vertexIndexSize = this.getVertexFormat().getVertexIndexSize();
        int pointElementSize = this.getVertexFormat().getPointElementSize();
        int v0Idx = this.faces.get(faceIndex) * pointElementSize;
        int v1Idx = this.faces.get(faceIndex + vertexIndexSize) * pointElementSize;
        int v2Idx = this.faces.get(faceIndex + 2 * vertexIndexSize) * pointElementSize;
        float v0x = this.points.get(v0Idx);
        float v0y = this.points.get(v0Idx + 1);
        float v0z = this.points.get(v0Idx + 2);
        float v1x = this.points.get(v1Idx);
        float v1y = this.points.get(v1Idx + 1);
        float v1z = this.points.get(v1Idx + 2);
        float v2x = this.points.get(v2Idx);
        float v2y = this.points.get(v2Idx + 1);
        float e1x = v1x - v0x;
        float v2z = this.points.get(v2Idx + 2);
        float e2z = v2z - v0z;
        double hx = dir.y * (double)e2z - dir.z * (double)(e2y = v2y - v0y);
        double a = (double)e1x * hx + (double)(e1y = v1y - v0y) * (hy = dir.z * (double)(e2x = v2x - v0x) - dir.x * (double)e2z) + (double)(e1z = v1z - v0z) * (hz = dir.x * (double)e2y - dir.y * (double)e2x);
        if (a == 0.0) {
            return false;
        }
        double f = 1.0 / a;
        double sx = origin.x - (double)v0x;
        double sy = origin.y - (double)v0y;
        double sz = origin.z - (double)v0z;
        double u = f * (sx * hx + sy * hy + sz * hz);
        if (u < 0.0 || u > 1.0) {
            return false;
        }
        double qx = sy * (double)e1z - sz * (double)e1y;
        double qy = sz * (double)e1x - sx * (double)e1z;
        double qz = sx * (double)e1y - sy * (double)e1x;
        double v = f * (dir.x * qx + dir.y * qy + dir.z * qz);
        if (v < 0.0 || u + v > 1.0) {
            return false;
        }
        double t = f * ((double)e2x * qx + (double)e2y * qy + (double)e2z * qz);
        if (t >= pickRay.getNearClip() && t <= pickRay.getFarClip()) {
            Point3D ce2;
            Point3D normal;
            double nangle;
            if (cullFace != CullFace.NONE && ((nangle = (normal = new Point3D(e1y * e2z - e1z * e2y, e1z * e2x - e1x * e2z, e1x * e2y - e1y * e2x)).angle(new Point3D(-dir.x, -dir.y, -dir.z))) >= 90.0 || cullFace != CullFace.BACK) && (nangle <= 90.0 || cullFace != CullFace.FRONT)) {
                return false;
            }
            if (Double.isInfinite(t) || Double.isNaN(t)) {
                return false;
            }
            if (result == null || !result.isCloser(t)) {
                return true;
            }
            Point3D point = PickResultChooser.computePoint(pickRay, t);
            Point3D centroid = this.computeCentroid(v0x, v0y, v0z, v1x, v1y, v1z, v2x, v2y, v2z);
            Point3D cv0 = new Point3D((double)v0x - centroid.getX(), (double)v0y - centroid.getY(), (double)v0z - centroid.getZ());
            Point3D cv1 = new Point3D((double)v1x - centroid.getX(), (double)v1y - centroid.getY(), (double)v1z - centroid.getZ());
            Point3D cv2 = new Point3D((double)v2x - centroid.getX(), (double)v2y - centroid.getY(), (double)v2z - centroid.getZ());
            Point3D ce1 = cv1.subtract(cv0);
            Point3D n = ce1.crossProduct(ce2 = cv2.subtract(cv0));
            if (n.getZ() < 0.0) {
                n = new Point3D(-n.getX(), -n.getY(), -n.getZ());
            }
            Point3D ax = n.crossProduct(Rotate.Z_AXIS);
            double angle = Math.atan2(ax.magnitude(), n.dotProduct(Rotate.Z_AXIS));
            Rotate r = new Rotate(Math.toDegrees(angle), ax);
            Point3D crv0 = r.transform(cv0);
            Point3D crv1 = r.transform(cv1);
            Point3D crv2 = r.transform(cv2);
            Point3D rPoint = r.transform(point.subtract(centroid));
            Point2D flatV0 = new Point2D(crv0.getX(), crv0.getY());
            Point2D flatV1 = new Point2D(crv1.getX(), crv1.getY());
            Point2D flatV2 = new Point2D(crv2.getX(), crv2.getY());
            Point2D flatPoint = new Point2D(rPoint.getX(), rPoint.getY());
            int texCoordElementSize = this.getVertexFormat().getTexCoordElementSize();
            int texCoordOffset = this.getVertexFormat().getTexCoordIndexOffset();
            int t0Idx = this.faces.get(faceIndex + texCoordOffset) * texCoordElementSize;
            int t1Idx = this.faces.get(faceIndex + vertexIndexSize + texCoordOffset) * texCoordElementSize;
            int t2Idx = this.faces.get(faceIndex + vertexIndexSize * 2 + texCoordOffset) * texCoordElementSize;
            Point2D u0 = new Point2D(this.texCoords.get(t0Idx), this.texCoords.get(t0Idx + 1));
            Point2D u1 = new Point2D(this.texCoords.get(t1Idx), this.texCoords.get(t1Idx + 1));
            Point2D u2 = new Point2D(this.texCoords.get(t2Idx), this.texCoords.get(t2Idx + 1));
            Point2D txCentroid = this.computeCentroid(u0, u1, u2);
            Point2D cu0 = u0.subtract(txCentroid);
            Point2D cu1 = u1.subtract(txCentroid);
            Point2D cu2 = u2.subtract(txCentroid);
            Affine src = new Affine(flatV0.getX(), flatV1.getX(), flatV2.getX(), flatV0.getY(), flatV1.getY(), flatV2.getY());
            Affine trg = new Affine(cu0.getX(), cu1.getX(), cu2.getX(), cu0.getY(), cu1.getY(), cu2.getY());
            Point2D txCoords = null;
            try {
                src.invert();
                trg.append(src);
                txCoords = txCentroid.add(trg.transform(flatPoint));
            }
            catch (NonInvertibleTransformException nonInvertibleTransformException) {
                // empty catch block
            }
            result.offer(candidate, t, reportFace ? faceIndex / this.getFaceElementSize() : -1, point, txCoords);
            return true;
        }
        return false;
    }

    private boolean doComputeIntersects(PickRay pickRay, PickResultChooser pickResult, Node candidate, CullFace cullFace, boolean reportFace) {
        boolean found = false;
        if (this.validate()) {
            int size = this.faces.size();
            Vec3d o = pickRay.getOriginNoClone();
            Vec3d d = pickRay.getDirectionNoClone();
            for (int i = 0; i < size; i += this.getFaceElementSize()) {
                if (!this.computeIntersectsFace(pickRay, o, d, i, cullFace, candidate, reportFace, pickResult)) continue;
                found = true;
            }
        }
        return found;
    }

    static {
        TriangleMeshHelper.setTriangleMeshAccessor(new TriangleMeshHelper.TriangleMeshAccessor(){

            @Override
            public boolean doComputeIntersects(Mesh mesh, PickRay pickRay, PickResultChooser pickResult, Node candidate, CullFace cullFace, boolean reportFace) {
                return ((TriangleMesh)mesh).doComputeIntersects(pickRay, pickResult, candidate, cullFace, reportFace);
            }
        });
    }

    private static class Listener<T extends ObservableArray<T>>
    implements ArrayChangeListener<T>,
    FloatArraySyncer,
    IntegerArraySyncer {
        protected final T array;
        protected boolean dirty = true;
        protected boolean dirtyInFull = true;
        protected int dirtyRangeFrom;
        protected int dirtyRangeLength;
        final /* synthetic */ TriangleMesh this$0;

        public Listener(T array) {
            this.this$0 = var1_1;
            this.array = array;
            array.addListener((ArrayChangeListener)this);
        }

        protected final void addDirtyRange(int from, int length) {
            if (length > 0 && !this.dirtyInFull) {
                this.markDirty();
                if (this.dirtyRangeLength == 0) {
                    this.dirtyRangeFrom = from;
                    this.dirtyRangeLength = length;
                } else {
                    int fromIndex = Math.min(this.dirtyRangeFrom, from);
                    int toIndex = Math.max(this.dirtyRangeFrom + this.dirtyRangeLength, from + length);
                    this.dirtyRangeFrom = fromIndex;
                    this.dirtyRangeLength = toIndex - fromIndex;
                }
            }
        }

        protected void markDirty() {
            this.dirty = true;
            this.this$0.setDirty(true);
        }

        public void onChanged(T observableArray, boolean sizeChanged, int from, int to) {
            if (sizeChanged) {
                this.setDirty(true);
            } else {
                this.addDirtyRange(from, to - from);
            }
            this.this$0.isValidDirty = true;
        }

        public final void setDirty(boolean dirty) {
            this.dirtyInFull = dirty;
            if (dirty) {
                this.markDirty();
                this.dirtyRangeFrom = 0;
                this.dirtyRangeLength = this.array.size();
            } else {
                this.dirty = false;
                this.dirtyRangeLength = 0;
                this.dirtyRangeFrom = 0;
            }
        }

        public float[] syncTo(float[] array, int[] fromAndLengthIndices) {
            assert (fromAndLengthIndices != null && fromAndLengthIndices.length == 2);
            ObservableFloatArray floatArray = (ObservableFloatArray)this.array;
            if (this.dirtyInFull || array == null || array.length != floatArray.size()) {
                fromAndLengthIndices[0] = 0;
                fromAndLengthIndices[1] = floatArray.size();
                return floatArray.toArray(null);
            }
            fromAndLengthIndices[0] = this.dirtyRangeFrom;
            fromAndLengthIndices[1] = this.dirtyRangeLength;
            floatArray.copyTo(this.dirtyRangeFrom, array, this.dirtyRangeFrom, this.dirtyRangeLength);
            return array;
        }

        public int[] syncTo(int[] array, int[] fromAndLengthIndices) {
            assert (fromAndLengthIndices != null && fromAndLengthIndices.length == 2);
            ObservableIntegerArray intArray = (ObservableIntegerArray)this.array;
            if (this.dirtyInFull || array == null || array.length != intArray.size()) {
                fromAndLengthIndices[0] = 0;
                fromAndLengthIndices[1] = intArray.size();
                return intArray.toArray(null);
            }
            fromAndLengthIndices[0] = this.dirtyRangeFrom;
            fromAndLengthIndices[1] = this.dirtyRangeLength;
            intArray.copyTo(this.dirtyRangeFrom, array, this.dirtyRangeFrom, this.dirtyRangeLength);
            return array;
        }
    }
}

