/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.PolylineHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPolyline;
import com.sun.javafx.sg.prism.NGShape;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;

public class Polyline
extends Shape {
    private final Path2D shape = new Path2D();
    private final ObservableList<Double> points;

    public Polyline() {
        PolylineHelper.initHelper(this);
        ((StyleableProperty)this.fillProperty()).applyStyle(null, null);
        ((StyleableProperty)this.strokeProperty()).applyStyle(null, Color.BLACK);
        this.points = new TrackableObservableList<Double>(){

            protected void onChanged(ListChangeListener.Change<Double> c) {
                NodeHelper.markDirty(Polyline.this, DirtyBits.NODE_GEOMETRY);
                NodeHelper.geomChanged(Polyline.this);
            }
        };
    }

    public Polyline(double ... points) {
        PolylineHelper.initHelper(this);
        ((StyleableProperty)this.fillProperty()).applyStyle(null, null);
        ((StyleableProperty)this.strokeProperty()).applyStyle(null, Color.BLACK);
        this.points = new /* invalid duplicate definition of identical inner class */;
        if (points != null) {
            for (double p : points) {
                this.getPoints().add((Object)p);
            }
        }
    }

    public final ObservableList<Double> getPoints() {
        return this.points;
    }

    private NGNode doCreatePeer() {
        return new NGPolyline();
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        if (this.getMode() == NGShape.Mode.EMPTY || this.getPoints().size() <= 1) {
            return bounds.makeEmpty();
        }
        if (this.getPoints().size() == 2) {
            if (this.getMode() == NGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
                return bounds.makeEmpty();
            }
            double upad = this.getStrokeWidth();
            if (this.getStrokeType() == StrokeType.CENTERED) {
                upad /= 2.0;
            }
            return this.computeBounds(bounds, tx, upad, 0.5, (Double)this.getPoints().get(0), (Double)this.getPoints().get(1), 0.0, 0.0);
        }
        return this.computeShapeBounds(bounds, tx, ShapeHelper.configShape(this));
    }

    private Path2D doConfigShape() {
        double p1 = (Double)this.getPoints().get(0);
        double p2 = (Double)this.getPoints().get(1);
        this.shape.reset();
        this.shape.moveTo((float)p1, (float)p2);
        int numValidPoints = this.getPoints().size() & 0xFFFFFFFE;
        for (int i = 2; i < numValidPoints; i += 2) {
            p1 = (Double)this.getPoints().get(i);
            p2 = (Double)this.getPoints().get(i + 1);
            this.shape.lineTo((float)p1, (float)p2);
        }
        return this.shape;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            int numValidPoints = this.getPoints().size() & 0xFFFFFFFE;
            float[] points_array = new float[numValidPoints];
            for (int i = 0; i < numValidPoints; ++i) {
                points_array[i] = (float)((Double)this.getPoints().get(i)).doubleValue();
            }
            NGPolyline peer = (NGPolyline)NodeHelper.getPeer(this);
            peer.updatePolyline(points_array);
        }
    }

    private Paint doCssGetFillInitialValue() {
        return null;
    }

    private Paint doCssGetStrokeInitialValue() {
        return Color.BLACK;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Polyline[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("points=").append(this.getPoints());
        sb.append(", fill=").append(this.getFill());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }

    static {
        PolylineHelper.setPolylineAccessor(new PolylineHelper.PolylineAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((Polyline)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Polyline)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Polyline)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public Paint doCssGetFillInitialValue(Shape shape) {
                return ((Polyline)shape).doCssGetFillInitialValue();
            }

            @Override
            public Paint doCssGetStrokeInitialValue(Shape shape) {
                return ((Polyline)shape).doCssGetStrokeInitialValue();
            }

            @Override
            public com.sun.javafx.geom.Shape doConfigShape(Shape shape) {
                return ((Polyline)shape).doConfigShape();
            }
        });
    }
}

