/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.shape.ArcToHelper;
import com.sun.javafx.sg.prism.NGPath;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.scene.shape.PathElement;

public class ArcTo
extends PathElement {
    private DoubleProperty radiusX = new DoublePropertyBase(){

        public void invalidated() {
            ArcTo.this.u();
        }

        public Object getBean() {
            return ArcTo.this;
        }

        public String getName() {
            return "radiusX";
        }
    };
    private DoubleProperty radiusY = new DoublePropertyBase(){

        public void invalidated() {
            ArcTo.this.u();
        }

        public Object getBean() {
            return ArcTo.this;
        }

        public String getName() {
            return "radiusY";
        }
    };
    private DoubleProperty xAxisRotation;
    private BooleanProperty largeArcFlag;
    private BooleanProperty sweepFlag;
    private DoubleProperty x;
    private DoubleProperty y;

    public ArcTo() {
        ArcToHelper.initHelper(this);
    }

    public ArcTo(double radiusX, double radiusY, double xAxisRotation, double x, double y, boolean largeArcFlag, boolean sweepFlag) {
        this.setRadiusX(radiusX);
        this.setRadiusY(radiusY);
        this.setXAxisRotation(xAxisRotation);
        this.setX(x);
        this.setY(y);
        this.setLargeArcFlag(largeArcFlag);
        this.setSweepFlag(sweepFlag);
        ArcToHelper.initHelper(this);
    }

    public final void setRadiusX(double value) {
        this.radiusX.set(value);
    }

    public final double getRadiusX() {
        return this.radiusX.get();
    }

    public final DoubleProperty radiusXProperty() {
        return this.radiusX;
    }

    public final void setRadiusY(double value) {
        this.radiusY.set(value);
    }

    public final double getRadiusY() {
        return this.radiusY.get();
    }

    public final DoubleProperty radiusYProperty() {
        return this.radiusY;
    }

    public final void setXAxisRotation(double value) {
        if (this.xAxisRotation != null || value != 0.0) {
            this.XAxisRotationProperty().set(value);
        }
    }

    public final double getXAxisRotation() {
        return this.xAxisRotation == null ? 0.0 : this.xAxisRotation.get();
    }

    public final DoubleProperty XAxisRotationProperty() {
        if (this.xAxisRotation == null) {
            this.xAxisRotation = new DoublePropertyBase(){

                public void invalidated() {
                    ArcTo.this.u();
                }

                public Object getBean() {
                    return ArcTo.this;
                }

                public String getName() {
                    return "XAxisRotation";
                }
            };
        }
        return this.xAxisRotation;
    }

    public final void setLargeArcFlag(boolean value) {
        if (this.largeArcFlag != null || value) {
            this.largeArcFlagProperty().set(value);
        }
    }

    public final boolean isLargeArcFlag() {
        return this.largeArcFlag == null ? false : this.largeArcFlag.get();
    }

    public final BooleanProperty largeArcFlagProperty() {
        if (this.largeArcFlag == null) {
            this.largeArcFlag = new BooleanPropertyBase(){

                public void invalidated() {
                    ArcTo.this.u();
                }

                public Object getBean() {
                    return ArcTo.this;
                }

                public String getName() {
                    return "largeArcFlag";
                }
            };
        }
        return this.largeArcFlag;
    }

    public final void setSweepFlag(boolean value) {
        if (this.sweepFlag != null || value) {
            this.sweepFlagProperty().set(value);
        }
    }

    public final boolean isSweepFlag() {
        return this.sweepFlag == null ? false : this.sweepFlag.get();
    }

    public final BooleanProperty sweepFlagProperty() {
        if (this.sweepFlag == null) {
            this.sweepFlag = new BooleanPropertyBase(){

                public void invalidated() {
                    ArcTo.this.u();
                }

                public Object getBean() {
                    return ArcTo.this;
                }

                public String getName() {
                    return "sweepFlag";
                }
            };
        }
        return this.sweepFlag;
    }

    public final void setX(double value) {
        if (this.x != null || value != 0.0) {
            this.xProperty().set(value);
        }
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                public void invalidated() {
                    ArcTo.this.u();
                }

                public Object getBean() {
                    return ArcTo.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        if (this.y != null || value != 0.0) {
            this.yProperty().set(value);
        }
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                public void invalidated() {
                    ArcTo.this.u();
                }

                public Object getBean() {
                    return ArcTo.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    @Override
    void addTo(NGPath pgPath) {
        this.addArcTo(pgPath, null, pgPath.getCurrentX(), pgPath.getCurrentY());
    }

    private void doAddTo(Path2D path) {
        this.addArcTo(null, path, path.getCurrentX(), path.getCurrentY());
    }

    private void addArcTo(NGPath pgPath, Path2D path, double x0, double y0) {
        double ry;
        double Pry;
        double Py1;
        double localX = this.getX();
        double localY = this.getY();
        boolean localSweepFlag = this.isSweepFlag();
        boolean localLargeArcFlag = this.isLargeArcFlag();
        double xto = this.isAbsolute() ? localX : localX + x0;
        double yto = this.isAbsolute() ? localY : localY + y0;
        double dx2 = (x0 - xto) / 2.0;
        double dy2 = (y0 - yto) / 2.0;
        double xAxisRotationR = Math.toRadians(this.getXAxisRotation());
        double cosAngle = Math.cos(xAxisRotationR);
        double sinAngle = Math.sin(xAxisRotationR);
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double Px1 = x1 * x1;
        double rx = Math.abs(this.getRadiusX());
        double Prx = rx * rx;
        double radiiCheck = Px1 / Prx + (Py1 = y1 * y1) / (Pry = (ry = Math.abs(this.getRadiusY())) * ry);
        if (radiiCheck > 1.0) {
            rx = Math.sqrt(radiiCheck) * rx;
            ry = Math.sqrt(radiiCheck) * ry;
            if (rx != rx || ry != ry) {
                if (pgPath == null) {
                    path.lineTo((float)xto, (float)yto);
                } else {
                    pgPath.addLineTo((float)xto, (float)yto);
                }
                return;
            }
            Prx = rx * rx;
            Pry = ry * ry;
        }
        double sign = localLargeArcFlag == localSweepFlag ? -1.0 : 1.0;
        double sq = (Prx * Pry - Prx * Py1 - Pry * Px1) / (Prx * Py1 + Pry * Px1);
        sq = sq < 0.0 ? 0.0 : sq;
        double coef = sign * Math.sqrt(sq);
        double cx1 = coef * (rx * y1 / ry);
        double cy1 = coef * -(ry * x1 / rx);
        double sx2 = (x0 + xto) / 2.0;
        double sy2 = (y0 + yto) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / rx;
        double uy = (y1 - cy1) / ry;
        double vx = (-x1 - cx1) / rx;
        double vy = (-y1 - cy1) / ry;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        double angleStart = Math.toDegrees(sign * Math.acos(p / n));
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double angleExtent = Math.toDegrees(sign * Math.acos(p / n));
        if (!localSweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (localSweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        angleExtent %= 360.0;
        float arcX = (float)(cx - rx);
        float arcY = (float)(cy - ry);
        float arcW = (float)(rx * 2.0);
        float arcH = (float)(ry * 2.0);
        float arcStart = (float)(-(angleStart %= 360.0));
        float arcExtent = (float)(-angleExtent);
        if (pgPath == null) {
            Arc2D arc = new Arc2D(arcX, arcY, arcW, arcH, arcStart, arcExtent, 0);
            BaseTransform xform = xAxisRotationR == 0.0 ? null : BaseTransform.getRotateInstance(xAxisRotationR, cx, cy);
            PathIterator pi = arc.getPathIterator(xform);
            pi.next();
            path.append(pi, true);
        } else {
            pgPath.addArcTo(arcX, arcY, arcW, arcH, arcStart, arcExtent, (float)xAxisRotationR);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArcTo[");
        sb.append("x=").append(this.getX());
        sb.append(", y=").append(this.getY());
        sb.append(", radiusX=").append(this.getRadiusX());
        sb.append(", radiusY=").append(this.getRadiusY());
        sb.append(", xAxisRotation=").append(this.getXAxisRotation());
        if (this.isLargeArcFlag()) {
            sb.append(", lartArcFlag");
        }
        if (this.isSweepFlag()) {
            sb.append(", sweepFlag");
        }
        return sb.append("]").toString();
    }

    static {
        ArcToHelper.setArcToAccessor(new ArcToHelper.ArcToAccessor(){

            @Override
            public void doAddTo(PathElement pathElement, Path2D path) {
                ((ArcTo)pathElement).doAddTo(path);
            }
        });
    }
}

