/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.layout.region.BorderImageSlices;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import java.util.Map;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

class BorderConverter
extends StyleConverter<ParsedValue[], Border> {
    private static final BorderConverter BORDER_IMAGE_CONVERTER = new BorderConverter();

    public static BorderConverter getInstance() {
        return BORDER_IMAGE_CONVERTER;
    }

    private BorderConverter() {
    }

    @Override
    public Border convert(Map<CssMetaData<? extends Styleable, ?>, Object> convertedValues) {
        int i;
        int lastInsetsIndex;
        boolean hasImages;
        Paint[][] strokeFills = (Paint[][])convertedValues.get(Border.BORDER_COLOR);
        BorderStrokeStyle[][] strokeStyles = (BorderStrokeStyle[][])convertedValues.get(Border.BORDER_STYLE);
        String[] imageUrls = (String[])convertedValues.get(Border.BORDER_IMAGE_SOURCE);
        boolean hasStrokes = strokeFills != null && strokeFills.length > 0 || strokeStyles != null && strokeStyles.length > 0;
        boolean bl = hasImages = imageUrls != null && imageUrls.length > 0;
        if (!hasStrokes && !hasImages) {
            return null;
        }
        BorderStroke[] borderStrokes = null;
        if (hasStrokes) {
            int lastStrokeFill = strokeFills != null ? strokeFills.length - 1 : -1;
            int lastStrokeStyle = strokeStyles != null ? strokeStyles.length - 1 : -1;
            int nLayers = (lastStrokeFill >= lastStrokeStyle ? lastStrokeFill : lastStrokeStyle) + 1;
            Object tmp = convertedValues.get(Border.BORDER_WIDTH);
            Margins[] borderWidths = tmp == null ? new Margins[]{} : (Margins[])tmp;
            int lastMarginIndex = borderWidths.length - 1;
            tmp = convertedValues.get(Border.BORDER_RADIUS);
            CornerRadii[] borderRadii = tmp == null ? new CornerRadii[]{} : (CornerRadii[])tmp;
            int lastRadiusIndex = borderRadii.length - 1;
            tmp = convertedValues.get(Border.BORDER_INSETS);
            Insets[] borderInsets = tmp == null ? new Insets[]{} : (Insets[])tmp;
            lastInsetsIndex = borderInsets.length - 1;
            for (i = 0; i < nLayers; ++i) {
                CornerRadii radii;
                Margins margins;
                Paint[] strokes;
                BorderStrokeStyle[] styles;
                if (lastStrokeStyle < 0) {
                    styles = new BorderStrokeStyle[4];
                    styles[2] = styles[3] = BorderStrokeStyle.SOLID;
                    styles[1] = styles[3];
                    styles[0] = styles[3];
                } else {
                    styles = strokeStyles[i <= lastStrokeStyle ? i : lastStrokeStyle];
                }
                if (styles[0] == BorderStrokeStyle.NONE && styles[1] == BorderStrokeStyle.NONE && styles[2] == BorderStrokeStyle.NONE && styles[3] == BorderStrokeStyle.NONE) continue;
                if (lastStrokeFill < 0) {
                    strokes = new Paint[4];
                    strokes[2] = strokes[3] = Color.BLACK;
                    strokes[1] = strokes[3];
                    strokes[0] = strokes[3];
                } else {
                    strokes = strokeFills[i <= lastStrokeFill ? i : lastStrokeFill];
                }
                if (borderStrokes == null) {
                    borderStrokes = new BorderStroke[nLayers];
                }
                Margins margins2 = borderWidths.length == 0 ? null : (margins = borderWidths[i <= lastMarginIndex ? i : lastMarginIndex]);
                CornerRadii cornerRadii = borderRadii.length == 0 ? CornerRadii.EMPTY : (radii = borderRadii[i <= lastRadiusIndex ? i : lastRadiusIndex]);
                Insets insets = borderInsets.length == 0 ? null : borderInsets[i <= lastInsetsIndex ? i : lastInsetsIndex];
                borderStrokes[i] = new BorderStroke(strokes[0], strokes[1], strokes[2], strokes[3], styles[0], styles[1], styles[2], styles[3], radii, margins == null ? BorderStroke.DEFAULT_WIDTHS : new BorderWidths(margins.getTop(), margins.getRight(), margins.getBottom(), margins.getLeft()), insets);
            }
        }
        BorderImage[] borderImages = null;
        if (hasImages) {
            borderImages = new BorderImage[imageUrls.length];
            Object tmp = convertedValues.get(Border.BORDER_IMAGE_REPEAT);
            RepeatStruct[] repeats = tmp == null ? new RepeatStruct[]{} : (RepeatStruct[])tmp;
            int lastRepeatIndex = repeats.length - 1;
            tmp = convertedValues.get(Border.BORDER_IMAGE_SLICE);
            BorderImageSlices[] slices = tmp == null ? new BorderImageSlices[]{} : (BorderImageSlices[])tmp;
            int lastSlicesIndex = slices.length - 1;
            tmp = convertedValues.get(Border.BORDER_IMAGE_WIDTH);
            BorderWidths[] widths = tmp == null ? new BorderWidths[]{} : (BorderWidths[])tmp;
            int lastWidthsIndex = widths.length - 1;
            tmp = convertedValues.get(Border.BORDER_IMAGE_INSETS);
            Insets[] insets = tmp == null ? new Insets[]{} : (Insets[])tmp;
            lastInsetsIndex = insets.length - 1;
            for (i = 0; i < imageUrls.length; ++i) {
                Insets inset;
                BorderImageSlices slice;
                if (imageUrls[i] == null) continue;
                BorderRepeat repeatX = BorderRepeat.STRETCH;
                BorderRepeat repeatY = BorderRepeat.STRETCH;
                if (repeats.length > 0) {
                    RepeatStruct repeat = repeats[i <= lastRepeatIndex ? i : lastRepeatIndex];
                    switch (repeat.repeatX) {
                        case SPACE: {
                            repeatX = BorderRepeat.SPACE;
                            break;
                        }
                        case ROUND: {
                            repeatX = BorderRepeat.ROUND;
                            break;
                        }
                        case REPEAT: {
                            repeatX = BorderRepeat.REPEAT;
                            break;
                        }
                        case NO_REPEAT: {
                            repeatX = BorderRepeat.STRETCH;
                        }
                    }
                    switch (repeat.repeatY) {
                        case SPACE: {
                            repeatY = BorderRepeat.SPACE;
                            break;
                        }
                        case ROUND: {
                            repeatY = BorderRepeat.ROUND;
                            break;
                        }
                        case REPEAT: {
                            repeatY = BorderRepeat.REPEAT;
                            break;
                        }
                        case NO_REPEAT: {
                            repeatY = BorderRepeat.STRETCH;
                        }
                    }
                }
                BorderImageSlices borderImageSlices = slices.length > 0 ? slices[i <= lastSlicesIndex ? i : lastSlicesIndex] : (slice = BorderImageSlices.DEFAULT);
                Insets insets2 = insets.length > 0 ? insets[i <= lastInsetsIndex ? i : lastInsetsIndex] : (inset = Insets.EMPTY);
                BorderWidths width = widths.length > 0 ? widths[i <= lastWidthsIndex ? i : lastWidthsIndex] : BorderWidths.DEFAULT;
                Image img = StyleManager.getInstance().getCachedImage(imageUrls[i]);
                borderImages[i] = new BorderImage(img, width, inset, slice.widths, slice.filled, repeatX, repeatY);
            }
        }
        return borderStrokes == null && borderImages == null ? null : new Border(borderStrokes, borderImages);
    }

    public String toString() {
        return "BorderConverter";
    }
}

