/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.PickResult;

public final class SwipeEvent
extends GestureEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<SwipeEvent> ANY = new EventType(GestureEvent.ANY, "ANY_SWIPE");
    public static final EventType<SwipeEvent> SWIPE_LEFT = new EventType(ANY, "SWIPE_LEFT");
    public static final EventType<SwipeEvent> SWIPE_RIGHT = new EventType(ANY, "SWIPE_RIGHT");
    public static final EventType<SwipeEvent> SWIPE_UP = new EventType(ANY, "SWIPE_UP");
    public static final EventType<SwipeEvent> SWIPE_DOWN = new EventType(ANY, "SWIPE_DOWN");
    private final int touchCount;

    public SwipeEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<SwipeEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="touchCount") int touchCount, @NamedArg(value="pickResult") PickResult pickResult) {
        super(source, target, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, false, pickResult);
        this.touchCount = touchCount;
    }

    public SwipeEvent(@NamedArg(value="eventType") EventType<SwipeEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="touchCount") int touchCount, @NamedArg(value="pickResult") PickResult pickResult) {
        this(null, null, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, touchCount, pickResult);
    }

    public int getTouchCount() {
        return this.touchCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SwipeEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", touchCount = ").append(this.getTouchCount());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        sb.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isShiftDown()) {
            sb.append(", shiftDown");
        }
        if (this.isControlDown()) {
            sb.append(", controlDown");
        }
        if (this.isAltDown()) {
            sb.append(", altDown");
        }
        if (this.isMetaDown()) {
            sb.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            sb.append(", shortcutDown");
        }
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    @Override
    public SwipeEvent copyFor(Object newSource, EventTarget newTarget) {
        return (SwipeEvent)super.copyFor(newSource, newTarget);
    }

    public SwipeEvent copyFor(Object newSource, EventTarget newTarget, EventType<SwipeEvent> type) {
        SwipeEvent e = this.copyFor(newSource, newTarget);
        e.eventType = type;
        return e;
    }

    public EventType<SwipeEvent> getEventType() {
        return super.getEventType();
    }
}

