/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.tk.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point3D;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.PickResult;

public class MouseEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<MouseEvent> ANY = new EventType(InputEvent.ANY, "MOUSE");
    public static final EventType<MouseEvent> MOUSE_PRESSED = new EventType(ANY, "MOUSE_PRESSED");
    public static final EventType<MouseEvent> MOUSE_RELEASED = new EventType(ANY, "MOUSE_RELEASED");
    public static final EventType<MouseEvent> MOUSE_CLICKED = new EventType(ANY, "MOUSE_CLICKED");
    public static final EventType<MouseEvent> MOUSE_ENTERED_TARGET = new EventType(ANY, "MOUSE_ENTERED_TARGET");
    public static final EventType<MouseEvent> MOUSE_ENTERED = new EventType(MOUSE_ENTERED_TARGET, "MOUSE_ENTERED");
    public static final EventType<MouseEvent> MOUSE_EXITED_TARGET = new EventType(ANY, "MOUSE_EXITED_TARGET");
    public static final EventType<MouseEvent> MOUSE_EXITED = new EventType(MOUSE_EXITED_TARGET, "MOUSE_EXITED");
    public static final EventType<MouseEvent> MOUSE_MOVED = new EventType(ANY, "MOUSE_MOVED");
    public static final EventType<MouseEvent> MOUSE_DRAGGED = new EventType(ANY, "MOUSE_DRAGGED");
    public static final EventType<MouseEvent> DRAG_DETECTED = new EventType(ANY, "DRAG_DETECTED");
    private final Flags flags = new Flags();
    private transient double x;
    private transient double y;
    private transient double z;
    private final double screenX;
    private final double screenY;
    private final double sceneX;
    private final double sceneY;
    private final MouseButton button;
    private final int clickCount;
    private final boolean stillSincePress;
    private final boolean shiftDown;
    private final boolean controlDown;
    private final boolean altDown;
    private final boolean metaDown;
    private final boolean synthesized;
    private final boolean popupTrigger;
    private final boolean primaryButtonDown;
    private final boolean secondaryButtonDown;
    private final boolean middleButtonDown;
    private PickResult pickResult;

    void recomputeCoordinatesToSource(MouseEvent oldEvent, Object newSource) {
        Point3D newCoordinates = InputEventUtils.recomputeCoordinates(this.pickResult, newSource);
        this.x = newCoordinates.getX();
        this.y = newCoordinates.getY();
        this.z = newCoordinates.getZ();
    }

    public EventType<? extends MouseEvent> getEventType() {
        return super.getEventType();
    }

    public MouseEvent copyFor(Object newSource, EventTarget newTarget) {
        MouseEvent e = (MouseEvent)super.copyFor(newSource, newTarget);
        e.recomputeCoordinatesToSource(this, newSource);
        return e;
    }

    public MouseEvent copyFor(Object newSource, EventTarget newTarget, EventType<? extends MouseEvent> eventType) {
        MouseEvent e = this.copyFor(newSource, newTarget);
        e.eventType = eventType;
        return e;
    }

    public MouseEvent(@NamedArg(value="eventType") EventType<? extends MouseEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="button") MouseButton button, @NamedArg(value="clickCount") int clickCount, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="primaryButtonDown") boolean primaryButtonDown, @NamedArg(value="middleButtonDown") boolean middleButtonDown, @NamedArg(value="secondaryButtonDown") boolean secondaryButtonDown, @NamedArg(value="synthesized") boolean synthesized, @NamedArg(value="popupTrigger") boolean popupTrigger, @NamedArg(value="stillSincePress") boolean stillSincePress, @NamedArg(value="pickResult") PickResult pickResult) {
        this(null, null, eventType, x, y, screenX, screenY, button, clickCount, shiftDown, controlDown, altDown, metaDown, primaryButtonDown, middleButtonDown, secondaryButtonDown, synthesized, popupTrigger, stillSincePress, pickResult);
    }

    public MouseEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<? extends MouseEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="button") MouseButton button, @NamedArg(value="clickCount") int clickCount, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="primaryButtonDown") boolean primaryButtonDown, @NamedArg(value="middleButtonDown") boolean middleButtonDown, @NamedArg(value="secondaryButtonDown") boolean secondaryButtonDown, @NamedArg(value="synthesized") boolean synthesized, @NamedArg(value="popupTrigger") boolean popupTrigger, @NamedArg(value="stillSincePress") boolean stillSincePress, @NamedArg(value="pickResult") PickResult pickResult) {
        super(source, target, eventType);
        this.x = x;
        this.y = y;
        this.screenX = screenX;
        this.screenY = screenY;
        this.sceneX = x;
        this.sceneY = y;
        this.button = button;
        this.clickCount = clickCount;
        this.shiftDown = shiftDown;
        this.controlDown = controlDown;
        this.altDown = altDown;
        this.metaDown = metaDown;
        this.primaryButtonDown = primaryButtonDown;
        this.middleButtonDown = middleButtonDown;
        this.secondaryButtonDown = secondaryButtonDown;
        this.synthesized = synthesized;
        this.stillSincePress = stillSincePress;
        this.popupTrigger = popupTrigger;
        this.pickResult = pickResult;
        this.pickResult = pickResult != null ? pickResult : new PickResult(target, x, y);
        Point3D p = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    public static MouseDragEvent copyForMouseDragEvent(MouseEvent e, Object source, EventTarget target, EventType<MouseDragEvent> type, Object gestureSource, PickResult pickResult) {
        MouseDragEvent ev = new MouseDragEvent(source, target, type, e.sceneX, e.sceneY, e.screenX, e.screenY, e.button, e.clickCount, e.shiftDown, e.controlDown, e.altDown, e.metaDown, e.primaryButtonDown, e.middleButtonDown, e.secondaryButtonDown, e.synthesized, e.popupTrigger, pickResult, gestureSource);
        ev.recomputeCoordinatesToSource(e, source);
        return ev;
    }

    public boolean isDragDetect() {
        return this.flags.dragDetect;
    }

    public void setDragDetect(boolean dragDetect) {
        this.flags.dragDetect = dragDetect;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final MouseButton getButton() {
        return this.button;
    }

    public final int getClickCount() {
        return this.clickCount;
    }

    public final boolean isStillSincePress() {
        return this.stillSincePress;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public boolean isSynthesized() {
        return this.synthesized;
    }

    public final boolean isShortcutDown() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shiftDown;
            }
            case CONTROL: {
                return this.controlDown;
            }
            case ALT: {
                return this.altDown;
            }
            case META: {
                return this.metaDown;
            }
        }
        return false;
    }

    public final boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public final boolean isPrimaryButtonDown() {
        return this.primaryButtonDown;
    }

    public final boolean isSecondaryButtonDown() {
        return this.secondaryButtonDown;
    }

    public final boolean isMiddleButtonDown() {
        return this.middleButtonDown;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MouseEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        if (this.getButton() != null) {
            sb.append(", button = ").append((Object)this.getButton());
        }
        if (this.getClickCount() > 1) {
            sb.append(", clickCount = ").append(this.getClickCount());
        }
        if (this.isPrimaryButtonDown()) {
            sb.append(", primaryButtonDown");
        }
        if (this.isMiddleButtonDown()) {
            sb.append(", middleButtonDown");
        }
        if (this.isSecondaryButtonDown()) {
            sb.append(", secondaryButtonDown");
        }
        if (this.isShiftDown()) {
            sb.append(", shiftDown");
        }
        if (this.isControlDown()) {
            sb.append(", controlDown");
        }
        if (this.isAltDown()) {
            sb.append(", altDown");
        }
        if (this.isMetaDown()) {
            sb.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            sb.append(", shortcutDown");
        }
        if (this.isSynthesized()) {
            sb.append(", synthesized");
        }
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    public final PickResult getPickResult() {
        return this.pickResult;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = this.sceneX;
        this.y = this.sceneY;
    }

    private static class Flags
    implements Cloneable {
        boolean dragDetect = true;

        private Flags() {
        }

        public Flags clone() {
            try {
                return (Flags)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

