/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;

public final class MouseDragEvent
extends MouseEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<MouseDragEvent> ANY = new EventType(MouseEvent.ANY, "MOUSE-DRAG");
    public static final EventType<MouseDragEvent> MOUSE_DRAG_OVER = new EventType(ANY, "MOUSE-DRAG_OVER");
    public static final EventType<MouseDragEvent> MOUSE_DRAG_RELEASED = new EventType(ANY, "MOUSE-DRAG_RELEASED");
    public static final EventType<MouseDragEvent> MOUSE_DRAG_ENTERED_TARGET = new EventType(ANY, "MOUSE-DRAG_ENTERED_TARGET");
    public static final EventType<MouseDragEvent> MOUSE_DRAG_ENTERED = new EventType(MOUSE_DRAG_ENTERED_TARGET, "MOUSE-DRAG_ENTERED");
    public static final EventType<MouseDragEvent> MOUSE_DRAG_EXITED_TARGET = new EventType(ANY, "MOUSE-DRAG_EXITED_TARGET");
    public static final EventType<MouseDragEvent> MOUSE_DRAG_EXITED = new EventType(MOUSE_DRAG_EXITED_TARGET, "MOUSE-DRAG_EXITED");
    private final transient Object gestureSource;

    public MouseDragEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<MouseDragEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="button") MouseButton button, @NamedArg(value="clickCount") int clickCount, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="primaryButtonDown") boolean primaryButtonDown, @NamedArg(value="middleButtonDown") boolean middleButtonDown, @NamedArg(value="secondaryButtonDown") boolean secondaryButtonDown, @NamedArg(value="synthesized") boolean synthesized, @NamedArg(value="popupTrigger") boolean popupTrigger, @NamedArg(value="pickResult") PickResult pickResult, @NamedArg(value="gestureSource") Object gestureSource) {
        super(source, target, eventType, x, y, screenX, screenY, button, clickCount, shiftDown, controlDown, altDown, metaDown, primaryButtonDown, middleButtonDown, secondaryButtonDown, synthesized, popupTrigger, false, pickResult);
        this.gestureSource = gestureSource;
    }

    public MouseDragEvent(@NamedArg(value="eventType") EventType<MouseDragEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="button") MouseButton button, @NamedArg(value="clickCount") int clickCount, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="primaryButtonDown") boolean primaryButtonDown, @NamedArg(value="middleButtonDown") boolean middleButtonDown, @NamedArg(value="secondaryButtonDown") boolean secondaryButtonDown, @NamedArg(value="synthesized") boolean synthesized, @NamedArg(value="popupTrigger") boolean popupTrigger, @NamedArg(value="pickResult") PickResult pickResult, @NamedArg(value="gestureSource") Object gestureSource) {
        this(null, null, eventType, x, y, screenX, screenY, button, clickCount, shiftDown, controlDown, altDown, metaDown, primaryButtonDown, middleButtonDown, secondaryButtonDown, synthesized, popupTrigger, pickResult, gestureSource);
    }

    public Object getGestureSource() {
        return this.gestureSource;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MouseDragEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", gestureSource = ").append(this.getGestureSource());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        if (this.getButton() != null) {
            sb.append(", button = ").append((Object)this.getButton());
        }
        if (this.getClickCount() > 1) {
            sb.append(", clickCount = ").append(this.getClickCount());
        }
        if (this.isPrimaryButtonDown()) {
            sb.append(", primaryButtonDown");
        }
        if (this.isMiddleButtonDown()) {
            sb.append(", middleButtonDown");
        }
        if (this.isSecondaryButtonDown()) {
            sb.append(", secondaryButtonDown");
        }
        if (this.isShiftDown()) {
            sb.append(", shiftDown");
        }
        if (this.isControlDown()) {
            sb.append(", controlDown");
        }
        if (this.isAltDown()) {
            sb.append(", altDown");
        }
        if (this.isMetaDown()) {
            sb.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            sb.append(", shortcutDown");
        }
        if (this.isSynthesized()) {
            sb.append(", synthesized");
        }
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    @Override
    public MouseDragEvent copyFor(Object newSource, EventTarget newTarget) {
        return (MouseDragEvent)super.copyFor(newSource, newTarget);
    }

    @Override
    public MouseDragEvent copyFor(Object newSource, EventTarget newTarget, EventType<? extends MouseEvent> type) {
        return (MouseDragEvent)super.copyFor(newSource, newTarget, type);
    }

    public EventType<MouseDragEvent> getEventType() {
        return super.getEventType();
    }
}

