/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.tk.Toolkit;
import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;

public final class KeyEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<KeyEvent> ANY = new EventType(InputEvent.ANY, "KEY");
    public static final EventType<KeyEvent> KEY_PRESSED = new EventType(ANY, "KEY_PRESSED");
    public static final EventType<KeyEvent> KEY_RELEASED = new EventType(ANY, "KEY_RELEASED");
    public static final EventType<KeyEvent> KEY_TYPED = new EventType(ANY, "KEY_TYPED");
    public static final String CHAR_UNDEFINED = KeyCode.UNDEFINED.ch;
    private final String character;
    private final String text;
    private final KeyCode code;
    private final boolean shiftDown;
    private final boolean controlDown;
    private final boolean altDown;
    private final boolean metaDown;

    public KeyEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<KeyEvent> eventType, @NamedArg(value="character") String character, @NamedArg(value="text") String text, @NamedArg(value="code") KeyCode code, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown) {
        super(source, target, eventType);
        boolean isKeyTyped = eventType == KEY_TYPED;
        this.character = isKeyTyped ? character : CHAR_UNDEFINED;
        this.text = isKeyTyped ? "" : text;
        this.code = isKeyTyped ? KeyCode.UNDEFINED : code;
        this.shiftDown = shiftDown;
        this.controlDown = controlDown;
        this.altDown = altDown;
        this.metaDown = metaDown;
    }

    public KeyEvent(@NamedArg(value="eventType") EventType<KeyEvent> eventType, @NamedArg(value="character") String character, @NamedArg(value="text") String text, @NamedArg(value="code") KeyCode code, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown) {
        super(eventType);
        boolean isKeyTyped = eventType == KEY_TYPED;
        this.character = isKeyTyped ? character : CHAR_UNDEFINED;
        this.text = isKeyTyped ? "" : text;
        this.code = isKeyTyped ? KeyCode.UNDEFINED : code;
        this.shiftDown = shiftDown;
        this.controlDown = controlDown;
        this.altDown = altDown;
        this.metaDown = metaDown;
    }

    public final String getCharacter() {
        return this.character;
    }

    public final String getText() {
        return this.text;
    }

    public final KeyCode getCode() {
        return this.code;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public final boolean isShortcutDown() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shiftDown;
            }
            case CONTROL: {
                return this.controlDown;
            }
            case ALT: {
                return this.altDown;
            }
            case META: {
                return this.metaDown;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KeyEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", character = ").append(this.getCharacter());
        sb.append(", text = ").append(this.getText());
        sb.append(", code = ").append((Object)this.getCode());
        if (this.isShiftDown()) {
            sb.append(", shiftDown");
        }
        if (this.isControlDown()) {
            sb.append(", controlDown");
        }
        if (this.isAltDown()) {
            sb.append(", altDown");
        }
        if (this.isMetaDown()) {
            sb.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            sb.append(", shortcutDown");
        }
        return sb.append("]").toString();
    }

    public KeyEvent copyFor(Object newSource, EventTarget newTarget) {
        return (KeyEvent)super.copyFor(newSource, newTarget);
    }

    public KeyEvent copyFor(Object source, EventTarget target, EventType<KeyEvent> type) {
        KeyEvent e = this.copyFor(source, target);
        e.eventType = type;
        return e;
    }

    public EventType<KeyEvent> getEventType() {
        return super.getEventType();
    }
}

