/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.runtime.async.AsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.Toolkit;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.regex.Pattern;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoublePropertyBase;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class Image {
    private static final Pattern URL_QUICKMATCH;
    private final String url;
    private final InputStream inputSource;
    private ReadOnlyDoubleWrapper progress;
    private final double requestedWidth;
    private final double requestedHeight;
    private DoublePropertyImpl width;
    private DoublePropertyImpl height;
    private final boolean preserveRatio;
    private final boolean smooth;
    private final boolean backgroundLoading;
    private ReadOnlyBooleanWrapper error;
    private ReadOnlyObjectWrapper<Exception> exception;
    private ObjectPropertyImpl<PlatformImage> platformImage;
    private ImageTask backgroundTask;
    private Animation animation;
    private PlatformImage[] animFrames;
    private static final int MAX_RUNNING_TASKS = 4;
    private static int runningTasks;
    private static final Queue<ImageTask> pendingTasks;
    private PixelReader reader;

    public final String getUrl() {
        return this.url;
    }

    final InputStream getInputSource() {
        return this.inputSource;
    }

    final void setProgress(double value) {
        this.progressPropertyImpl().set(value);
    }

    public final double getProgress() {
        return this.progress == null ? 0.0 : this.progress.get();
    }

    public final ReadOnlyDoubleProperty progressProperty() {
        return this.progressPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper progressPropertyImpl() {
        if (this.progress == null) {
            this.progress = new ReadOnlyDoubleWrapper((Object)this, "progress");
        }
        return this.progress;
    }

    public final double getRequestedWidth() {
        return this.requestedWidth;
    }

    public final double getRequestedHeight() {
        return this.requestedHeight;
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl();
    }

    private DoublePropertyImpl widthPropertyImpl() {
        if (this.width == null) {
            this.width = new DoublePropertyImpl("width");
        }
        return this.width;
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl();
    }

    private DoublePropertyImpl heightPropertyImpl() {
        if (this.height == null) {
            this.height = new DoublePropertyImpl("height");
        }
        return this.height;
    }

    public final boolean isPreserveRatio() {
        return this.preserveRatio;
    }

    public final boolean isSmooth() {
        return this.smooth;
    }

    public final boolean isBackgroundLoading() {
        return this.backgroundLoading;
    }

    private void setError(boolean value) {
        this.errorPropertyImpl().set(value);
    }

    public final boolean isError() {
        return this.error == null ? false : this.error.get();
    }

    public final ReadOnlyBooleanProperty errorProperty() {
        return this.errorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper errorPropertyImpl() {
        if (this.error == null) {
            this.error = new ReadOnlyBooleanWrapper((Object)this, "error");
        }
        return this.error;
    }

    private void setException(Exception value) {
        this.exceptionPropertyImpl().set((Object)value);
    }

    public final Exception getException() {
        return this.exception == null ? null : (Exception)this.exception.get();
    }

    public final ReadOnlyObjectProperty<Exception> exceptionProperty() {
        return this.exceptionPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Exception> exceptionPropertyImpl() {
        if (this.exception == null) {
            this.exception = new ReadOnlyObjectWrapper((Object)this, "exception");
        }
        return this.exception;
    }

    final Object getPlatformImage() {
        return this.platformImage == null ? null : this.platformImage.get();
    }

    final ReadOnlyObjectProperty<PlatformImage> acc_platformImageProperty() {
        return this.platformImagePropertyImpl();
    }

    private ObjectPropertyImpl<PlatformImage> platformImagePropertyImpl() {
        if (this.platformImage == null) {
            this.platformImage = new ObjectPropertyImpl("platformImage");
        }
        return this.platformImage;
    }

    void pixelsDirty() {
        this.platformImagePropertyImpl().fireValueChangedEvent();
    }

    public Image(@NamedArg(value="url") String url) {
        this(Image.validateUrl(url), null, 0.0, 0.0, false, false, false);
        this.initialize(null);
    }

    public Image(@NamedArg(value="url") String url, @NamedArg(value="backgroundLoading") boolean backgroundLoading) {
        this(Image.validateUrl(url), null, 0.0, 0.0, false, false, backgroundLoading);
        this.initialize(null);
    }

    public Image(@NamedArg(value="url") String url, @NamedArg(value="requestedWidth") double requestedWidth, @NamedArg(value="requestedHeight") double requestedHeight, @NamedArg(value="preserveRatio") boolean preserveRatio, @NamedArg(value="smooth") boolean smooth) {
        this(Image.validateUrl(url), null, requestedWidth, requestedHeight, preserveRatio, smooth, false);
        this.initialize(null);
    }

    public Image(@NamedArg(value="url", defaultValue="\"\"") String url, @NamedArg(value="requestedWidth") double requestedWidth, @NamedArg(value="requestedHeight") double requestedHeight, @NamedArg(value="preserveRatio") boolean preserveRatio, @NamedArg(value="smooth", defaultValue="true") boolean smooth, @NamedArg(value="backgroundLoading") boolean backgroundLoading) {
        this(Image.validateUrl(url), null, requestedWidth, requestedHeight, preserveRatio, smooth, backgroundLoading);
        this.initialize(null);
    }

    public Image(@NamedArg(value="is") InputStream is) {
        this(null, Image.validateInputStream(is), 0.0, 0.0, false, false, false);
        this.initialize(null);
    }

    public Image(@NamedArg(value="is") InputStream is, @NamedArg(value="requestedWidth") double requestedWidth, @NamedArg(value="requestedHeight") double requestedHeight, @NamedArg(value="preserveRatio") boolean preserveRatio, @NamedArg(value="smooth") boolean smooth) {
        this(null, Image.validateInputStream(is), requestedWidth, requestedHeight, preserveRatio, smooth, false);
        this.initialize(null);
    }

    Image(int width, int height) {
        this(null, null, width, height, false, false, false);
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image dimensions must be positive (w,h > 0)");
        }
        this.initialize(Toolkit.getToolkit().createPlatformImage(width, height));
    }

    private Image(Object externalImage) {
        this(null, null, 0.0, 0.0, false, false, false);
        this.initialize(externalImage);
    }

    private Image(String url, InputStream is, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth, boolean backgroundLoading) {
        this.url = url;
        this.inputSource = is;
        this.requestedWidth = requestedWidth;
        this.requestedHeight = requestedHeight;
        this.preserveRatio = preserveRatio;
        this.smooth = smooth;
        this.backgroundLoading = backgroundLoading;
    }

    public void cancel() {
        if (this.backgroundTask != null) {
            this.backgroundTask.cancel();
        }
    }

    void dispose() {
        this.cancel();
        if (this.animation != null) {
            this.animation.stop();
        }
    }

    private void initialize(Object externalImage) {
        if (externalImage != null) {
            ImageLoader loader = Image.loadPlatformImage(externalImage);
            this.finishImage(loader);
        } else if (this.isBackgroundLoading() && this.inputSource == null) {
            this.loadInBackground();
        } else {
            ImageLoader loader = this.inputSource != null ? Image.loadImage(this.inputSource, this.getRequestedWidth(), this.getRequestedHeight(), this.isPreserveRatio(), this.isSmooth()) : Image.loadImage(this.getUrl(), this.getRequestedWidth(), this.getRequestedHeight(), this.isPreserveRatio(), this.isSmooth());
            this.finishImage(loader);
        }
    }

    private void finishImage(ImageLoader loader) {
        Exception loadingException = loader.getException();
        if (loadingException != null) {
            this.finishImage(loadingException);
            return;
        }
        if (loader.getFrameCount() > 1) {
            this.initializeAnimatedImage(loader);
        } else {
            PlatformImage pi = loader.getFrame(0);
            double w = loader.getWidth() / (double)pi.getPixelScale();
            double h = loader.getHeight() / (double)pi.getPixelScale();
            this.setPlatformImageWH(pi, w, h);
        }
        this.setProgress(1.0);
    }

    private void finishImage(Exception exception) {
        this.setException(exception);
        this.setError(true);
        this.setPlatformImageWH(null, 0.0, 0.0);
        this.setProgress(1.0);
    }

    private void initializeAnimatedImage(ImageLoader loader) {
        int frameCount = loader.getFrameCount();
        this.animFrames = new PlatformImage[frameCount];
        for (int i = 0; i < frameCount; ++i) {
            this.animFrames[i] = loader.getFrame(i);
        }
        PlatformImage zeroFrame = loader.getFrame(0);
        double w = loader.getWidth() / (double)zeroFrame.getPixelScale();
        double h = loader.getHeight() / (double)zeroFrame.getPixelScale();
        this.setPlatformImageWH(zeroFrame, w, h);
        this.animation = new Animation(this, loader);
        this.animation.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cycleTasks() {
        Queue<ImageTask> queue = pendingTasks;
        synchronized (queue) {
            --runningTasks;
            ImageTask nextTask = pendingTasks.poll();
            if (nextTask != null) {
                ++runningTasks;
                nextTask.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInBackground() {
        this.backgroundTask = new ImageTask();
        Queue<ImageTask> queue = pendingTasks;
        synchronized (queue) {
            if (runningTasks >= 4) {
                pendingTasks.offer(this.backgroundTask);
            } else {
                ++runningTasks;
                this.backgroundTask.start();
            }
        }
    }

    static Image fromPlatformImage(Object image) {
        return new Image(image);
    }

    private void setPlatformImageWH(PlatformImage newPlatformImage, double newWidth, double newHeight) {
        if (Toolkit.getImageAccessor().getPlatformImage(this) == newPlatformImage && this.getWidth() == newWidth && this.getHeight() == newHeight) {
            return;
        }
        Object oldPlatformImage = Toolkit.getImageAccessor().getPlatformImage(this);
        double oldWidth = this.getWidth();
        double oldHeight = this.getHeight();
        this.storePlatformImageWH(newPlatformImage, newWidth, newHeight);
        if (oldPlatformImage != newPlatformImage) {
            this.platformImagePropertyImpl().fireValueChangedEvent();
        }
        if (oldWidth != newWidth) {
            this.widthPropertyImpl().fireValueChangedEvent();
        }
        if (oldHeight != newHeight) {
            this.heightPropertyImpl().fireValueChangedEvent();
        }
    }

    private void storePlatformImageWH(PlatformImage platformImage, double width, double height) {
        this.platformImagePropertyImpl().store(platformImage);
        this.widthPropertyImpl().store(width);
        this.heightPropertyImpl().store(height);
    }

    void setPlatformImage(PlatformImage newPlatformImage) {
        this.platformImage.set(newPlatformImage);
    }

    private static ImageLoader loadImage(String url, double width, double height, boolean preserveRatio, boolean smooth) {
        return Toolkit.getToolkit().loadImage(url, width, height, preserveRatio, smooth);
    }

    private static ImageLoader loadImage(InputStream stream, double width, double height, boolean preserveRatio, boolean smooth) {
        return Toolkit.getToolkit().loadImage(stream, width, height, preserveRatio, smooth);
    }

    private static AsyncOperation loadImageAsync(AsyncOperationListener<? extends ImageLoader> listener, String url, double width, double height, boolean preserveRatio, boolean smooth) {
        return Toolkit.getToolkit().loadImageAsync(listener, url, width, height, preserveRatio, smooth);
    }

    private static ImageLoader loadPlatformImage(Object platformImage) {
        return Toolkit.getToolkit().loadPlatformImage(platformImage);
    }

    private static String validateUrl(String url) {
        if (url == null) {
            throw new NullPointerException("URL must not be null");
        }
        if (url.trim().isEmpty()) {
            throw new IllegalArgumentException("URL must not be empty");
        }
        try {
            if (!URL_QUICKMATCH.matcher(url).matches()) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                URL resource = url.charAt(0) == '/' ? contextClassLoader.getResource(url.substring(1)) : contextClassLoader.getResource(url);
                if (resource == null) {
                    throw new IllegalArgumentException("Invalid URL or resource not found");
                }
                return resource.toString();
            }
            return new URL(url).toString();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Image.constructDetailedExceptionMessage("Invalid URL", e), e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(Image.constructDetailedExceptionMessage("Invalid URL", e), e);
        }
    }

    private static InputStream validateInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Input stream must not be null");
        }
        return inputStream;
    }

    private static String constructDetailedExceptionMessage(String mainMessage, Throwable cause) {
        if (cause == null) {
            return mainMessage;
        }
        String causeMessage = cause.getMessage();
        return Image.constructDetailedExceptionMessage((String)(causeMessage != null ? mainMessage + ": " + causeMessage : mainMessage), cause.getCause());
    }

    boolean isAnimation() {
        return this.animation != null;
    }

    boolean pixelsReadable() {
        return this.getProgress() >= 1.0 && !this.isAnimation() && !this.isError();
    }

    public final PixelReader getPixelReader() {
        if (!this.pixelsReadable()) {
            return null;
        }
        if (this.reader == null) {
            this.reader = new PixelReader(){

                @Override
                public PixelFormat getPixelFormat() {
                    PlatformImage pimg = (PlatformImage)Image.this.platformImage.get();
                    return pimg.getPlatformPixelFormat();
                }

                @Override
                public int getArgb(int x, int y) {
                    PlatformImage pimg = (PlatformImage)Image.this.platformImage.get();
                    return pimg.getArgb(x, y);
                }

                @Override
                public Color getColor(int x, int y) {
                    int argb = this.getArgb(x, y);
                    int a = argb >>> 24;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    return Color.rgb(r, g, b, (double)a / 255.0);
                }

                @Override
                public <T extends Buffer> void getPixels(int x, int y, int w, int h, WritablePixelFormat<T> pixelformat, T buffer, int scanlineStride) {
                    PlatformImage pimg = (PlatformImage)Image.this.platformImage.get();
                    pimg.getPixels(x, y, w, h, pixelformat, buffer, scanlineStride);
                }

                @Override
                public void getPixels(int x, int y, int w, int h, WritablePixelFormat<ByteBuffer> pixelformat, byte[] buffer, int offset, int scanlineStride) {
                    PlatformImage pimg = (PlatformImage)Image.this.platformImage.get();
                    pimg.getPixels(x, y, w, h, pixelformat, buffer, offset, scanlineStride);
                }

                @Override
                public void getPixels(int x, int y, int w, int h, WritablePixelFormat<IntBuffer> pixelformat, int[] buffer, int offset, int scanlineStride) {
                    PlatformImage pimg = (PlatformImage)Image.this.platformImage.get();
                    pimg.getPixels(x, y, w, h, pixelformat, buffer, offset, scanlineStride);
                }
            };
        }
        return this.reader;
    }

    PlatformImage getWritablePlatformImage() {
        PlatformImage pimg = this.platformImage.get();
        if (!pimg.isWritable()) {
            pimg = pimg.promoteToWritableImage();
            this.platformImage.set(pimg);
        }
        return pimg;
    }

    static {
        Toolkit.setImageAccessor(new Toolkit.ImageAccessor(){

            @Override
            public boolean isAnimation(Image image) {
                return image.isAnimation();
            }

            @Override
            public ReadOnlyObjectProperty<PlatformImage> getImageProperty(Image image) {
                return image.acc_platformImageProperty();
            }

            @Override
            public int[] getPreColors(PixelFormat<ByteBuffer> pf) {
                return ((PixelFormat.IndexedPixelFormat)pf).getPreColors();
            }

            @Override
            public int[] getNonPreColors(PixelFormat<ByteBuffer> pf) {
                return ((PixelFormat.IndexedPixelFormat)pf).getNonPreColors();
            }

            @Override
            public Object getPlatformImage(Image image) {
                return image.getPlatformImage();
            }

            @Override
            public Image fromPlatformImage(Object image) {
                return Image.fromPlatformImage(image);
            }
        });
        URL_QUICKMATCH = Pattern.compile("^\\p{Alpha}[\\p{Alnum}+.-]*:.*$");
        runningTasks = 0;
        pendingTasks = new LinkedList<ImageTask>();
    }

    private final class ImageTask
    implements AsyncOperationListener<ImageLoader> {
        private final AsyncOperation peer = this.constructPeer();

        @Override
        public void onCancel() {
            Image.this.finishImage(new CancellationException("Loading cancelled"));
            Image.this.cycleTasks();
        }

        @Override
        public void onException(Exception exception) {
            Image.this.finishImage(exception);
            Image.this.cycleTasks();
        }

        @Override
        public void onCompletion(ImageLoader value) {
            Image.this.finishImage(value);
            Image.this.cycleTasks();
        }

        @Override
        public void onProgress(int cur, int max) {
            double curProgress;
            if (max > 0 && (curProgress = (double)cur / (double)max) < 1.0 && curProgress >= Image.this.getProgress() + 0.1) {
                Image.this.setProgress(curProgress);
            }
        }

        public void start() {
            this.peer.start();
        }

        public void cancel() {
            this.peer.cancel();
        }

        private AsyncOperation constructPeer() {
            return Image.loadImageAsync(this, Image.this.url, Image.this.requestedWidth, Image.this.requestedHeight, Image.this.preserveRatio, Image.this.smooth);
        }
    }

    private static final class Animation {
        final WeakReference<Image> imageRef;
        final Timeline timeline;
        final SimpleIntegerProperty frameIndex = new SimpleIntegerProperty(){

            protected void invalidated() {
                this.updateImage(this.get());
            }
        };

        public Animation(Image image, ImageLoader loader) {
            this.imageRef = new WeakReference<Image>(image);
            this.timeline = new Timeline();
            int loopCount = loader.getLoopCount();
            this.timeline.setCycleCount(loopCount == 0 ? -1 : loopCount);
            int frameCount = loader.getFrameCount();
            int duration = 0;
            for (int i = 0; i < frameCount; ++i) {
                this.addKeyFrame(i, duration);
                duration += loader.getFrameDelay(i);
            }
            this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue[0]));
        }

        public void start() {
            this.timeline.play();
        }

        public void stop() {
            this.timeline.stop();
        }

        private void updateImage(int frameIndex) {
            Image image = (Image)this.imageRef.get();
            if (image != null) {
                image.platformImagePropertyImpl().set(image.animFrames[frameIndex]);
            } else {
                this.timeline.stop();
            }
        }

        private void addKeyFrame(int index, double duration) {
            this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)duration), new KeyValue(this.frameIndex, index, Interpolator.DISCRETE)));
        }
    }

    private final class ObjectPropertyImpl<T>
    extends ReadOnlyObjectPropertyBase<T> {
        private final String name;
        private T value;
        private boolean valid = true;

        public ObjectPropertyImpl(String name) {
            this.name = name;
        }

        public void store(T value) {
            this.value = value;
        }

        public void set(T value) {
            if (this.value != value) {
                this.value = value;
                this.markInvalid();
            }
        }

        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        private void markInvalid() {
            if (this.valid) {
                this.valid = false;
                this.fireValueChangedEvent();
            }
        }

        public T get() {
            this.valid = true;
            return this.value;
        }

        public Object getBean() {
            return Image.this;
        }

        public String getName() {
            return this.name;
        }
    }

    private final class DoublePropertyImpl
    extends ReadOnlyDoublePropertyBase {
        private final String name;
        private double value;

        public DoublePropertyImpl(String name) {
            this.name = name;
        }

        public void store(double value) {
            this.value = value;
        }

        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public double get() {
            return this.value;
        }

        public Object getBean() {
            return Image.this;
        }

        public String getName() {
            return this.name;
        }
    }
}

