/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import com.sun.scenario.effect.PhongLighting;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.EffectChangeListener;
import javafx.scene.effect.Light;
import javafx.scene.effect.Shadow;

public class Lighting
extends Effect {
    private final Light defaultLight = new Light.Distant();
    private ObjectProperty<Light> light = new ObjectPropertyBase<Light>((Light)new Light.Distant()){

        public void invalidated() {
            Lighting.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
            Lighting.this.effectBoundsChanged();
        }

        public Object getBean() {
            return Lighting.this;
        }

        public String getName() {
            return "light";
        }
    };
    private final LightChangeListener lightChangeListener = new LightChangeListener();
    private ObjectProperty<Effect> bumpInput;
    private ObjectProperty<Effect> contentInput;
    private DoubleProperty diffuseConstant;
    private DoubleProperty specularConstant;
    private DoubleProperty specularExponent;
    private DoubleProperty surfaceScale;

    @Override
    PhongLighting createPeer() {
        return new PhongLighting(this.getLightInternal().getPeer());
    }

    public Lighting() {
        Shadow shadow = new Shadow();
        shadow.setRadius(10.0);
        this.setBumpInput(shadow);
    }

    public Lighting(Light light) {
        Shadow shadow = new Shadow();
        shadow.setRadius(10.0);
        this.setBumpInput(shadow);
        this.setLight(light);
    }

    public final void setLight(Light value) {
        this.lightProperty().set((Object)value);
    }

    public final Light getLight() {
        return (Light)this.light.get();
    }

    public final ObjectProperty<Light> lightProperty() {
        return this.light;
    }

    @Override
    Effect copy() {
        Lighting lighting = new Lighting(this.getLight());
        lighting.setBumpInput(this.getBumpInput());
        lighting.setContentInput(this.getContentInput());
        lighting.setDiffuseConstant(this.getDiffuseConstant());
        lighting.setSpecularConstant(this.getSpecularConstant());
        lighting.setSpecularExponent(this.getSpecularExponent());
        lighting.setSurfaceScale(this.getSurfaceScale());
        return lighting;
    }

    public final void setBumpInput(Effect value) {
        this.bumpInputProperty().set((Object)value);
    }

    public final Effect getBumpInput() {
        return this.bumpInput == null ? null : (Effect)this.bumpInput.get();
    }

    public final ObjectProperty<Effect> bumpInputProperty() {
        if (this.bumpInput == null) {
            this.bumpInput = new Effect.EffectInputProperty("bumpInput");
        }
        return this.bumpInput;
    }

    public final void setContentInput(Effect value) {
        this.contentInputProperty().set((Object)value);
    }

    public final Effect getContentInput() {
        return this.contentInput == null ? null : (Effect)this.contentInput.get();
    }

    public final ObjectProperty<Effect> contentInputProperty() {
        if (this.contentInput == null) {
            this.contentInput = new Effect.EffectInputProperty("contentInput");
        }
        return this.contentInput;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localBumpInput = this.getBumpInput();
        Effect localContentInput = this.getContentInput();
        if (localContentInput == e || localBumpInput == e) {
            return true;
        }
        if (localContentInput != null && localContentInput.checkChainContains(e)) {
            return true;
        }
        return localBumpInput != null && localBumpInput.checkChainContains(e);
    }

    public final void setDiffuseConstant(double value) {
        this.diffuseConstantProperty().set(value);
    }

    public final double getDiffuseConstant() {
        return this.diffuseConstant == null ? 1.0 : this.diffuseConstant.get();
    }

    public final DoubleProperty diffuseConstantProperty() {
        if (this.diffuseConstant == null) {
            this.diffuseConstant = new DoublePropertyBase(1.0){

                public void invalidated() {
                    Lighting.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return Lighting.this;
                }

                public String getName() {
                    return "diffuseConstant";
                }
            };
        }
        return this.diffuseConstant;
    }

    public final void setSpecularConstant(double value) {
        this.specularConstantProperty().set(value);
    }

    public final double getSpecularConstant() {
        return this.specularConstant == null ? 0.3 : this.specularConstant.get();
    }

    public final DoubleProperty specularConstantProperty() {
        if (this.specularConstant == null) {
            this.specularConstant = new DoublePropertyBase(0.3){

                public void invalidated() {
                    Lighting.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return Lighting.this;
                }

                public String getName() {
                    return "specularConstant";
                }
            };
        }
        return this.specularConstant;
    }

    public final void setSpecularExponent(double value) {
        this.specularExponentProperty().set(value);
    }

    public final double getSpecularExponent() {
        return this.specularExponent == null ? 20.0 : this.specularExponent.get();
    }

    public final DoubleProperty specularExponentProperty() {
        if (this.specularExponent == null) {
            this.specularExponent = new DoublePropertyBase(20.0){

                public void invalidated() {
                    Lighting.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return Lighting.this;
                }

                public String getName() {
                    return "specularExponent";
                }
            };
        }
        return this.specularExponent;
    }

    public final void setSurfaceScale(double value) {
        this.surfaceScaleProperty().set(value);
    }

    public final double getSurfaceScale() {
        return this.surfaceScale == null ? 1.5 : this.surfaceScale.get();
    }

    public final DoubleProperty surfaceScaleProperty() {
        if (this.surfaceScale == null) {
            this.surfaceScale = new DoublePropertyBase(1.5){

                public void invalidated() {
                    Lighting.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return Lighting.this;
                }

                public String getName() {
                    return "surfaceScale";
                }
            };
        }
        return this.surfaceScale;
    }

    private Light getLightInternal() {
        Light localLight = this.getLight();
        return localLight == null ? this.defaultLight : localLight;
    }

    @Override
    void update() {
        Effect localContentInput;
        Effect localBumpInput = this.getBumpInput();
        if (localBumpInput != null) {
            localBumpInput.sync();
        }
        if ((localContentInput = this.getContentInput()) != null) {
            localContentInput.sync();
        }
        PhongLighting peer = (PhongLighting)this.getPeer();
        peer.setBumpInput(localBumpInput == null ? null : localBumpInput.getPeer());
        peer.setContentInput(localContentInput == null ? null : localContentInput.getPeer());
        peer.setDiffuseConstant((float)Utils.clamp(0.0, this.getDiffuseConstant(), 2.0));
        peer.setSpecularConstant((float)Utils.clamp(0.0, this.getSpecularConstant(), 2.0));
        peer.setSpecularExponent((float)Utils.clamp(0.0, this.getSpecularExponent(), 40.0));
        peer.setSurfaceScale((float)Utils.clamp(0.0, this.getSurfaceScale(), 10.0));
        this.lightChangeListener.register(this.getLight());
        this.getLightInternal().sync();
        peer.setLight(this.getLightInternal().getPeer());
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        return Lighting.getInputBounds(bounds, tx, node, boundsAccessor, this.getContentInput());
    }

    private class LightChangeListener
    extends EffectChangeListener {
        Light light;

        private LightChangeListener() {
        }

        public void register(Light value) {
            this.light = value;
            super.register((ObservableValue)(this.light == null ? null : this.light.effectDirtyProperty()));
        }

        public void invalidated(Observable valueModel) {
            if (this.light.isEffectDirty()) {
                Lighting.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                Lighting.this.effectBoundsChanged();
            }
        }
    }
}

