/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.util.Utils;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;

public class FloatMap {
    private com.sun.scenario.effect.FloatMap map;
    private float[] buf;
    private boolean mapBufferDirty = true;
    private BooleanProperty effectDirty;
    private IntegerProperty width;
    private IntegerProperty height;

    com.sun.scenario.effect.FloatMap getImpl() {
        return this.map;
    }

    private void updateBuffer() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            int w = Utils.clampMax(this.getWidth(), 4096);
            int h = Utils.clampMax(this.getHeight(), 4096);
            int size = w * h * 4;
            this.buf = new float[size];
            this.mapBufferDirty = true;
        }
    }

    private void update() {
        if (this.mapBufferDirty) {
            this.map = new com.sun.scenario.effect.FloatMap(Utils.clamp(1, this.getWidth(), 4096), Utils.clamp(1, this.getHeight(), 4096));
            this.mapBufferDirty = false;
        }
        this.map.put(this.buf);
    }

    void sync() {
        if (this.isEffectDirty()) {
            this.update();
            this.clearDirty();
        }
    }

    private void setEffectDirty(boolean value) {
        this.effectDirtyProperty().set(value);
    }

    final BooleanProperty effectDirtyProperty() {
        if (this.effectDirty == null) {
            this.effectDirty = new SimpleBooleanProperty((Object)this, "effectDirty");
        }
        return this.effectDirty;
    }

    boolean isEffectDirty() {
        return this.effectDirty == null ? false : this.effectDirty.get();
    }

    private void markDirty() {
        this.setEffectDirty(true);
    }

    private void clearDirty() {
        this.setEffectDirty(false);
    }

    public FloatMap() {
        this.updateBuffer();
        this.markDirty();
    }

    public FloatMap(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.updateBuffer();
        this.markDirty();
    }

    public final void setWidth(int value) {
        this.widthProperty().set(value);
    }

    public final int getWidth() {
        return this.width == null ? 1 : this.width.get();
    }

    public final IntegerProperty widthProperty() {
        if (this.width == null) {
            this.width = new IntegerPropertyBase(1){

                public void invalidated() {
                    FloatMap.this.updateBuffer();
                    FloatMap.this.markDirty();
                }

                public Object getBean() {
                    return FloatMap.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    public final void setHeight(int value) {
        this.heightProperty().set(value);
    }

    public final int getHeight() {
        return this.height == null ? 1 : this.height.get();
    }

    public final IntegerProperty heightProperty() {
        if (this.height == null) {
            this.height = new IntegerPropertyBase(1){

                public void invalidated() {
                    FloatMap.this.updateBuffer();
                    FloatMap.this.markDirty();
                }

                public Object getBean() {
                    return FloatMap.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    public void setSample(int x, int y, int band, float s) {
        this.buf[(x + y * this.getWidth()) * 4 + band] = s;
        this.markDirty();
    }

    public void setSamples(int x, int y, float s0) {
        int index = (x + y * this.getWidth()) * 4;
        this.buf[index + 0] = s0;
        this.markDirty();
    }

    public void setSamples(int x, int y, float s0, float s1) {
        int index = (x + y * this.getWidth()) * 4;
        this.buf[index + 0] = s0;
        this.buf[index + 1] = s1;
        this.markDirty();
    }

    public void setSamples(int x, int y, float s0, float s1, float s2) {
        int index = (x + y * this.getWidth()) * 4;
        this.buf[index + 0] = s0;
        this.buf[index + 1] = s1;
        this.buf[index + 2] = s2;
        this.markDirty();
    }

    public void setSamples(int x, int y, float s0, float s1, float s2, float s3) {
        int index = (x + y * this.getWidth()) * 4;
        this.buf[index + 0] = s0;
        this.buf[index + 1] = s1;
        this.buf[index + 2] = s2;
        this.buf[index + 3] = s3;
        this.markDirty();
    }

    FloatMap copy() {
        FloatMap dest = new FloatMap(this.getWidth(), this.getHeight());
        System.arraycopy(this.buf, 0, dest.buf, 0, this.buf.length);
        return dest;
    }
}

