/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.EffectChangeListener;
import javafx.scene.effect.FloatMap;

public class DisplacementMap
extends Effect {
    private ObjectProperty<Effect> input;
    private final FloatMap defaultMap = new FloatMap(1, 1);
    private ObjectProperty<FloatMap> mapData;
    private final MapDataChangeListener mapDataChangeListener = new MapDataChangeListener();
    private DoubleProperty scaleX;
    private DoubleProperty scaleY;
    private DoubleProperty offsetX;
    private DoubleProperty offsetY;
    private BooleanProperty wrap;

    @Override
    com.sun.scenario.effect.DisplacementMap createPeer() {
        return new com.sun.scenario.effect.DisplacementMap(new com.sun.scenario.effect.FloatMap(1, 1), com.sun.scenario.effect.Effect.DefaultInput);
    }

    public DisplacementMap() {
        this.setMapData(new FloatMap(1, 1));
    }

    public DisplacementMap(FloatMap mapData) {
        this.setMapData(mapData);
    }

    public DisplacementMap(FloatMap mapData, double offsetX, double offsetY, double scaleX, double scaleY) {
        this.setMapData(mapData);
        this.setOffsetX(offsetX);
        this.setOffsetY(offsetY);
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
    }

    public final void setInput(Effect value) {
        this.inputProperty().set((Object)value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.checkChainContains(e);
    }

    public final void setMapData(FloatMap value) {
        this.mapDataProperty().set((Object)value);
    }

    public final FloatMap getMapData() {
        return this.mapData == null ? null : (FloatMap)this.mapData.get();
    }

    public final ObjectProperty<FloatMap> mapDataProperty() {
        if (this.mapData == null) {
            this.mapData = new ObjectPropertyBase<FloatMap>(){

                public void invalidated() {
                    DisplacementMap.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    DisplacementMap.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return DisplacementMap.this;
                }

                public String getName() {
                    return "mapData";
                }
            };
        }
        return this.mapData;
    }

    public final void setScaleX(double value) {
        this.scaleXProperty().set(value);
    }

    public final double getScaleX() {
        return this.scaleX == null ? 1.0 : this.scaleX.get();
    }

    public final DoubleProperty scaleXProperty() {
        if (this.scaleX == null) {
            this.scaleX = new DoublePropertyBase(1.0){

                public void invalidated() {
                    DisplacementMap.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return DisplacementMap.this;
                }

                public String getName() {
                    return "scaleX";
                }
            };
        }
        return this.scaleX;
    }

    public final void setScaleY(double value) {
        this.scaleYProperty().set(value);
    }

    public final double getScaleY() {
        return this.scaleY == null ? 1.0 : this.scaleY.get();
    }

    public final DoubleProperty scaleYProperty() {
        if (this.scaleY == null) {
            this.scaleY = new DoublePropertyBase(1.0){

                public void invalidated() {
                    DisplacementMap.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return DisplacementMap.this;
                }

                public String getName() {
                    return "scaleY";
                }
            };
        }
        return this.scaleY;
    }

    public final void setOffsetX(double value) {
        this.offsetXProperty().set(value);
    }

    public final double getOffsetX() {
        return this.offsetX == null ? 0.0 : this.offsetX.get();
    }

    public final DoubleProperty offsetXProperty() {
        if (this.offsetX == null) {
            this.offsetX = new DoublePropertyBase(){

                public void invalidated() {
                    DisplacementMap.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return DisplacementMap.this;
                }

                public String getName() {
                    return "offsetX";
                }
            };
        }
        return this.offsetX;
    }

    public final void setOffsetY(double value) {
        this.offsetYProperty().set(value);
    }

    public final double getOffsetY() {
        return this.offsetY == null ? 0.0 : this.offsetY.get();
    }

    public final DoubleProperty offsetYProperty() {
        if (this.offsetY == null) {
            this.offsetY = new DoublePropertyBase(){

                public void invalidated() {
                    DisplacementMap.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return DisplacementMap.this;
                }

                public String getName() {
                    return "offsetY";
                }
            };
        }
        return this.offsetY;
    }

    public final void setWrap(boolean value) {
        this.wrapProperty().set(value);
    }

    public final boolean isWrap() {
        return this.wrap == null ? false : this.wrap.get();
    }

    public final BooleanProperty wrapProperty() {
        if (this.wrap == null) {
            this.wrap = new BooleanPropertyBase(){

                public void invalidated() {
                    DisplacementMap.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return DisplacementMap.this;
                }

                public String getName() {
                    return "wrap";
                }
            };
        }
        return this.wrap;
    }

    @Override
    void update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.sync();
        }
        com.sun.scenario.effect.DisplacementMap peer = (com.sun.scenario.effect.DisplacementMap)this.getPeer();
        peer.setContentInput(localInput == null ? null : localInput.getPeer());
        FloatMap localMapData = this.getMapData();
        this.mapDataChangeListener.register(localMapData);
        if (localMapData != null) {
            localMapData.sync();
            peer.setMapData(localMapData.getImpl());
        } else {
            this.defaultMap.sync();
            peer.setMapData(this.defaultMap.getImpl());
        }
        peer.setScaleX((float)this.getScaleX());
        peer.setScaleY((float)this.getScaleY());
        peer.setOffsetX((float)this.getOffsetX());
        peer.setOffsetY((float)this.getOffsetY());
        peer.setWrap(this.isWrap());
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        bounds = DisplacementMap.getInputBounds(bounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        return DisplacementMap.transformBounds(tx, bounds);
    }

    @Override
    Effect copy() {
        DisplacementMap dm = new DisplacementMap(this.getMapData().copy(), this.getOffsetX(), this.getOffsetY(), this.getScaleX(), this.getScaleY());
        dm.setInput(this.getInput());
        return dm;
    }

    private class MapDataChangeListener
    extends EffectChangeListener {
        FloatMap mapData;

        private MapDataChangeListener() {
        }

        public void register(FloatMap value) {
            this.mapData = value;
            super.register((ObservableValue)(this.mapData == null ? null : this.mapData.effectDirtyProperty()));
        }

        public void invalidated(Observable valueModel) {
            if (this.mapData.isEffectDirty()) {
                DisplacementMap.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                DisplacementMap.this.effectBoundsChanged();
            }
        }
    }
}

