/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.StyleClassSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.css.Match;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.StyleClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;

public final class SimpleSelector
extends Selector {
    private final String name;
    private final StyleClassSet styleClassSet;
    private final String id;
    private final PseudoClassState pseudoClassState;
    private final boolean matchOnName;
    private final boolean matchOnId;
    private final boolean matchOnStyleClass;
    private final NodeOrientation nodeOrientation;

    public String getName() {
        return this.name;
    }

    public List<String> getStyleClasses() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.styleClassSet.iterator();
        while (iter.hasNext()) {
            names.add(((StyleClass)iter.next()).getStyleClassName());
        }
        return Collections.unmodifiableList(names);
    }

    public Set<StyleClass> getStyleClassSet() {
        return this.styleClassSet;
    }

    public String getId() {
        return this.id;
    }

    Set<PseudoClass> getPseudoClassStates() {
        return this.pseudoClassState;
    }

    List<String> getPseudoclasses() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.pseudoClassState.iterator();
        while (iter.hasNext()) {
            names.add(((PseudoClass)iter.next()).getPseudoClassName());
        }
        if (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
            names.add("dir(rtl)");
        } else if (this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT) {
            names.add("dir(ltr)");
        }
        return Collections.unmodifiableList(names);
    }

    public NodeOrientation getNodeOrientation() {
        return this.nodeOrientation;
    }

    SimpleSelector(String name, List<String> styleClasses, List<String> pseudoClasses, String id) {
        this.name = name == null ? "*" : name;
        this.matchOnName = name != null && !"".equals(name) && !"*".equals(name);
        this.styleClassSet = new StyleClassSet();
        int nMax = styleClasses != null ? styleClasses.size() : 0;
        for (int n = 0; n < nMax; ++n) {
            String styleClassName = styleClasses.get(n);
            if (styleClassName == null || styleClassName.isEmpty()) continue;
            StyleClass styleClass = StyleClassSet.getStyleClass(styleClassName);
            this.styleClassSet.add(styleClass);
        }
        this.matchOnStyleClass = this.styleClassSet.size() > 0;
        this.pseudoClassState = new PseudoClassState();
        nMax = pseudoClasses != null ? pseudoClasses.size() : 0;
        NodeOrientation dir = NodeOrientation.INHERIT;
        for (int n = 0; n < nMax; ++n) {
            String pclass = pseudoClasses.get(n);
            if (pclass == null || pclass.isEmpty()) continue;
            if ("dir(".regionMatches(true, 0, pclass, 0, 4)) {
                boolean rtl = "dir(rtl)".equalsIgnoreCase(pclass);
                dir = rtl ? NodeOrientation.RIGHT_TO_LEFT : NodeOrientation.LEFT_TO_RIGHT;
                continue;
            }
            PseudoClass pseudoClass = PseudoClassState.getPseudoClass(pclass);
            this.pseudoClassState.add(pseudoClass);
        }
        this.nodeOrientation = dir;
        this.id = id == null ? "" : id;
        this.matchOnId = id != null && !"".equals(id);
    }

    @Override
    public Match createMatch() {
        int idCount = this.matchOnId ? 1 : 0;
        int styleClassCount = this.styleClassSet.size();
        return new Match(this, this.pseudoClassState, idCount, styleClassCount);
    }

    @Override
    public boolean applies(Styleable styleable) {
        String otherName;
        boolean classMatch;
        String otherId;
        boolean idMatch;
        Node node;
        NodeOrientation orientation;
        if (this.nodeOrientation != NodeOrientation.INHERIT && styleable instanceof Node && ((orientation = (node = (Node)styleable).getNodeOrientation()) == NodeOrientation.INHERIT ? node.getEffectiveNodeOrientation() != this.nodeOrientation : orientation != this.nodeOrientation)) {
            return false;
        }
        if (this.matchOnId && !(idMatch = this.id.equals(otherId = styleable.getId()))) {
            return false;
        }
        if (this.matchOnName && !(classMatch = this.name.equals(otherName = styleable.getTypeSelector()))) {
            return false;
        }
        if (this.matchOnStyleClass) {
            StyleClassSet otherStyleClassSet = new StyleClassSet();
            ObservableList<String> styleClasses = styleable.getStyleClass();
            int nMax = styleClasses.size();
            for (int n = 0; n < nMax; ++n) {
                String styleClassName = (String)styleClasses.get(n);
                if (styleClassName == null || styleClassName.isEmpty()) continue;
                StyleClass styleClass = StyleClassSet.getStyleClass(styleClassName);
                otherStyleClassSet.add(styleClass);
            }
            boolean styleClassMatch = this.matchStyleClasses(otherStyleClassSet);
            if (!styleClassMatch) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean applies(Styleable styleable, Set<PseudoClass>[] pseudoClasses, int depth) {
        boolean applies = this.applies(styleable);
        if (applies && pseudoClasses != null && depth < pseudoClasses.length) {
            if (pseudoClasses[depth] == null) {
                pseudoClasses[depth] = new PseudoClassState();
            }
            pseudoClasses[depth].addAll((Collection<PseudoClass>)((Object)this.pseudoClassState));
        }
        return applies;
    }

    @Override
    public boolean stateMatches(Styleable styleable, Set<PseudoClass> states) {
        return states != null ? states.containsAll((Collection<?>)((Object)this.pseudoClassState)) : false;
    }

    private boolean matchStyleClasses(StyleClassSet otherStyleClasses) {
        return otherStyleClasses.containsAll((Collection)((Object)this.styleClassSet));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleSelector other = (SimpleSelector)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (!this.styleClassSet.equals(other.styleClassSet)) {
            return false;
        }
        return this.pseudoClassState.equals(other.pseudoClassState);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * (hash + this.name.hashCode());
        hash = 31 * (hash + this.styleClassSet.hashCode());
        hash = 31 * (hash + this.styleClassSet.hashCode());
        hash = this.id != null ? 31 * (hash + this.id.hashCode()) : 0;
        hash = 31 * (hash + this.pseudoClassState.hashCode());
        return hash;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            sbuf.append(this.name);
        } else {
            sbuf.append("*");
        }
        Iterator iter1 = this.styleClassSet.iterator();
        while (iter1.hasNext()) {
            StyleClass styleClass = (StyleClass)iter1.next();
            sbuf.append('.').append(styleClass.getStyleClassName());
        }
        if (this.id != null && !this.id.isEmpty()) {
            sbuf.append('#');
            sbuf.append(this.id);
        }
        Iterator iter2 = this.pseudoClassState.iterator();
        while (iter2.hasNext()) {
            PseudoClass pseudoClass = (PseudoClass)iter2.next();
            sbuf.append(':').append(pseudoClass.getPseudoClassName());
        }
        return sbuf.toString();
    }

    @Override
    protected final void writeBinary(DataOutputStream os, StyleConverter.StringStore stringStore) throws IOException {
        super.writeBinary(os, stringStore);
        os.writeShort(stringStore.addString(this.name));
        os.writeShort(this.styleClassSet.size());
        Iterator iter1 = this.styleClassSet.iterator();
        while (iter1.hasNext()) {
            StyleClass sc = (StyleClass)iter1.next();
            os.writeShort(stringStore.addString(sc.getStyleClassName()));
        }
        os.writeShort(stringStore.addString(this.id));
        int pclassSize = this.pseudoClassState.size() + (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT || this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT ? 1 : 0);
        os.writeShort(pclassSize);
        Iterator iter2 = this.pseudoClassState.iterator();
        while (iter2.hasNext()) {
            PseudoClass pc = (PseudoClass)iter2.next();
            os.writeShort(stringStore.addString(pc.getPseudoClassName()));
        }
        if (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
            os.writeShort(stringStore.addString("dir(rtl)"));
        } else if (this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT) {
            os.writeShort(stringStore.addString("dir(ltr)"));
        }
    }

    static SimpleSelector readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        String name = strings[is.readShort()];
        int nStyleClasses = is.readShort();
        ArrayList<String> styleClasses = new ArrayList<String>();
        for (int n = 0; n < nStyleClasses; ++n) {
            styleClasses.add(strings[is.readShort()]);
        }
        String id = strings[is.readShort()];
        int nPseudoclasses = is.readShort();
        ArrayList<String> pseudoclasses = new ArrayList<String>();
        for (int n = 0; n < nPseudoclasses; ++n) {
            pseudoclasses.add(strings[is.readShort()]);
        }
        return new SimpleSelector(name, styleClasses, pseudoclasses, id);
    }
}

