/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.PseudoClassState;
import javafx.css.Selector;
import javafx.css.SimpleSelector;
import javafx.geometry.NodeOrientation;

public final class Match
implements Comparable<Match> {
    final Selector selector;
    final PseudoClassState pseudoClasses;
    final int idCount;
    final int styleClassCount;
    final int specificity;

    Match(Selector selector, PseudoClassState pseudoClasses, int idCount, int styleClassCount) {
        SimpleSelector simple;
        int nPseudoClasses;
        assert (selector != null);
        this.selector = selector;
        this.idCount = idCount;
        this.styleClassCount = styleClassCount;
        this.pseudoClasses = pseudoClasses;
        int n = nPseudoClasses = pseudoClasses != null ? pseudoClasses.size() : 0;
        if (selector instanceof SimpleSelector && (simple = (SimpleSelector)selector).getNodeOrientation() != NodeOrientation.INHERIT) {
            ++nPseudoClasses;
        }
        this.specificity = idCount << 8 | styleClassCount << 4 | nPseudoClasses;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public PseudoClassState getPseudoClasses() {
        return this.pseudoClasses;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    @Override
    public int compareTo(Match o) {
        return this.specificity - o.specificity;
    }
}

