/*
 * Decompiled with CFR 0.152.
 */
package javafx.concurrent;

import com.sun.javafx.event.EventHandlerManager;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;

class EventHelper {
    private final EventTarget target;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onReady;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onScheduled;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onRunning;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onSucceeded;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onCancelled;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onFailed;
    private EventHandlerManager internalEventDispatcher;

    final ObjectProperty<EventHandler<WorkerStateEvent>> onReadyProperty() {
        return this.onReady;
    }

    final EventHandler<WorkerStateEvent> getOnReady() {
        return (EventHandler)this.onReady.get();
    }

    final void setOnReady(EventHandler<WorkerStateEvent> value) {
        this.onReady.set(value);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onScheduledProperty() {
        return this.onScheduled;
    }

    final EventHandler<WorkerStateEvent> getOnScheduled() {
        return (EventHandler)this.onScheduled.get();
    }

    final void setOnScheduled(EventHandler<WorkerStateEvent> value) {
        this.onScheduled.set(value);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onRunningProperty() {
        return this.onRunning;
    }

    final EventHandler<WorkerStateEvent> getOnRunning() {
        return (EventHandler)this.onRunning.get();
    }

    final void setOnRunning(EventHandler<WorkerStateEvent> value) {
        this.onRunning.set(value);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onSucceededProperty() {
        return this.onSucceeded;
    }

    final EventHandler<WorkerStateEvent> getOnSucceeded() {
        return (EventHandler)this.onSucceeded.get();
    }

    final void setOnSucceeded(EventHandler<WorkerStateEvent> value) {
        this.onSucceeded.set(value);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onCancelledProperty() {
        return this.onCancelled;
    }

    final EventHandler<WorkerStateEvent> getOnCancelled() {
        return (EventHandler)this.onCancelled.get();
    }

    final void setOnCancelled(EventHandler<WorkerStateEvent> value) {
        this.onCancelled.set(value);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onFailedProperty() {
        return this.onFailed;
    }

    final EventHandler<WorkerStateEvent> getOnFailed() {
        return (EventHandler)this.onFailed.get();
    }

    final void setOnFailed(EventHandler<WorkerStateEvent> value) {
        this.onFailed.set(value);
    }

    EventHelper(EventTarget bean) {
        this.target = bean;
        this.onReady = new SimpleObjectProperty<EventHandler<WorkerStateEvent>>((Object)bean, "onReady"){

            protected void invalidated() {
                EventHandler handler = (EventHandler)this.get();
                EventHelper.this.setEventHandler(WorkerStateEvent.WORKER_STATE_READY, handler);
            }
        };
        this.onScheduled = new SimpleObjectProperty<EventHandler<WorkerStateEvent>>((Object)bean, "onScheduled"){

            protected void invalidated() {
                EventHandler handler = (EventHandler)this.get();
                EventHelper.this.setEventHandler(WorkerStateEvent.WORKER_STATE_SCHEDULED, handler);
            }
        };
        this.onRunning = new SimpleObjectProperty<EventHandler<WorkerStateEvent>>((Object)bean, "onRunning"){

            protected void invalidated() {
                EventHandler handler = (EventHandler)this.get();
                EventHelper.this.setEventHandler(WorkerStateEvent.WORKER_STATE_RUNNING, handler);
            }
        };
        this.onSucceeded = new SimpleObjectProperty<EventHandler<WorkerStateEvent>>((Object)bean, "onSucceeded"){

            protected void invalidated() {
                EventHandler handler = (EventHandler)this.get();
                EventHelper.this.setEventHandler(WorkerStateEvent.WORKER_STATE_SUCCEEDED, handler);
            }
        };
        this.onCancelled = new SimpleObjectProperty<EventHandler<WorkerStateEvent>>((Object)bean, "onCancelled"){

            protected void invalidated() {
                EventHandler handler = (EventHandler)this.get();
                EventHelper.this.setEventHandler(WorkerStateEvent.WORKER_STATE_CANCELLED, handler);
            }
        };
        this.onFailed = new SimpleObjectProperty<EventHandler<WorkerStateEvent>>((Object)bean, "onFailed"){

            protected void invalidated() {
                EventHandler handler = (EventHandler)this.get();
                EventHelper.this.setEventHandler(WorkerStateEvent.WORKER_STATE_FAILED, handler);
            }
        };
    }

    final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().addEventHandler(eventType, eventHandler);
    }

    final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().removeEventHandler(eventType, eventHandler);
    }

    final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().addEventFilter(eventType, eventFilter);
    }

    final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().removeEventFilter(eventType, eventFilter);
    }

    final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().setEventHandler(eventType, eventHandler);
    }

    private EventHandlerManager getInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = new EventHandlerManager((Object)this.target);
        }
        return this.internalEventDispatcher;
    }

    final void fireEvent(Event event) {
        Event.fireEvent((EventTarget)this.target, (Event)event);
    }

    EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return this.internalEventDispatcher == null ? tail : tail.append((EventDispatcher)this.getInternalEventDispatcher());
    }
}

