/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import javafx.animation.Transition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.util.Duration;

public final class TranslateTransition
extends Transition {
    private static final double EPSILON = 1.0E-12;
    private double startX;
    private double startY;
    private double startZ;
    private double deltaX;
    private double deltaY;
    private double deltaZ;
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private Node cachedNode;
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis((double)400.0);
    private DoubleProperty fromX;
    private static final double DEFAULT_FROM_X = Double.NaN;
    private DoubleProperty fromY;
    private static final double DEFAULT_FROM_Y = Double.NaN;
    private DoubleProperty fromZ;
    private static final double DEFAULT_FROM_Z = Double.NaN;
    private DoubleProperty toX;
    private static final double DEFAULT_TO_X = Double.NaN;
    private DoubleProperty toY;
    private static final double DEFAULT_TO_Y = Double.NaN;
    private DoubleProperty toZ;
    private static final double DEFAULT_TO_Z = Double.NaN;
    private DoubleProperty byX;
    private static final double DEFAULT_BY_X = 0.0;
    private DoubleProperty byY;
    private static final double DEFAULT_BY_Y = 0.0;
    private DoubleProperty byZ;
    private static final double DEFAULT_BY_Z = 0.0;

    public final void setNode(Node value) {
        if (this.node != null || value != null) {
            this.nodeProperty().set((Object)value);
        }
    }

    public final Node getNode() {
        return this.node == null ? DEFAULT_NODE : (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty((Object)this, "node", (Object)DEFAULT_NODE);
        }
        return this.node;
    }

    public final void setDuration(Duration value) {
        if (this.duration != null || !DEFAULT_DURATION.equals((Object)value)) {
            this.durationProperty().set((Object)value);
        }
    }

    public final Duration getDuration() {
        return this.duration == null ? DEFAULT_DURATION : (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new ObjectPropertyBase<Duration>(DEFAULT_DURATION){

                public void invalidated() {
                    try {
                        TranslateTransition.this.setCycleDuration(TranslateTransition.this.getDuration());
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(TranslateTransition.this.getCycleDuration());
                        throw e;
                    }
                }

                public Object getBean() {
                    return TranslateTransition.this;
                }

                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public final void setFromX(double value) {
        if (this.fromX != null || !Double.isNaN(value)) {
            this.fromXProperty().set(value);
        }
    }

    public final double getFromX() {
        return this.fromX == null ? Double.NaN : this.fromX.get();
    }

    public final DoubleProperty fromXProperty() {
        if (this.fromX == null) {
            this.fromX = new SimpleDoubleProperty((Object)this, "fromX", Double.NaN);
        }
        return this.fromX;
    }

    public final void setFromY(double value) {
        if (this.fromY != null || !Double.isNaN(value)) {
            this.fromYProperty().set(value);
        }
    }

    public final double getFromY() {
        return this.fromY == null ? Double.NaN : this.fromY.get();
    }

    public final DoubleProperty fromYProperty() {
        if (this.fromY == null) {
            this.fromY = new SimpleDoubleProperty((Object)this, "fromY", Double.NaN);
        }
        return this.fromY;
    }

    public final void setFromZ(double value) {
        if (this.fromZ != null || !Double.isNaN(value)) {
            this.fromZProperty().set(value);
        }
    }

    public final double getFromZ() {
        return this.fromZ == null ? Double.NaN : this.fromZ.get();
    }

    public final DoubleProperty fromZProperty() {
        if (this.fromZ == null) {
            this.fromZ = new SimpleDoubleProperty((Object)this, "fromZ", Double.NaN);
        }
        return this.fromZ;
    }

    public final void setToX(double value) {
        if (this.toX != null || !Double.isNaN(value)) {
            this.toXProperty().set(value);
        }
    }

    public final double getToX() {
        return this.toX == null ? Double.NaN : this.toX.get();
    }

    public final DoubleProperty toXProperty() {
        if (this.toX == null) {
            this.toX = new SimpleDoubleProperty((Object)this, "toX", Double.NaN);
        }
        return this.toX;
    }

    public final void setToY(double value) {
        if (this.toY != null || !Double.isNaN(value)) {
            this.toYProperty().set(value);
        }
    }

    public final double getToY() {
        return this.toY == null ? Double.NaN : this.toY.get();
    }

    public final DoubleProperty toYProperty() {
        if (this.toY == null) {
            this.toY = new SimpleDoubleProperty((Object)this, "toY", Double.NaN);
        }
        return this.toY;
    }

    public final void setToZ(double value) {
        if (this.toZ != null || !Double.isNaN(value)) {
            this.toZProperty().set(value);
        }
    }

    public final double getToZ() {
        return this.toZ == null ? Double.NaN : this.toZ.get();
    }

    public final DoubleProperty toZProperty() {
        if (this.toZ == null) {
            this.toZ = new SimpleDoubleProperty((Object)this, "toZ", Double.NaN);
        }
        return this.toZ;
    }

    public final void setByX(double value) {
        if (this.byX != null || Math.abs(value - 0.0) > 1.0E-12) {
            this.byXProperty().set(value);
        }
    }

    public final double getByX() {
        return this.byX == null ? 0.0 : this.byX.get();
    }

    public final DoubleProperty byXProperty() {
        if (this.byX == null) {
            this.byX = new SimpleDoubleProperty((Object)this, "byX", 0.0);
        }
        return this.byX;
    }

    public final void setByY(double value) {
        if (this.byY != null || Math.abs(value - 0.0) > 1.0E-12) {
            this.byYProperty().set(value);
        }
    }

    public final double getByY() {
        return this.byY == null ? 0.0 : this.byY.get();
    }

    public final DoubleProperty byYProperty() {
        if (this.byY == null) {
            this.byY = new SimpleDoubleProperty((Object)this, "byY", 0.0);
        }
        return this.byY;
    }

    public final void setByZ(double value) {
        if (this.byZ != null || Math.abs(value - 0.0) > 1.0E-12) {
            this.byZProperty().set(value);
        }
    }

    public final double getByZ() {
        return this.byZ == null ? 0.0 : this.byZ.get();
    }

    public final DoubleProperty byZProperty() {
        if (this.byZ == null) {
            this.byZ = new SimpleDoubleProperty((Object)this, "byZ", 0.0);
        }
        return this.byZ;
    }

    public TranslateTransition(Duration duration, Node node) {
        this.setDuration(duration);
        this.setNode(node);
        this.setCycleDuration(duration);
    }

    public TranslateTransition(Duration duration) {
        this(duration, null);
    }

    public TranslateTransition() {
        this(DEFAULT_DURATION, null);
    }

    @Override
    public void interpolate(double frac) {
        if (!Double.isNaN(this.startX)) {
            this.cachedNode.setTranslateX(this.startX + frac * this.deltaX);
        }
        if (!Double.isNaN(this.startY)) {
            this.cachedNode.setTranslateY(this.startY + frac * this.deltaY);
        }
        if (!Double.isNaN(this.startZ)) {
            this.cachedNode.setTranslateZ(this.startZ + frac * this.deltaZ);
        }
    }

    private Node getTargetNode() {
        Node node = this.getNode();
        return node != null ? node : this.getParentTargetNode();
    }

    @Override
    boolean startable(boolean forceSync) {
        return super.startable(forceSync) && (this.getTargetNode() != null || !forceSync && this.cachedNode != null);
    }

    @Override
    void sync(boolean forceSync) {
        super.sync(forceSync);
        if (forceSync || this.cachedNode == null) {
            this.cachedNode = this.getTargetNode();
            double _fromX = this.getFromX();
            double _fromY = this.getFromY();
            double _fromZ = this.getFromZ();
            double _toX = this.getToX();
            double _toY = this.getToY();
            double _toZ = this.getToZ();
            double _byX = this.getByX();
            double _byY = this.getByY();
            double _byZ = this.getByZ();
            if (Double.isNaN(_fromX) && Double.isNaN(_toX) && Math.abs(_byX) < 1.0E-12) {
                this.startX = Double.NaN;
            } else {
                this.startX = !Double.isNaN(_fromX) ? _fromX : this.cachedNode.getTranslateX();
                double d = this.deltaX = !Double.isNaN(_toX) ? _toX - this.startX : _byX;
            }
            if (Double.isNaN(_fromY) && Double.isNaN(_toY) && Math.abs(_byY) < 1.0E-12) {
                this.startY = Double.NaN;
            } else {
                this.startY = !Double.isNaN(_fromY) ? _fromY : this.cachedNode.getTranslateY();
                double d = this.deltaY = !Double.isNaN(_toY) ? _toY - this.startY : this.getByY();
            }
            if (Double.isNaN(_fromZ) && Double.isNaN(_toZ) && Math.abs(_byZ) < 1.0E-12) {
                this.startZ = Double.NaN;
            } else {
                this.startZ = !Double.isNaN(_fromZ) ? _fromZ : this.cachedNode.getTranslateZ();
                this.deltaZ = !Double.isNaN(_toZ) ? _toZ - this.startZ : this.getByZ();
            }
        }
    }
}

