/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import java.util.ArrayList;
import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public final class PathTransition
extends Transition {
    private ObjectProperty<Node> node;
    private double totalLength = 0.0;
    private final ArrayList<Segment> segments = new ArrayList();
    private static final Node DEFAULT_NODE = null;
    private static final int SMOOTH_ZONE = 10;
    private Node cachedNode;
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis((double)400.0);
    private ObjectProperty<Shape> path;
    private static final Shape DEFAULT_PATH = null;
    private ObjectProperty<OrientationType> orientation;
    private static final OrientationType DEFAULT_ORIENTATION = OrientationType.NONE;
    private boolean cachedIsNormalRequired;

    public final void setNode(Node value) {
        if (this.node != null || value != null) {
            this.nodeProperty().set((Object)value);
        }
    }

    public final Node getNode() {
        return this.node == null ? DEFAULT_NODE : (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty((Object)this, "node", (Object)DEFAULT_NODE);
        }
        return this.node;
    }

    public final void setDuration(Duration value) {
        if (this.duration != null || !DEFAULT_DURATION.equals((Object)value)) {
            this.durationProperty().set((Object)value);
        }
    }

    public final Duration getDuration() {
        return this.duration == null ? DEFAULT_DURATION : (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new ObjectPropertyBase<Duration>(DEFAULT_DURATION){

                public void invalidated() {
                    try {
                        PathTransition.this.setCycleDuration(PathTransition.this.getDuration());
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(PathTransition.this.getCycleDuration());
                        throw e;
                    }
                }

                public Object getBean() {
                    return PathTransition.this;
                }

                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public final void setPath(Shape value) {
        if (this.path != null || value != null) {
            this.pathProperty().set((Object)value);
        }
    }

    public final Shape getPath() {
        return this.path == null ? DEFAULT_PATH : (Shape)this.path.get();
    }

    public final ObjectProperty<Shape> pathProperty() {
        if (this.path == null) {
            this.path = new SimpleObjectProperty((Object)this, "path", (Object)DEFAULT_PATH);
        }
        return this.path;
    }

    public final void setOrientation(OrientationType value) {
        if (this.orientation != null || !DEFAULT_ORIENTATION.equals((Object)value)) {
            this.orientationProperty().set((Object)value);
        }
    }

    public final OrientationType getOrientation() {
        return this.orientation == null ? OrientationType.NONE : (OrientationType)((Object)this.orientation.get());
    }

    public final ObjectProperty<OrientationType> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new SimpleObjectProperty((Object)this, "orientation", (Object)DEFAULT_ORIENTATION);
        }
        return this.orientation;
    }

    public PathTransition(Duration duration, Shape path, Node node) {
        this.setDuration(duration);
        this.setPath(path);
        this.setNode(node);
        this.setCycleDuration(duration);
    }

    public PathTransition(Duration duration, Shape path) {
        this(duration, path, null);
    }

    public PathTransition() {
        this(DEFAULT_DURATION, null, null);
    }

    @Override
    public void interpolate(double frac) {
        double part = this.totalLength * Math.min(1.0, Math.max(0.0, frac));
        int segIdx = this.findSegment(0, this.segments.size() - 1, part);
        Segment seg = this.segments.get(segIdx);
        double lengthBefore = seg.accumLength - seg.length;
        double partLength = part - lengthBefore;
        double ratio = partLength / seg.length;
        Segment prevSeg = seg.prevSeg;
        double x = prevSeg.toX + (seg.toX - prevSeg.toX) * ratio;
        double y = prevSeg.toY + (seg.toY - prevSeg.toY) * ratio;
        double rotateAngle = seg.rotateAngle;
        double z = Math.min(10.0, seg.length / 2.0);
        if (partLength < z && !prevSeg.isMoveTo) {
            rotateAngle = PathTransition.interpolate(prevSeg.rotateAngle, seg.rotateAngle, partLength / z / 2.0 + 0.5);
        } else {
            double dist = seg.length - partLength;
            Segment nextSeg = seg.nextSeg;
            if (dist < z && nextSeg != null && !nextSeg.isMoveTo) {
                rotateAngle = PathTransition.interpolate(seg.rotateAngle, nextSeg.rotateAngle, (z - dist) / z / 2.0);
            }
        }
        this.cachedNode.setTranslateX(x - NodeHelper.getPivotX(this.cachedNode));
        this.cachedNode.setTranslateY(y - NodeHelper.getPivotY(this.cachedNode));
        if (this.cachedIsNormalRequired) {
            this.cachedNode.setRotate(rotateAngle);
        }
    }

    private Node getTargetNode() {
        Node node = this.getNode();
        return node != null ? node : this.getParentTargetNode();
    }

    @Override
    boolean startable(boolean forceSync) {
        return super.startable(forceSync) && (this.getTargetNode() != null && this.getPath() != null && !this.getPath().getLayoutBounds().isEmpty() || !forceSync && this.cachedNode != null);
    }

    @Override
    void sync(boolean forceSync) {
        super.sync(forceSync);
        if (forceSync || this.cachedNode == null) {
            this.cachedNode = this.getTargetNode();
            this.recomputeSegments();
            this.cachedIsNormalRequired = this.getOrientation() == OrientationType.ORTHOGONAL_TO_TANGENT;
        }
    }

    private void recomputeSegments() {
        this.segments.clear();
        Shape p = this.getPath();
        Segment moveToSeg = Segment.getZeroSegment();
        Segment lastSeg = Segment.getZeroSegment();
        float[] coords = new float[6];
        PathIterator i = ShapeHelper.configShape(p).getPathIterator(NodeHelper.getLeafTransform(p), 1.0f);
        while (!i.isDone()) {
            Segment newSeg = null;
            int segType = i.currentSegment(coords);
            double x = coords[0];
            double y = coords[1];
            switch (segType) {
                case 0: {
                    newSeg = moveToSeg = Segment.newMoveTo(x, y, lastSeg.accumLength);
                    break;
                }
                case 4: {
                    newSeg = Segment.newClosePath(lastSeg, moveToSeg);
                    if (newSeg != null) break;
                    lastSeg.convertToClosePath(moveToSeg);
                    break;
                }
                case 1: {
                    newSeg = Segment.newLineTo(lastSeg, x, y);
                }
            }
            if (newSeg != null) {
                this.segments.add(newSeg);
                lastSeg = newSeg;
            }
            i.next();
        }
        this.totalLength = lastSeg.accumLength;
    }

    private int findSegment(int begin, int end, double length) {
        if (begin == end) {
            return this.segments.get((int)begin).isMoveTo && begin > 0 ? this.findSegment(begin - 1, begin - 1, length) : begin;
        }
        int middle = begin + (end - begin) / 2;
        return this.segments.get((int)middle).accumLength > length ? this.findSegment(begin, middle, length) : this.findSegment(middle + 1, end, length);
    }

    private static double interpolate(double fromAngle, double toAngle, double ratio) {
        double delta = toAngle - fromAngle;
        if (Math.abs(delta) > 180.0) {
            toAngle += delta > 0.0 ? -360.0 : 360.0;
        }
        return PathTransition.normalize(fromAngle + ratio * (toAngle - fromAngle));
    }

    private static double normalize(double angle) {
        while (angle > 360.0) {
            angle -= 360.0;
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    private static class Segment {
        private static final Segment zeroSegment = new Segment(true, 0.0, 0.0, 0.0, 0.0, 0.0);
        boolean isMoveTo;
        double length;
        double accumLength;
        double toX;
        double toY;
        double rotateAngle;
        Segment prevSeg;
        Segment nextSeg;

        private Segment(boolean isMoveTo, double toX, double toY, double length, double lengthBefore, double rotateAngle) {
            this.isMoveTo = isMoveTo;
            this.toX = toX;
            this.toY = toY;
            this.length = length;
            this.accumLength = lengthBefore + length;
            this.rotateAngle = rotateAngle;
        }

        public static Segment getZeroSegment() {
            return zeroSegment;
        }

        public static Segment newMoveTo(double toX, double toY, double accumLength) {
            return new Segment(true, toX, toY, 0.0, accumLength, 0.0);
        }

        public static Segment newLineTo(Segment fromSeg, double toX, double toY) {
            double deltaX = toX - fromSeg.toX;
            double deltaY = toY - fromSeg.toY;
            double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            if (length >= 1.0 || fromSeg.isMoveTo) {
                Segment newSeg;
                double sign = Math.signum(deltaY == 0.0 ? deltaX : deltaY);
                double angle = sign * Math.acos(deltaX / length);
                angle = PathTransition.normalize(angle / Math.PI * 180.0);
                fromSeg.nextSeg = newSeg = new Segment(false, toX, toY, length, fromSeg.accumLength, angle);
                newSeg.prevSeg = fromSeg;
                return newSeg;
            }
            return null;
        }

        public static Segment newClosePath(Segment fromSeg, Segment moveToSeg) {
            Segment newSeg = Segment.newLineTo(fromSeg, moveToSeg.toX, moveToSeg.toY);
            if (newSeg != null) {
                newSeg.convertToClosePath(moveToSeg);
            }
            return newSeg;
        }

        public void convertToClosePath(Segment moveToSeg) {
            Segment firstLineToSeg;
            this.nextSeg = firstLineToSeg = moveToSeg.nextSeg;
            firstLineToSeg.prevSeg = this;
        }
    }

    public static enum OrientationType {
        NONE,
        ORTHOGONAL_TO_TANGENT;

    }
}

