/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.state.RenderState;

public class InvertMask
extends CoreEffect<RenderState> {
    private int pad;
    private int xoff;
    private int yoff;

    public InvertMask() {
        this(10);
    }

    public InvertMask(Effect input) {
        this(10, input);
    }

    public InvertMask(int pad) {
        this(pad, DefaultInput);
    }

    public InvertMask(int pad, Effect input) {
        super(input);
        this.setPad(pad);
        this.updatePeerKey("InvertMask");
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public int getPad() {
        return this.pad;
    }

    public void setPad(int pad) {
        if (pad < 0) {
            throw new IllegalArgumentException("Pad value must be non-negative");
        }
        int old = this.pad;
        this.pad = pad;
    }

    public int getOffsetX() {
        return this.xoff;
    }

    public void setOffsetX(int xoff) {
        int old = this.xoff;
        this.xoff = xoff;
    }

    public int getOffsetY() {
        return this.yoff;
    }

    public void setOffsetY(int yoff) {
        float old = this.yoff;
        this.yoff = yoff;
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        BaseBounds bounds = super.getBounds(BaseTransform.IDENTITY_TRANSFORM, defaultInput);
        BaseBounds ret = new RectBounds(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
        ret.grow(this.pad, this.pad);
        if (!transform.isIdentity()) {
            ret = InvertMask.transformBounds(transform, ret);
        }
        return ret;
    }

    @Override
    public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
        Rectangle r = super.getResultBounds(transform, outputClip, inputDatas);
        Rectangle ret = new Rectangle(r);
        ret.grow(this.pad, this.pad);
        return ret;
    }

    @Override
    public RenderState getRenderState(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        return new RenderState(){

            @Override
            public RenderState.EffectCoordinateSpace getEffectTransformSpace() {
                return RenderState.EffectCoordinateSpace.UserSpace;
            }

            @Override
            public BaseTransform getInputTransform(BaseTransform filterTransform) {
                return BaseTransform.IDENTITY_TRANSFORM;
            }

            @Override
            public BaseTransform getResultTransform(BaseTransform filterTransform) {
                return filterTransform;
            }

            @Override
            public Rectangle getInputClip(int i, Rectangle filterClip) {
                if (filterClip != null && InvertMask.this.pad != 0) {
                    filterClip = new Rectangle(filterClip);
                    filterClip.grow(InvertMask.this.pad, InvertMask.this.pad);
                }
                return filterClip;
            }
        };
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        Effect di = this.getDefaultedInput(0, defaultInput);
        DirtyRegionContainer drc = di.getDirtyRegions(defaultInput, regionPool);
        if (this.xoff != 0 || this.yoff != 0) {
            for (int i = 0; i < drc.size(); ++i) {
                drc.getDirtyRegion(i).translate(this.xoff, this.yoff, 0.0f);
            }
        }
        return drc;
    }
}

