/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.AnimationAccessor;
import com.sun.scenario.animation.shared.ClipEnvelope;
import javafx.animation.Animation;
import javafx.util.Duration;

public class SingleLoopClipEnvelope
extends ClipEnvelope {
    private int cycleCount;

    @Override
    public void setRate(double rate) {
        Animation.Status status = this.animation.getStatus();
        if (status != Animation.Status.STOPPED) {
            if (status == Animation.Status.RUNNING) {
                this.setCurrentRate(Math.abs(this.currentRate - this.rate) < 1.0E-12 ? rate : -rate);
            }
            this.deltaTicks = this.ticks - Math.round((double)(this.ticks - this.deltaTicks) * rate / this.rate);
            this.abortCurrentPulse();
        }
        this.rate = rate;
    }

    @Override
    public void setAutoReverse(boolean autoReverse) {
    }

    @Override
    protected double calculateCurrentRate() {
        return this.rate;
    }

    protected SingleLoopClipEnvelope(Animation animation) {
        super(animation);
        if (animation != null) {
            this.cycleCount = animation.getCycleCount();
        }
    }

    @Override
    public boolean wasSynched() {
        return super.wasSynched() && this.cycleCount != 0;
    }

    @Override
    public ClipEnvelope setCycleDuration(Duration cycleDuration) {
        if (this.cycleCount != 1 && !cycleDuration.isIndefinite()) {
            return SingleLoopClipEnvelope.create(this.animation);
        }
        this.updateCycleTicks(cycleDuration);
        return this;
    }

    @Override
    public ClipEnvelope setCycleCount(int cycleCount) {
        if (cycleCount != 1 && this.cycleTicks != Long.MAX_VALUE) {
            return SingleLoopClipEnvelope.create(this.animation);
        }
        this.cycleCount = cycleCount;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timePulse(long currentTick) {
        if (this.cycleTicks == 0L) {
            return;
        }
        this.aborted = false;
        this.inTimePulse = true;
        try {
            boolean reachedEnd;
            this.ticks = ClipEnvelope.checkBounds(this.deltaTicks + Math.round((double)currentTick * this.currentRate), this.cycleTicks);
            AnimationAccessor.getDefault().playTo(this.animation, this.ticks, this.cycleTicks);
            boolean bl = this.currentRate > 0.0 ? this.ticks == this.cycleTicks : (reachedEnd = this.ticks == 0L);
            if (reachedEnd && !this.aborted) {
                AnimationAccessor.getDefault().finished(this.animation);
            }
        }
        finally {
            this.inTimePulse = false;
        }
    }

    @Override
    public void jumpTo(long ticks) {
        if (this.cycleTicks == 0L) {
            return;
        }
        long newTicks = ClipEnvelope.checkBounds(ticks, this.cycleTicks);
        this.deltaTicks += newTicks - this.ticks;
        this.ticks = newTicks;
        AnimationAccessor.getDefault().jumpTo(this.animation, newTicks, this.cycleTicks, false);
        this.abortCurrentPulse();
    }
}

