/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.impl.QueuedPixelSource;
import com.sun.prism.sw.SWRTTexture;
import com.sun.prism.sw.SWResourceFactory;
import java.nio.IntBuffer;

final class SWPresentable
extends SWRTTexture
implements Presentable {
    private final PresentableState pState;
    private Pixels pixels;
    private QueuedPixelSource pixelSource = new QueuedPixelSource(false);

    public SWPresentable(PresentableState pState, SWResourceFactory factory) {
        super(factory, pState.getRenderWidth(), pState.getRenderHeight());
        this.pState = pState;
    }

    @Override
    public boolean lockResources(PresentableState pState) {
        return this.getPhysicalWidth() != pState.getRenderWidth() || this.getPhysicalHeight() != pState.getRenderHeight();
    }

    @Override
    public boolean prepare(Rectangle dirtyregion) {
        if (!this.pState.isViewClosed()) {
            int w = this.getPhysicalWidth();
            int h = this.getPhysicalHeight();
            this.pixels = this.pixelSource.getUnusedPixels(w, h, 1.0f, 1.0f);
            IntBuffer pixBuf = (IntBuffer)this.pixels.getPixels();
            IntBuffer buf = this.getSurface().getDataIntBuffer();
            assert (buf.hasArray());
            System.arraycopy(buf.array(), 0, pixBuf.array(), 0, w * h);
            return true;
        }
        return false;
    }

    @Override
    public boolean present() {
        this.pixelSource.enqueuePixels(this.pixels);
        this.pState.uploadPixels(this.pixelSource);
        return true;
    }

    @Override
    public float getPixelScaleFactorX() {
        return this.pState.getRenderScaleX();
    }

    @Override
    public float getPixelScaleFactorY() {
        return this.pState.getRenderScaleY();
    }

    @Override
    public int getContentWidth() {
        return this.pState.getOutputWidth();
    }

    @Override
    public int getContentHeight() {
        return this.pState.getOutputHeight();
    }

    @Override
    public boolean isMSAA() {
        return super.isMSAA();
    }
}

