/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d.print;

import com.sun.javafx.print.PrintHelper;
import com.sun.javafx.print.PrinterImpl;
import com.sun.javafx.print.Units;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javafx.geometry.Rectangle2D;
import javafx.print.Collation;
import javafx.print.JobSettings;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.PageRange;
import javafx.print.Paper;
import javafx.print.PaperSource;
import javafx.print.PrintColor;
import javafx.print.PrintQuality;
import javafx.print.PrintResolution;
import javafx.print.PrintSides;
import javafx.print.Printer;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

public class J2DPrinter
implements PrinterImpl {
    private PrintService service;
    private Printer fxPrinter;
    private int defaultCopies = 0;
    private int maxCopies = 0;
    private Collation defaultCollation;
    private Set<Collation> collateSet;
    private PrintColor defColor;
    private Set<PrintColor> colorSet;
    private PrintSides defSides;
    private Set<PrintSides> sidesSet;
    private PageOrientation defOrient;
    private Set<PageOrientation> orientSet;
    private PrintResolution defRes;
    private Set<PrintResolution> resSet;
    private PrintQuality defQuality;
    private Set<PrintQuality> qualitySet;
    private Paper defPaper;
    private Set<Paper> paperSet;
    private static Map<MediaTray, PaperSource> preDefinedTrayMap = null;
    private static Map<MediaSizeName, Paper> predefinedPaperMap = null;
    private PaperSource defPaperSource;
    private Set<PaperSource> paperSourceSet;
    private Map<PaperSource, MediaTray> sourceToTrayMap;
    private Map<MediaTray, PaperSource> trayToSourceMap;
    private final Map<MediaSizeName, Paper> mediaToPaperMap = new HashMap<MediaSizeName, Paper>();
    private final Map<Paper, MediaSizeName> paperToMediaMap = new HashMap<Paper, MediaSizeName>();
    private PageLayout defaultLayout;

    public J2DPrinter(PrintService s) {
        this.service = s;
    }

    public Printer getPrinter() {
        return this.fxPrinter;
    }

    @Override
    public void setPrinter(Printer printer) {
        this.fxPrinter = printer;
    }

    public PrintService getService() {
        return this.service;
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public JobSettings getDefaultJobSettings() {
        return PrintHelper.createJobSettings(this.fxPrinter);
    }

    @Override
    public int defaultCopies() {
        if (this.defaultCopies > 0) {
            return this.defaultCopies;
        }
        try {
            Copies copies = (Copies)this.service.getDefaultAttributeValue(Copies.class);
            this.defaultCopies = copies.getValue();
        }
        catch (Exception e) {
            this.defaultCopies = 1;
        }
        return this.defaultCopies;
    }

    @Override
    public int maxCopies() {
        int[][] members;
        if (this.maxCopies > 0) {
            return this.maxCopies;
        }
        SetOfIntegerSyntax copies = null;
        try {
            copies = (CopiesSupported)this.service.getSupportedAttributeValues(CopiesSupported.class, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (copies != null && (members = copies.getMembers()) != null && members.length > 0 && members[0].length > 0) {
            this.maxCopies = members[0][1];
        }
        if (this.maxCopies == 0) {
            this.maxCopies = 999;
        }
        return this.maxCopies;
    }

    @Override
    public PageRange defaultPageRange() {
        try {
            PageRanges ranges = (PageRanges)this.service.getDefaultAttributeValue(PageRanges.class);
            if (ranges == null) {
                return null;
            }
            int s = ranges.getMembers()[0][0];
            int e = ranges.getMembers()[0][1];
            if (s == 1 && e == Integer.MAX_VALUE) {
                return null;
            }
            return new PageRange(s, e);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean supportsPageRanges() {
        return true;
    }

    SheetCollate getDefaultSheetCollate() {
        SheetCollate collate = null;
        try {
            collate = (SheetCollate)this.service.getDefaultAttributeValue(SheetCollate.class);
        }
        catch (Exception e) {
            collate = SheetCollate.UNCOLLATED;
        }
        return collate;
    }

    @Override
    public Collation defaultCollation() {
        if (this.defaultCollation != null) {
            return this.defaultCollation;
        }
        SheetCollate collate = this.getDefaultSheetCollate();
        this.defaultCollation = collate == SheetCollate.COLLATED ? Collation.COLLATED : Collation.UNCOLLATED;
        return this.defaultCollation;
    }

    @Override
    public Set<Collation> supportedCollations() {
        if (this.collateSet == null) {
            TreeSet<Collation> cSet = new TreeSet<Collation>();
            SheetCollate[] sc = null;
            try {
                sc = (SheetCollate[])this.service.getSupportedAttributeValues(SheetCollate.class, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sc != null) {
                for (int i = 0; i < sc.length; ++i) {
                    if (sc[i] == SheetCollate.UNCOLLATED) {
                        cSet.add(Collation.UNCOLLATED);
                    }
                    if (sc[i] != SheetCollate.COLLATED) continue;
                    cSet.add(Collation.COLLATED);
                }
            }
            this.collateSet = Collections.unmodifiableSet(cSet);
        }
        return this.collateSet;
    }

    Chromaticity getDefaultChromaticity() {
        Chromaticity color = null;
        try {
            color = (Chromaticity)this.service.getDefaultAttributeValue(Chromaticity.class);
        }
        catch (Exception e) {
            color = Chromaticity.COLOR;
        }
        return color;
    }

    @Override
    public PrintColor defaultPrintColor() {
        if (this.defColor != null) {
            return this.defColor;
        }
        Chromaticity color = this.getDefaultChromaticity();
        this.defColor = color == Chromaticity.COLOR ? PrintColor.COLOR : PrintColor.MONOCHROME;
        return this.defColor;
    }

    @Override
    public Set<PrintColor> supportedPrintColor() {
        if (this.colorSet == null) {
            TreeSet<PrintColor> cSet = new TreeSet<PrintColor>();
            Chromaticity[] sc = null;
            try {
                sc = (Chromaticity[])this.service.getSupportedAttributeValues(Chromaticity.class, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sc != null) {
                for (int i = 0; i < sc.length; ++i) {
                    if (sc[i] == Chromaticity.COLOR) {
                        cSet.add(PrintColor.COLOR);
                    }
                    if (sc[i] != Chromaticity.MONOCHROME) continue;
                    cSet.add(PrintColor.MONOCHROME);
                }
            }
            this.colorSet = Collections.unmodifiableSet(cSet);
        }
        return this.colorSet;
    }

    @Override
    public PrintSides defaultSides() {
        if (this.defSides != null) {
            return this.defSides;
        }
        Sides sides = (Sides)this.service.getDefaultAttributeValue(Sides.class);
        this.defSides = sides == null || sides == Sides.ONE_SIDED ? PrintSides.ONE_SIDED : (sides == Sides.DUPLEX ? PrintSides.DUPLEX : PrintSides.TUMBLE);
        return this.defSides;
    }

    @Override
    public Set<PrintSides> supportedSides() {
        if (this.sidesSet == null) {
            TreeSet<PrintSides> sSet = new TreeSet<PrintSides>();
            Sides[] ss = null;
            try {
                ss = (Sides[])this.service.getSupportedAttributeValues(Sides.class, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ss != null) {
                for (int i = 0; i < ss.length; ++i) {
                    if (ss[i] == Sides.ONE_SIDED) {
                        sSet.add(PrintSides.ONE_SIDED);
                    }
                    if (ss[i] == Sides.DUPLEX) {
                        sSet.add(PrintSides.DUPLEX);
                    }
                    if (ss[i] != Sides.TUMBLE) continue;
                    sSet.add(PrintSides.TUMBLE);
                }
            }
            this.sidesSet = Collections.unmodifiableSet(sSet);
        }
        return this.sidesSet;
    }

    static int getOrientID(PageOrientation o) {
        if (o == PageOrientation.LANDSCAPE) {
            return 0;
        }
        if (o == PageOrientation.REVERSE_LANDSCAPE) {
            return 2;
        }
        return 1;
    }

    static OrientationRequested mapOrientation(PageOrientation o) {
        if (o == PageOrientation.REVERSE_PORTRAIT) {
            return OrientationRequested.REVERSE_PORTRAIT;
        }
        if (o == PageOrientation.LANDSCAPE) {
            return OrientationRequested.LANDSCAPE;
        }
        if (o == PageOrientation.REVERSE_LANDSCAPE) {
            return OrientationRequested.REVERSE_LANDSCAPE;
        }
        return OrientationRequested.PORTRAIT;
    }

    static PageOrientation reverseMapOrientation(OrientationRequested o) {
        if (o == OrientationRequested.REVERSE_PORTRAIT) {
            return PageOrientation.REVERSE_PORTRAIT;
        }
        if (o == OrientationRequested.LANDSCAPE) {
            return PageOrientation.LANDSCAPE;
        }
        if (o == OrientationRequested.REVERSE_LANDSCAPE) {
            return PageOrientation.REVERSE_LANDSCAPE;
        }
        return PageOrientation.PORTRAIT;
    }

    @Override
    public PageOrientation defaultOrientation() {
        if (this.defOrient == null) {
            OrientationRequested orient = (OrientationRequested)this.service.getDefaultAttributeValue(OrientationRequested.class);
            this.defOrient = J2DPrinter.reverseMapOrientation(orient);
        }
        return this.defOrient;
    }

    @Override
    public Set<PageOrientation> supportedOrientation() {
        if (this.orientSet != null) {
            return this.orientSet;
        }
        TreeSet<PageOrientation> oset = new TreeSet<PageOrientation>();
        OrientationRequested[] or = null;
        try {
            or = (OrientationRequested[])this.service.getSupportedAttributeValues(OrientationRequested.class, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (or == null || or.length == 0) {
            oset.add(this.defaultOrientation());
        } else {
            for (int i = 0; i < or.length; ++i) {
                if (or[i] == OrientationRequested.PORTRAIT) {
                    oset.add(PageOrientation.PORTRAIT);
                    continue;
                }
                if (or[i] == OrientationRequested.REVERSE_PORTRAIT) {
                    oset.add(PageOrientation.REVERSE_PORTRAIT);
                    continue;
                }
                if (or[i] == OrientationRequested.LANDSCAPE) {
                    oset.add(PageOrientation.LANDSCAPE);
                    continue;
                }
                oset.add(PageOrientation.REVERSE_LANDSCAPE);
            }
        }
        this.orientSet = Collections.unmodifiableSet(oset);
        return this.orientSet;
    }

    PrinterResolution getDefaultPrinterResolution() {
        PrinterResolution res = (PrinterResolution)this.service.getDefaultAttributeValue(PrinterResolution.class);
        if (res == null) {
            res = new PrinterResolution(300, 300, 100);
        }
        return res;
    }

    @Override
    public PrintResolution defaultPrintResolution() {
        if (this.defRes != null) {
            return this.defRes;
        }
        PrinterResolution res = this.getDefaultPrinterResolution();
        int cfr = res.getCrossFeedResolution(100);
        int fr = res.getFeedResolution(100);
        this.defRes = PrintHelper.createPrintResolution(cfr, fr);
        return this.defRes;
    }

    @Override
    public Set<PrintResolution> supportedPrintResolution() {
        if (this.resSet != null) {
            return this.resSet;
        }
        TreeSet<PrintResolution> rSet = new TreeSet<PrintResolution>(PrintResolutionComparator.theComparator);
        PrinterResolution[] pr = null;
        try {
            pr = (PrinterResolution[])this.service.getSupportedAttributeValues(PrinterResolution.class, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pr == null || pr.length == 0) {
            rSet.add(this.defaultPrintResolution());
        } else {
            for (int i = 0; i < pr.length; ++i) {
                int cfr = pr[i].getCrossFeedResolution(100);
                int fr = pr[i].getFeedResolution(100);
                rSet.add(PrintHelper.createPrintResolution(cfr, fr));
            }
        }
        this.resSet = Collections.unmodifiableSet(rSet);
        return this.resSet;
    }

    javax.print.attribute.standard.PrintQuality getDefaultPrintQuality() {
        javax.print.attribute.standard.PrintQuality quality = null;
        try {
            quality = (javax.print.attribute.standard.PrintQuality)this.service.getDefaultAttributeValue(javax.print.attribute.standard.PrintQuality.class);
        }
        catch (Exception e) {
            quality = javax.print.attribute.standard.PrintQuality.NORMAL;
        }
        return quality;
    }

    @Override
    public PrintQuality defaultPrintQuality() {
        if (this.defQuality != null) {
            return this.defQuality;
        }
        javax.print.attribute.standard.PrintQuality quality = this.getDefaultPrintQuality();
        this.defQuality = quality == javax.print.attribute.standard.PrintQuality.DRAFT ? PrintQuality.DRAFT : (quality == javax.print.attribute.standard.PrintQuality.HIGH ? PrintQuality.HIGH : PrintQuality.NORMAL);
        return this.defQuality;
    }

    @Override
    public Set<PrintQuality> supportedPrintQuality() {
        if (this.qualitySet == null) {
            TreeSet<PrintQuality> set = new TreeSet<PrintQuality>();
            javax.print.attribute.standard.PrintQuality[] arr = null;
            try {
                arr = (javax.print.attribute.standard.PrintQuality[])this.service.getSupportedAttributeValues(javax.print.attribute.standard.PrintQuality.class, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (arr == null || arr.length == 0) {
                set.add(PrintQuality.NORMAL);
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    if (arr[i] == javax.print.attribute.standard.PrintQuality.NORMAL) {
                        set.add(PrintQuality.NORMAL);
                    }
                    if (arr[i] == javax.print.attribute.standard.PrintQuality.DRAFT) {
                        set.add(PrintQuality.DRAFT);
                    }
                    if (arr[i] != javax.print.attribute.standard.PrintQuality.HIGH) continue;
                    set.add(PrintQuality.HIGH);
                }
            }
            this.qualitySet = Collections.unmodifiableSet(set);
        }
        return this.qualitySet;
    }

    Paper getPaperForMedia(Media media) {
        this.populateMedia();
        if (media == null || !(media instanceof MediaSizeName)) {
            return this.defaultPaper();
        }
        return this.getPaper((MediaSizeName)media);
    }

    @Override
    public Paper defaultPaper() {
        if (this.defPaper != null) {
            return this.defPaper;
        }
        Media m = (Media)this.service.getDefaultAttributeValue(Media.class);
        this.defPaper = m == null || !(m instanceof MediaSizeName) ? Paper.NA_LETTER : this.getPaper((MediaSizeName)m);
        return this.defPaper;
    }

    @Override
    public Set<Paper> supportedPapers() {
        if (this.paperSet == null) {
            this.populateMedia();
        }
        return this.paperSet;
    }

    private static void initPrefinedMediaMaps() {
        HashMap<MediaTray, PaperSource> map;
        if (predefinedPaperMap == null) {
            map = new HashMap<MediaTray, PaperSource>();
            map.put((MediaTray)((Object)MediaSizeName.NA_LETTER), (PaperSource)((Object)Paper.NA_LETTER));
            map.put((MediaTray)((Object)MediaSizeName.TABLOID), (PaperSource)((Object)Paper.TABLOID));
            map.put((MediaTray)((Object)MediaSizeName.NA_LEGAL), (PaperSource)((Object)Paper.LEGAL));
            map.put((MediaTray)((Object)MediaSizeName.EXECUTIVE), (PaperSource)((Object)Paper.EXECUTIVE));
            map.put((MediaTray)((Object)MediaSizeName.NA_8X10), (PaperSource)((Object)Paper.NA_8X10));
            map.put((MediaTray)((Object)MediaSizeName.MONARCH_ENVELOPE), (PaperSource)((Object)Paper.MONARCH_ENVELOPE));
            map.put((MediaTray)((Object)MediaSizeName.NA_NUMBER_10_ENVELOPE), (PaperSource)((Object)Paper.NA_NUMBER_10_ENVELOPE));
            map.put((MediaTray)((Object)MediaSizeName.ISO_A0), (PaperSource)((Object)Paper.A0));
            map.put((MediaTray)((Object)MediaSizeName.ISO_A1), (PaperSource)((Object)Paper.A1));
            map.put((MediaTray)((Object)MediaSizeName.ISO_A2), (PaperSource)((Object)Paper.A2));
            map.put((MediaTray)((Object)MediaSizeName.ISO_A3), (PaperSource)((Object)Paper.A3));
            map.put((MediaTray)((Object)MediaSizeName.ISO_A4), (PaperSource)((Object)Paper.A4));
            map.put((MediaTray)((Object)MediaSizeName.ISO_A5), (PaperSource)((Object)Paper.A5));
            map.put((MediaTray)((Object)MediaSizeName.ISO_A6), (PaperSource)((Object)Paper.A6));
            map.put((MediaTray)((Object)MediaSizeName.C), (PaperSource)((Object)Paper.C));
            map.put((MediaTray)((Object)MediaSizeName.ISO_DESIGNATED_LONG), (PaperSource)((Object)Paper.DESIGNATED_LONG));
            map.put((MediaTray)((Object)MediaSizeName.JIS_B4), (PaperSource)((Object)Paper.JIS_B4));
            map.put((MediaTray)((Object)MediaSizeName.JIS_B5), (PaperSource)((Object)Paper.JIS_B5));
            map.put((MediaTray)((Object)MediaSizeName.JIS_B6), (PaperSource)((Object)Paper.JIS_B6));
            map.put((MediaTray)((Object)MediaSizeName.JAPANESE_POSTCARD), (PaperSource)((Object)Paper.JAPANESE_POSTCARD));
            predefinedPaperMap = map;
        }
        if (preDefinedTrayMap == null) {
            map = new HashMap();
            map.put(MediaTray.MAIN, PaperSource.MAIN);
            map.put(MediaTray.MANUAL, PaperSource.MANUAL);
            map.put(MediaTray.BOTTOM, PaperSource.BOTTOM);
            map.put(MediaTray.MIDDLE, PaperSource.MIDDLE);
            map.put(MediaTray.TOP, PaperSource.TOP);
            map.put(MediaTray.SIDE, PaperSource.SIDE);
            map.put(MediaTray.ENVELOPE, PaperSource.ENVELOPE);
            map.put(MediaTray.LARGE_CAPACITY, PaperSource.LARGE_CAPACITY);
            preDefinedTrayMap = map;
        }
    }

    private void populateMedia() {
        J2DPrinter.initPrefinedMediaMaps();
        if (this.paperSet != null) {
            return;
        }
        Media[] media = (Media[])this.service.getSupportedAttributeValues(Media.class, null, null);
        TreeSet<Paper> pSet = new TreeSet<Paper>(PaperComparator.theComparator);
        TreeSet<PaperSource> tSet = new TreeSet<PaperSource>(PaperSourceComparator.theComparator);
        if (media != null) {
            for (int i = 0; i < media.length; ++i) {
                Media m = media[i];
                if (m instanceof MediaSizeName) {
                    pSet.add(this.addPaper((MediaSizeName)m));
                    continue;
                }
                if (!(m instanceof MediaTray)) continue;
                tSet.add(this.addPaperSource((MediaTray)m));
            }
        }
        this.paperSet = Collections.unmodifiableSet(pSet);
        this.paperSourceSet = Collections.unmodifiableSet(tSet);
    }

    @Override
    public PaperSource defaultPaperSource() {
        if (this.defPaperSource != null) {
            return this.defPaperSource;
        }
        this.defPaperSource = PaperSource.AUTOMATIC;
        return this.defPaperSource;
    }

    @Override
    public Set<PaperSource> supportedPaperSources() {
        if (this.paperSourceSet == null) {
            this.populateMedia();
        }
        return this.paperSourceSet;
    }

    final synchronized PaperSource getPaperSource(MediaTray tray) {
        PaperSource source;
        if (this.paperSourceSet == null) {
            this.populateMedia();
        }
        if ((source = this.trayToSourceMap.get(tray)) != null) {
            return source;
        }
        return this.addPaperSource(tray);
    }

    MediaTray getTrayForPaperSource(PaperSource source) {
        if (this.paperSourceSet == null) {
            this.populateMedia();
        }
        return this.sourceToTrayMap.get(source);
    }

    private final synchronized PaperSource addPaperSource(MediaTray tray) {
        PaperSource source = preDefinedTrayMap.get(tray);
        if (source == null) {
            source = PrintHelper.createPaperSource(tray.toString());
        }
        if (this.trayToSourceMap == null) {
            this.trayToSourceMap = new HashMap<MediaTray, PaperSource>();
        }
        this.trayToSourceMap.put(tray, source);
        if (this.sourceToTrayMap == null) {
            this.sourceToTrayMap = new HashMap<PaperSource, MediaTray>();
        }
        this.sourceToTrayMap.put(source, tray);
        return source;
    }

    private final synchronized Paper addPaper(MediaSizeName media) {
        MediaSize sz;
        Paper paper = predefinedPaperMap.get(media);
        if (paper == null && (sz = MediaSize.getMediaSizeForName(media)) != null) {
            double pw = (double)sz.getX(1) / 1000.0;
            double ph = (double)sz.getY(1) / 1000.0;
            paper = PrintHelper.createPaper(media.toString(), pw, ph, Units.MM);
        }
        if (paper == null) {
            paper = Paper.NA_LETTER;
        }
        this.paperToMediaMap.put(paper, media);
        this.mediaToPaperMap.put(media, paper);
        return paper;
    }

    private Paper getPaper(MediaSizeName m) {
        this.populateMedia();
        Paper paper = this.mediaToPaperMap.get(m);
        if (paper == null) {
            paper = Paper.NA_LETTER;
        }
        return paper;
    }

    private MediaSizeName getMediaSizeName(Paper paper) {
        this.populateMedia();
        MediaSizeName m = this.paperToMediaMap.get(paper);
        if (m == null) {
            m = MediaSize.findMedia((float)paper.getWidth(), (float)paper.getHeight(), 352);
        }
        return m;
    }

    @Override
    public Rectangle2D printableArea(Paper paper) {
        Rectangle2D area = null;
        MediaSizeName msn = this.getMediaSizeName(paper);
        if (msn != null) {
            HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
            pras.add(msn);
            MediaPrintableArea[] mpa = (MediaPrintableArea[])this.service.getSupportedAttributeValues(MediaPrintableArea.class, null, pras);
            if (mpa != null && mpa.length > 0 && mpa[0] != null) {
                int MPA_INCH = 25400;
                area = new Rectangle2D(mpa[0].getX(MPA_INCH), mpa[0].getY(MPA_INCH), mpa[0].getWidth(MPA_INCH), mpa[0].getHeight(MPA_INCH));
            }
        }
        if (area == null) {
            double pw = paper.getWidth() / 72.0;
            double ph = paper.getHeight() / 72.0;
            double iw = pw < 3.0 ? 0.75 * pw : pw - 1.5;
            double ih = ph < 3.0 ? 0.75 * ph : ph - 1.5;
            double lm = (pw - iw) / 2.0;
            double tm = (ph - ih) / 2.0;
            area = new Rectangle2D(lm, tm, iw, ih);
        }
        return area;
    }

    PageLayout defaultPageLayout() {
        if (this.defaultLayout == null) {
            Paper paper = this.defaultPaper();
            PageOrientation orient = this.defaultOrientation();
            this.defaultLayout = this.fxPrinter.createPageLayout(paper, orient, Printer.MarginType.DEFAULT);
        }
        return this.defaultLayout;
    }

    private static class PaperSourceComparator
    implements Comparator<PaperSource> {
        static final PaperSourceComparator theComparator = new PaperSourceComparator();

        private PaperSourceComparator() {
        }

        @Override
        public int compare(PaperSource p1, PaperSource p2) {
            return p1.getName().compareTo(p2.getName());
        }
    }

    private static class PaperComparator
    implements Comparator<Paper> {
        static final PaperComparator theComparator = new PaperComparator();

        private PaperComparator() {
        }

        @Override
        public int compare(Paper p1, Paper p2) {
            return p1.getName().compareTo(p2.getName());
        }
    }

    private static class PrintResolutionComparator
    implements Comparator<PrintResolution> {
        static final PrintResolutionComparator theComparator = new PrintResolutionComparator();

        private PrintResolutionComparator() {
        }

        @Override
        public int compare(PrintResolution r1, PrintResolution r2) {
            long r2Res;
            long r1Res = r1.getCrossFeedResolution() * r1.getFeedResolution();
            if (r1Res == (r2Res = (long)(r2.getCrossFeedResolution() * r2.getFeedResolution()))) {
                return 0;
            }
            if (r1Res < r2Res) {
                return -1;
            }
            return 1;
        }
    }
}

