/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathConsumer2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.openpisces.Dasher;
import com.sun.openpisces.Stroker;
import com.sun.prism.BasicStroke;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.DMarlinRasterizer;
import com.sun.prism.impl.shape.MarlinRasterizer;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.NativePiscesRasterizer;
import com.sun.prism.impl.shape.OpenPiscesPrismUtils;
import com.sun.prism.impl.shape.OpenPiscesRasterizer;
import com.sun.prism.impl.shape.ShapeRasterizer;

public class ShapeUtil {
    private static final ShapeRasterizer shapeRasterizer;

    public static MaskData rasterizeShape(Shape shape, BasicStroke stroke, RectBounds xformBounds, BaseTransform xform, boolean close, boolean antialiasedShape) {
        return shapeRasterizer.getMaskData(shape, stroke, xformBounds, xform, close, antialiasedShape);
    }

    public static Shape createCenteredStrokedShape(Shape s, BasicStroke stroke) {
        if (PrismSettings.rasterizerSpec == PrismSettings.RasterizerType.DoubleMarlin) {
            return DMarlinRasterizer.createCenteredStrokedShape(s, stroke);
        }
        if (PrismSettings.rasterizerSpec == PrismSettings.RasterizerType.FloatMarlin) {
            return MarlinRasterizer.createCenteredStrokedShape(s, stroke);
        }
        return ShapeUtil.createCenteredStrokedShapeOpenPisces(s, stroke);
    }

    private static Shape createCenteredStrokedShapeOpenPisces(Shape s, BasicStroke stroke) {
        float lw = stroke.getType() == 0 ? stroke.getLineWidth() : stroke.getLineWidth() * 2.0f;
        Path2D p2d = new Path2D(1);
        PathConsumer2D pc2d = new Stroker(p2d, lw, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit());
        if (stroke.isDashed()) {
            pc2d = new Dasher(pc2d, stroke.getDashArray(), stroke.getDashPhase());
        }
        OpenPiscesPrismUtils.feedConsumer(s.getPathIterator(null), pc2d);
        return p2d;
    }

    private ShapeUtil() {
    }

    static {
        switch (PrismSettings.rasterizerSpec) {
            case JavaPisces: {
                shapeRasterizer = new OpenPiscesRasterizer();
                break;
            }
            case NativePisces: {
                shapeRasterizer = new NativePiscesRasterizer();
                break;
            }
            case FloatMarlin: {
                shapeRasterizer = new MarlinRasterizer();
                break;
            }
            default: {
                shapeRasterizer = new DMarlinRasterizer();
            }
        }
    }
}

