/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.prism.CompositeMode;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.impl.ps.PaintHelper;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;

public abstract class BaseShaderContext
extends BaseContext {
    private static final int CHECK_SHADER = 1;
    private static final int CHECK_TRANSFORM = 2;
    private static final int CHECK_CLIP = 4;
    private static final int CHECK_COMPOSITE = 8;
    private static final int CHECK_PAINT_OP_MASK = 15;
    private static final int CHECK_TEXTURE_OP_MASK = 15;
    private static final int CHECK_CLEAR_OP_MASK = 4;
    private static final int NUM_STOCK_SHADER_SLOTS = MaskType.values().length << 4;
    private final Shader[] stockShaders = new Shader[NUM_STOCK_SHADER_SLOTS];
    private final Shader[] stockATShaders = new Shader[NUM_STOCK_SHADER_SLOTS];
    private final Shader[] specialShaders = new Shader[SpecialShaderType.values().length];
    private final Shader[] specialATShaders = new Shader[SpecialShaderType.values().length];
    private Shader externalShader;
    private RTTexture lcdBuffer;
    private final ShaderFactory factory;
    private State state;

    protected BaseShaderContext(Screen screen, ShaderFactory factory, int vbQuads) {
        super(screen, factory, vbQuads);
        this.factory = factory;
        this.init();
    }

    protected void init() {
        this.state = null;
        if (this.externalShader != null && !this.externalShader.isValid()) {
            this.externalShader.dispose();
            this.externalShader = null;
        }
    }

    @Override
    protected void setPerspectiveTransform(GeneralTransform3D transform) {
        this.state.isXformValid = false;
        super.setPerspectiveTransform(transform);
    }

    protected void resetLastClip(State state) {
        state.lastClip = null;
    }

    protected abstract State updateRenderTarget(RenderTarget var1, NGCamera var2, boolean var3);

    protected abstract void updateTexture(int var1, Texture var2);

    protected abstract void updateShaderTransform(Shader var1, BaseTransform var2);

    protected abstract void updateWorldTransform(BaseTransform var1);

    protected abstract void updateClipRect(Rectangle var1);

    protected abstract void updateCompositeMode(CompositeMode var1);

    private static int getStockShaderIndex(MaskType maskType, Paint paint) {
        int paintOption;
        int paintType;
        if (paint == null) {
            paintType = 0;
            paintOption = 0;
        } else {
            paintType = paint.getType().ordinal();
            paintOption = paint.getType().isGradient() ? ((Gradient)paint).getSpreadMethod() : 0;
        }
        return maskType.ordinal() << 4 | paintType << 2 | paintOption << 0;
    }

    private Shader getPaintShader(boolean alphaTest, MaskType maskType, Paint paint) {
        int index;
        Shader[] shaders = alphaTest ? this.stockATShaders : this.stockShaders;
        Shader shader = shaders[index = BaseShaderContext.getStockShaderIndex(maskType, paint)];
        if (shader != null && !shader.isValid()) {
            shader.dispose();
            shader = null;
        }
        if (shader == null) {
            String shaderName = maskType.getName() + "_" + paint.getType().getName();
            if (paint.getType().isGradient() && !maskType.isNewPaintStyle()) {
                Gradient grad = (Gradient)paint;
                int spreadMethod = grad.getSpreadMethod();
                if (spreadMethod == 0) {
                    shaderName = shaderName + "_PAD";
                } else if (spreadMethod == 1) {
                    shaderName = shaderName + "_REFLECT";
                } else if (spreadMethod == 2) {
                    shaderName = shaderName + "_REPEAT";
                }
            }
            if (alphaTest) {
                shaderName = shaderName + "_AlphaTest";
            }
            shader = shaders[index] = this.factory.createStockShader(shaderName);
        }
        return shader;
    }

    private void updatePaintShader(BaseShaderGraphics g, Shader shader, MaskType maskType, Paint paint, float bx, float by, float bw, float bh) {
        float rh;
        float rw;
        float ry;
        float rx;
        Paint.Type paintType = paint.getType();
        if (paintType == Paint.Type.COLOR || maskType.isNewPaintStyle()) {
            return;
        }
        if (paint.isProportional()) {
            rx = bx;
            ry = by;
            rw = bw;
            rh = bh;
        } else {
            rx = 0.0f;
            ry = 0.0f;
            rw = 1.0f;
            rh = 1.0f;
        }
        switch (paintType) {
            case LINEAR_GRADIENT: {
                PaintHelper.setLinearGradient(g, shader, (LinearGradient)paint, rx, ry, rw, rh);
                break;
            }
            case RADIAL_GRADIENT: {
                PaintHelper.setRadialGradient(g, shader, (RadialGradient)paint, rx, ry, rw, rh);
                break;
            }
            case IMAGE_PATTERN: {
                PaintHelper.setImagePattern(g, shader, (ImagePattern)paint, rx, ry, rw, rh);
            }
        }
    }

    private Shader getSpecialShader(BaseGraphics g, SpecialShaderType sst) {
        boolean alphaTest = g.isAlphaTestShader();
        Shader[] shaders = alphaTest ? this.specialATShaders : this.specialShaders;
        Shader shader = shaders[sst.ordinal()];
        if (shader != null && !shader.isValid()) {
            shader.dispose();
            shader = null;
        }
        if (shader == null) {
            Object shaderName = sst.getName();
            if (alphaTest) {
                shaderName = (String)shaderName + "_AlphaTest";
            }
            shaders[sst.ordinal()] = shader = this.factory.createStockShader((String)shaderName);
        }
        return shader;
    }

    @Override
    public boolean isSuperShaderEnabled() {
        return this.state.lastShader == this.specialATShaders[SpecialShaderType.SUPER.ordinal()] || this.state.lastShader == this.specialShaders[SpecialShaderType.SUPER.ordinal()];
    }

    private void updatePerVertexColor(Paint paint, float extraAlpha) {
        if (paint != null && paint.getType() == Paint.Type.COLOR) {
            this.getVertexBuffer().setPerVertexColor((Color)paint, extraAlpha);
        } else {
            this.getVertexBuffer().setPerVertexColor(extraAlpha);
        }
    }

    @Override
    public void validateClearOp(BaseGraphics g) {
        this.checkState((BaseShaderGraphics)g, 4, null, null);
    }

    @Override
    public void validatePaintOp(BaseGraphics g, BaseTransform xform, Texture maskTex, float bx, float by, float bw, float bh) {
        this.validatePaintOp((BaseShaderGraphics)g, xform, maskTex, bx, by, bw, bh);
    }

    Shader validatePaintOp(BaseShaderGraphics g, BaseTransform xform, MaskType maskType, float bx, float by, float bw, float bh) {
        return this.validatePaintOp(g, xform, maskType, null, bx, by, bw, bh);
    }

    Shader validatePaintOp(BaseShaderGraphics g, BaseTransform xform, MaskType maskType, float bx, float by, float bw, float bh, float k1, float k2, float k3, float k4, float k5, float k6) {
        if (this.state.lastConst1 != k1 || this.state.lastConst2 != k2 || this.state.lastConst3 != k3 || this.state.lastConst4 != k4 || this.state.lastConst5 != k5 || this.state.lastConst6 != k6) {
            this.flushVertexBuffer();
            this.state.lastConst1 = k1;
            this.state.lastConst2 = k2;
            this.state.lastConst3 = k3;
            this.state.lastConst4 = k4;
            this.state.lastConst5 = k5;
            this.state.lastConst6 = k6;
        }
        return this.validatePaintOp(g, xform, maskType, null, bx, by, bw, bh);
    }

    Shader validatePaintOp(BaseShaderGraphics g, BaseTransform xform, MaskType maskType, Texture maskTex, float bx, float by, float bw, float bh, float k1, float k2, float k3, float k4, float k5, float k6) {
        if (this.state.lastConst1 != k1 || this.state.lastConst2 != k2 || this.state.lastConst3 != k3 || this.state.lastConst4 != k4 || this.state.lastConst5 != k5 || this.state.lastConst6 != k6) {
            this.flushVertexBuffer();
            this.state.lastConst1 = k1;
            this.state.lastConst2 = k2;
            this.state.lastConst3 = k3;
            this.state.lastConst4 = k4;
            this.state.lastConst5 = k5;
            this.state.lastConst6 = k6;
        }
        return this.validatePaintOp(g, xform, maskType, maskTex, bx, by, bw, bh);
    }

    Shader validatePaintOp(BaseShaderGraphics g, BaseTransform xform, Texture maskTex, float bx, float by, float bw, float bh) {
        return this.validatePaintOp(g, xform, MaskType.TEXTURE, maskTex, bx, by, bw, bh);
    }

    Shader validatePaintOp(BaseShaderGraphics g, BaseTransform xform, MaskType maskType, Texture maskTex, float bx, float by, float bw, float bh) {
        if (maskType == null) {
            throw new InternalError("maskType must be non-null");
        }
        if (this.externalShader == null) {
            Texture tex1;
            Texture tex0;
            Shader shader;
            Paint paint = g.getPaint();
            Texture paintTex = null;
            if (paint.getType().isGradient()) {
                this.flushVertexBuffer();
                paintTex = maskType.isNewPaintStyle() ? PaintHelper.getWrapGradientTexture(g) : PaintHelper.getGradientTexture(g, (Gradient)paint);
            } else if (paint.getType() == Paint.Type.IMAGE_PATTERN) {
                this.flushVertexBuffer();
                ImagePattern texPaint = (ImagePattern)paint;
                ResourceFactory rf = g.getResourceFactory();
                paintTex = rf.getCachedTexture(texPaint.getImage(), Texture.WrapMode.REPEAT);
            }
            if (this.factory.isSuperShaderAllowed() && paintTex == null && maskTex == this.factory.getGlyphTexture()) {
                shader = this.getSpecialShader(g, SpecialShaderType.SUPER);
                tex0 = this.factory.getRegionTexture();
                tex1 = maskTex;
            } else {
                if (maskTex != null) {
                    tex0 = maskTex;
                    tex1 = paintTex;
                } else {
                    tex0 = paintTex;
                    tex1 = null;
                }
                shader = this.getPaintShader(g.isAlphaTestShader(), maskType, paint);
            }
            this.checkState(g, 15, xform, shader);
            this.setTexture(0, tex0);
            this.setTexture(1, tex1);
            this.updatePaintShader(g, shader, maskType, paint, bx, by, bw, bh);
            this.updatePerVertexColor(paint, g.getExtraAlpha());
            if (paintTex != null) {
                paintTex.unlock();
            }
            return shader;
        }
        this.checkState(g, 15, xform, this.externalShader);
        this.setTexture(0, maskTex);
        this.setTexture(1, null);
        this.updatePerVertexColor(null, g.getExtraAlpha());
        return this.externalShader;
    }

    @Override
    public void validateTextureOp(BaseGraphics g, BaseTransform xform, Texture tex0, PixelFormat format) {
        this.validateTextureOp((BaseShaderGraphics)g, xform, tex0, null, format);
    }

    public Shader validateLCDOp(BaseShaderGraphics g, BaseTransform xform, Texture tex0, Texture tex1, boolean firstPass, Paint fillColor) {
        Shader shader = firstPass ? this.getSpecialShader(g, SpecialShaderType.TEXTURE_First_LCD) : this.getSpecialShader(g, SpecialShaderType.TEXTURE_SECOND_LCD);
        this.checkState(g, 15, xform, shader);
        this.setTexture(0, tex0);
        this.setTexture(1, tex1);
        this.updatePerVertexColor(fillColor, g.getExtraAlpha());
        return shader;
    }

    Shader validateTextureOp(BaseShaderGraphics g, BaseTransform xform, Texture[] textures, PixelFormat format) {
        Shader shader;
        if (format == PixelFormat.MULTI_YCbCr_420) {
            if (textures.length < 3) {
                return null;
            }
            shader = this.externalShader == null ? this.getSpecialShader(g, SpecialShaderType.TEXTURE_YV12) : this.externalShader;
        } else {
            return null;
        }
        if (null != shader) {
            this.checkState(g, 15, xform, shader);
            int texCount = Math.max(0, Math.min(textures.length, 4));
            for (int index = 0; index < texCount; ++index) {
                this.setTexture(index, textures[index]);
            }
            this.updatePerVertexColor(null, g.getExtraAlpha());
        }
        return shader;
    }

    Shader validateTextureOp(BaseShaderGraphics g, BaseTransform xform, Texture tex0, Texture tex1, PixelFormat format) {
        Shader shader;
        block6: {
            block5: {
                if (this.externalShader != null) break block5;
                switch (format) {
                    case INT_ARGB_PRE: 
                    case BYTE_BGRA_PRE: 
                    case BYTE_RGB: 
                    case BYTE_GRAY: 
                    case BYTE_APPLE_422: {
                        if (this.factory.isSuperShaderAllowed() && tex0 == this.factory.getRegionTexture() && tex1 == null) {
                            shader = this.getSpecialShader(g, SpecialShaderType.SUPER);
                            tex1 = this.factory.getGlyphTexture();
                        } else {
                            shader = this.getSpecialShader(g, SpecialShaderType.TEXTURE_RGB);
                        }
                        break block6;
                    }
                    default: {
                        throw new InternalError("Pixel format not supported: " + format);
                    }
                }
            }
            shader = this.externalShader;
        }
        this.checkState(g, 15, xform, shader);
        this.setTexture(0, tex0);
        this.setTexture(1, tex1);
        this.updatePerVertexColor(null, g.getExtraAlpha());
        return shader;
    }

    Shader validateMaskTextureOp(BaseShaderGraphics g, BaseTransform xform, Texture tex0, Texture tex1, PixelFormat format) {
        Shader shader;
        block4: {
            block3: {
                if (this.externalShader != null) break block3;
                switch (format) {
                    case INT_ARGB_PRE: 
                    case BYTE_BGRA_PRE: 
                    case BYTE_RGB: 
                    case BYTE_GRAY: 
                    case BYTE_APPLE_422: {
                        shader = this.getSpecialShader(g, SpecialShaderType.TEXTURE_MASK_RGB);
                        break block4;
                    }
                    default: {
                        throw new InternalError("Pixel format not supported: " + format);
                    }
                }
            }
            shader = this.externalShader;
        }
        this.checkState(g, 15, xform, shader);
        this.setTexture(0, tex0);
        this.setTexture(1, tex1);
        this.updatePerVertexColor(null, g.getExtraAlpha());
        return shader;
    }

    void setExternalShader(BaseShaderGraphics g, Shader shader) {
        this.flushVertexBuffer();
        if (shader != null) {
            shader.enable();
        }
        this.externalShader = shader;
    }

    private void checkState(BaseShaderGraphics g, int checkFlags, BaseTransform xform, Shader shader) {
        CompositeMode mode;
        Rectangle clip;
        this.setRenderTarget(g);
        if ((checkFlags & 1) != 0 && shader != this.state.lastShader) {
            this.flushVertexBuffer();
            shader.enable();
            this.state.lastShader = shader;
            this.state.isXformValid = false;
            checkFlags |= 2;
        }
        if (!((checkFlags & 2) == 0 || this.state.isXformValid && xform.equals(this.state.lastTransform))) {
            this.flushVertexBuffer();
            this.updateShaderTransform(shader, xform);
            this.state.lastTransform.setTransform(xform);
            this.state.isXformValid = true;
        }
        if ((checkFlags & 4) != 0 && (clip = g.getClipRectNoClone()) != this.state.lastClip) {
            this.flushVertexBuffer();
            this.updateClipRect(clip);
            this.state.lastClip = clip;
        }
        if ((checkFlags & 8) != 0 && (mode = g.getCompositeMode()) != this.state.lastComp) {
            this.flushVertexBuffer();
            this.updateCompositeMode(mode);
            this.state.lastComp = mode;
        }
    }

    private void setTexture(int texUnit, Texture tex) {
        if (tex != null) {
            tex.assertLocked();
        }
        if (tex != this.state.lastTextures[texUnit]) {
            this.flushVertexBuffer();
            this.updateTexture(texUnit, tex);
            ((State)this.state).lastTextures[texUnit] = tex;
        }
    }

    public void initLCDBuffer(int width, int height) {
        this.lcdBuffer = this.factory.createRTTexture(width, height, Texture.WrapMode.CLAMP_NOT_NEEDED);
        this.lcdBuffer.makePermanent();
    }

    public void disposeLCDBuffer() {
        if (this.lcdBuffer != null) {
            this.lcdBuffer.dispose();
            this.lcdBuffer = null;
        }
    }

    @Override
    public RTTexture getLCDBuffer() {
        return this.lcdBuffer;
    }

    public void validateLCDBuffer(RenderTarget renderTarget) {
        if (this.lcdBuffer == null || this.lcdBuffer.getPhysicalWidth() < renderTarget.getPhysicalWidth() || this.lcdBuffer.getPhysicalHeight() < renderTarget.getPhysicalHeight()) {
            this.disposeLCDBuffer();
            this.initLCDBuffer(renderTarget.getPhysicalWidth(), renderTarget.getPhysicalHeight());
        }
    }

    public abstract void blit(RTTexture var1, RTTexture var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    protected void setRenderTarget(RenderTarget target, NGCamera camera, boolean depthTest, boolean state3D) {
        if (target instanceof Texture) {
            ((Texture)((Object)target)).assertLocked();
        }
        if (this.state == null || state3D != this.state.lastState3D || target != this.state.lastRenderTarget || camera != this.state.lastCamera || depthTest != this.state.lastDepthTest) {
            this.flushVertexBuffer();
            this.state = this.updateRenderTarget(target, camera, depthTest);
            this.state.lastRenderTarget = target;
            this.state.lastCamera = camera;
            this.state.lastDepthTest = depthTest;
            this.state.isXformValid = false;
            if (state3D != this.state.lastState3D) {
                this.state.lastState3D = state3D;
                this.state.lastShader = null;
                this.state.lastConst1 = Float.NaN;
                this.state.lastConst2 = Float.NaN;
                this.state.lastConst3 = Float.NaN;
                this.state.lastConst4 = Float.NaN;
                this.state.lastConst5 = Float.NaN;
                this.state.lastConst6 = Float.NaN;
                this.state.lastComp = null;
                this.state.lastClip = null;
                for (int i = 0; i != this.state.lastTextures.length; ++i) {
                    ((State)this.state).lastTextures[i] = null;
                }
                if (state3D) {
                    this.setDeviceParametersFor3D();
                } else {
                    this.setDeviceParametersFor2D();
                }
            }
        }
    }

    @Override
    protected void releaseRenderTarget() {
        if (this.state != null) {
            this.state.lastRenderTarget = null;
            for (int i = 0; i < this.state.lastTextures.length; ++i) {
                ((State)this.state).lastTextures[i] = null;
            }
        }
    }

    public static class State {
        private Shader lastShader;
        private RenderTarget lastRenderTarget;
        private NGCamera lastCamera;
        private boolean lastDepthTest;
        private BaseTransform lastTransform = new Affine3D();
        private Rectangle lastClip;
        private CompositeMode lastComp;
        private Texture[] lastTextures = new Texture[4];
        private boolean isXformValid;
        private float lastConst1 = Float.NaN;
        private float lastConst2 = Float.NaN;
        private float lastConst3 = Float.NaN;
        private float lastConst4 = Float.NaN;
        private float lastConst5 = Float.NaN;
        private float lastConst6 = Float.NaN;
        private boolean lastState3D = false;
    }

    public static enum SpecialShaderType {
        TEXTURE_RGB("Solid_TextureRGB"),
        TEXTURE_MASK_RGB("Mask_TextureRGB"),
        TEXTURE_YV12("Solid_TextureYV12"),
        TEXTURE_First_LCD("Solid_TextureFirstPassLCD"),
        TEXTURE_SECOND_LCD("Solid_TextureSecondPassLCD"),
        SUPER("Mask_TextureSuper");

        private String name;

        private SpecialShaderType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum MaskType {
        SOLID("Solid"),
        TEXTURE("Texture"),
        ALPHA_ONE("AlphaOne", true),
        ALPHA_TEXTURE("AlphaTexture", true),
        ALPHA_TEXTURE_DIFF("AlphaTextureDifference", true),
        FILL_PGRAM("FillPgram"),
        DRAW_PGRAM("DrawPgram", FILL_PGRAM),
        FILL_CIRCLE("FillCircle"),
        DRAW_CIRCLE("DrawCircle", FILL_CIRCLE),
        FILL_ELLIPSE("FillEllipse"),
        DRAW_ELLIPSE("DrawEllipse", FILL_ELLIPSE),
        FILL_ROUNDRECT("FillRoundRect"),
        DRAW_ROUNDRECT("DrawRoundRect", FILL_ROUNDRECT),
        DRAW_SEMIROUNDRECT("DrawSemiRoundRect");

        private String name;
        private MaskType filltype;
        private boolean newPaintStyle;

        private MaskType(String name) {
            this.name = name;
        }

        private MaskType(String name, boolean newstyle) {
            this.name = name;
            this.newPaintStyle = newstyle;
        }

        private MaskType(String name, MaskType filltype) {
            this.name = name;
            this.filltype = filltype;
        }

        public String getName() {
            return this.name;
        }

        public MaskType getFillType() {
            return this.filltype;
        }

        public boolean isNewPaintStyle() {
            return this.newPaintStyle;
        }
    }
}

