/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.javafx.geom.Area;
import com.sun.javafx.geom.GeneralShapePair;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.impl.shape.ShapeUtil;
import java.util.Arrays;

public final class BasicStroke {
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int TYPE_CENTERED = 0;
    public static final int TYPE_INNER = 1;
    public static final int TYPE_OUTER = 2;
    float width;
    int type;
    int cap;
    int join;
    float miterLimit;
    float[] dash;
    float dashPhase;
    private static final int SAFE_ACCUMULATE_MASK = 91;
    private float[] tmpMiter = new float[2];
    static final float SQRT_2 = (float)Math.sqrt(2.0);

    public BasicStroke() {
        this.set(0, 1.0f, 2, 0, 10.0f);
    }

    public BasicStroke(float width, int cap, int join, float miterLimit) {
        this.set(0, width, cap, join, miterLimit);
    }

    public BasicStroke(int type, float width, int cap, int join, float miterLimit) {
        this.set(type, width, cap, join, miterLimit);
    }

    public BasicStroke(float width, int cap, int join, float miterLimit, float[] dash, float dashPhase) {
        this.set(0, width, cap, join, miterLimit);
        this.set(dash, dashPhase);
    }

    public BasicStroke(float width, int cap, int join, float miterLimit, double[] dash, float dashPhase) {
        this.set(0, width, cap, join, miterLimit);
        this.set(dash, dashPhase);
    }

    public BasicStroke(int type, float width, int cap, int join, float miterLimit, float[] dash, float dashPhase) {
        this.set(type, width, cap, join, miterLimit);
        this.set(dash, dashPhase);
    }

    public BasicStroke(int type, float width, int cap, int join, float miterLimit, double[] dash, float dashPhase) {
        this.set(type, width, cap, join, miterLimit);
        this.set(dash, dashPhase);
    }

    public void set(int type, float width, int cap, int join, float miterLimit) {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("illegal type");
        }
        if (width < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        if (cap != 0 && cap != 1 && cap != 2) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        if (join == 0) {
            if (miterLimit < 1.0f) {
                throw new IllegalArgumentException("miter limit < 1");
            }
        } else if (join != 1 && join != 2) {
            throw new IllegalArgumentException("illegal line join value");
        }
        this.type = type;
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.miterLimit = miterLimit;
    }

    public void set(float[] dash, float dashPhase) {
        if (dash != null) {
            boolean allzero = true;
            for (int i = 0; i < dash.length; ++i) {
                float d = dash[i];
                if ((double)d > 0.0) {
                    allzero = false;
                    continue;
                }
                if (!((double)d < 0.0)) continue;
                throw new IllegalArgumentException("negative dash length");
            }
            if (allzero) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        this.dash = dash;
        this.dashPhase = dashPhase;
    }

    public void set(double[] dash, float dashPhase) {
        if (dash != null) {
            float[] newdashes = new float[dash.length];
            boolean allzero = true;
            for (int i = 0; i < dash.length; ++i) {
                float d = (float)dash[i];
                if ((double)d > 0.0) {
                    allzero = false;
                } else if ((double)d < 0.0) {
                    throw new IllegalArgumentException("negative dash length");
                }
                newdashes[i] = d;
            }
            if (allzero) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
            this.dash = newdashes;
        } else {
            this.dash = null;
        }
        this.dashPhase = dashPhase;
    }

    public int getType() {
        return this.type;
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public boolean isDashed() {
        return this.dash != null;
    }

    public float[] getDashArray() {
        return this.dash;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public Shape createStrokedShape(Shape s) {
        Shape ret = s instanceof RoundRectangle2D ? this.strokeRoundRectangle((RoundRectangle2D)s) : null;
        if (ret != null) {
            return ret;
        }
        ret = this.createCenteredStrokedShape(s);
        if (this.type == 1) {
            ret = this.makeIntersectedShape(ret, s);
        } else if (this.type == 2) {
            ret = this.makeSubtractedShape(ret, s);
        }
        return ret;
    }

    private boolean isCW(float dx1, float dy1, float dx2, float dy2) {
        return dx1 * dy2 <= dy1 * dx2;
    }

    private void computeOffset(float lx, float ly, float w, float[] m, int off) {
        float len = (float)Math.sqrt(lx * lx + ly * ly);
        if (len == 0.0f) {
            m[off + 1] = 0.0f;
            m[off + 0] = 0.0f;
        } else {
            m[off + 0] = ly * w / len;
            m[off + 1] = -(lx * w) / len;
        }
    }

    private void computeMiter(float x0, float y0, float x1, float y1, float x0p, float y0p, float x1p, float y1p, float[] m, int off) {
        float x10 = x1 - x0;
        float y10 = y1 - y0;
        float x10p = x1p - x0p;
        float y10p = y1p - y0p;
        float den = x10 * y10p - x10p * y10;
        float t = x10p * (y0 - y0p) - y10p * (x0 - x0p);
        m[off++] = x0 + (t /= den) * x10;
        m[off] = y0 + t * y10;
    }

    private void accumulateQuad(float[] bbox, int off, float v0, float vc, float v1, float w) {
        float t;
        float num = v0 - vc;
        float den = v1 - vc + num;
        if (den != 0.0f && (t = num / den) > 0.0f && t < 1.0f) {
            float u = 1.0f - t;
            float v = v0 * u * u + 2.0f * vc * t * u + v1 * t * t;
            if (bbox[off] > v - w) {
                bbox[off] = v - w;
            }
            if (bbox[off + 2] < v + w) {
                bbox[off + 2] = v + w;
            }
        }
    }

    private void accumulateCubic(float[] bbox, int off, float t, float v0, float vc0, float vc1, float v1, float w) {
        if (t > 0.0f && t < 1.0f) {
            float u = 1.0f - t;
            float v = v0 * u * u * u + 3.0f * vc0 * t * u * u + 3.0f * vc1 * t * t * u + v1 * t * t * t;
            if (bbox[off] > v - w) {
                bbox[off] = v - w;
            }
            if (bbox[off + 2] < v + w) {
                bbox[off + 2] = v + w;
            }
        }
    }

    private void accumulateCubic(float[] bbox, int off, float v0, float vc0, float vc1, float v1, float w) {
        float c = vc0 - v0;
        float b = 2.0f * (vc1 - vc0 - c);
        float a = v1 - vc1 - b - c;
        if (a == 0.0f) {
            if (b == 0.0f) {
                return;
            }
            this.accumulateCubic(bbox, off, -c / b, v0, vc0, vc1, v1, w);
        } else {
            float d = b * b - 4.0f * a * c;
            if (d < 0.0f) {
                return;
            }
            d = (float)Math.sqrt(d);
            if (b < 0.0f) {
                d = -d;
            }
            float q = (b + d) / -2.0f;
            this.accumulateCubic(bbox, off, q / a, v0, vc0, vc1, v1, w);
            if (q != 0.0f) {
                this.accumulateCubic(bbox, off, c / q, v0, vc0, vc1, v1, w);
            }
        }
    }

    public void accumulateShapeBounds(float[] bbox, Shape shape, BaseTransform tx) {
        if (this.type == 1) {
            Shape.accumulate(bbox, shape, tx);
            return;
        }
        if ((tx.getType() & 0xFFFFFFA4) != 0) {
            Shape.accumulate(bbox, this.createStrokedShape(shape), tx);
            return;
        }
        PathIterator pi = shape.getPathIterator(tx);
        boolean lastSegmentMove = true;
        float[] coords = new float[6];
        float w = this.type == 0 ? this.getLineWidth() / 2.0f : this.getLineWidth();
        w = (float)((double)w * Math.hypot(tx.getMxx(), tx.getMyx()));
        float sx = 0.0f;
        float sy = 0.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float sdx = 0.0f;
        float sdy = 0.0f;
        float pdx = 0.0f;
        float pdy = 0.0f;
        float[] o = new float[4];
        float pox = 0.0f;
        float poy = 0.0f;
        float sox = 0.0f;
        float soy = 0.0f;
        while (!pi.isDone()) {
            int cur = pi.currentSegment(coords);
            switch (cur) {
                case 0: {
                    if (!lastSegmentMove) {
                        this.accumulateCap(pdx, pdy, x0, y0, pox, poy, bbox, w);
                        this.accumulateCap(-sdx, -sdy, sx, sy, -sox, -soy, bbox, w);
                    }
                    x0 = sx = coords[0];
                    y0 = sy = coords[1];
                    break;
                }
                case 1: {
                    float x1 = coords[0];
                    float y1 = coords[1];
                    float dx = x1 - x0;
                    float dy = y1 - y0;
                    if (dx == 0.0f && dy == 0.0f) {
                        dx = 1.0f;
                    }
                    this.computeOffset(dx, dy, w, o, 0);
                    if (!lastSegmentMove) {
                        this.accumulateJoin(pdx, pdy, dx, dy, x0, y0, pox, poy, o[0], o[1], bbox, w);
                    }
                    x0 = x1;
                    y0 = y1;
                    pdx = dx;
                    pdy = dy;
                    pox = o[0];
                    poy = o[1];
                    if (!lastSegmentMove) break;
                    sdx = pdx;
                    sdy = pdy;
                    sox = pox;
                    soy = poy;
                    break;
                }
                case 2: {
                    float x1 = coords[2];
                    float y1 = coords[3];
                    float dx = coords[0] - x0;
                    float dy = coords[1] - y0;
                    this.computeOffset(dx, dy, w, o, 0);
                    if (!lastSegmentMove) {
                        this.accumulateJoin(pdx, pdy, dx, dy, x0, y0, pox, poy, o[0], o[1], bbox, w);
                    }
                    if (bbox[0] > coords[0] - w || bbox[2] < coords[0] + w) {
                        this.accumulateQuad(bbox, 0, x0, coords[0], x1, w);
                    }
                    if (bbox[1] > coords[1] - w || bbox[3] < coords[1] + w) {
                        this.accumulateQuad(bbox, 1, y0, coords[1], y1, w);
                    }
                    x0 = x1;
                    y0 = y1;
                    if (lastSegmentMove) {
                        sdx = dx;
                        sdy = dy;
                        sox = o[0];
                        soy = o[1];
                    }
                    pdx = x1 - coords[0];
                    pdy = y1 - coords[1];
                    this.computeOffset(pdx, pdy, w, o, 0);
                    pox = o[0];
                    poy = o[1];
                    break;
                }
                case 3: {
                    float x1 = coords[4];
                    float y1 = coords[5];
                    float dx = coords[0] - x0;
                    float dy = coords[1] - y0;
                    this.computeOffset(dx, dy, w, o, 0);
                    if (!lastSegmentMove) {
                        this.accumulateJoin(pdx, pdy, dx, dy, x0, y0, pox, poy, o[0], o[1], bbox, w);
                    }
                    if (bbox[0] > coords[0] - w || bbox[2] < coords[0] + w || bbox[0] > coords[2] - w || bbox[2] < coords[2] + w) {
                        this.accumulateCubic(bbox, 0, x0, coords[0], coords[2], x1, w);
                    }
                    if (bbox[1] > coords[1] - w || bbox[3] < coords[1] + w || bbox[1] > coords[3] - w || bbox[3] < coords[3] + w) {
                        this.accumulateCubic(bbox, 1, y0, coords[1], coords[3], y1, w);
                    }
                    x0 = x1;
                    y0 = y1;
                    if (lastSegmentMove) {
                        sdx = dx;
                        sdy = dy;
                        sox = o[0];
                        soy = o[1];
                    }
                    pdx = x1 - coords[2];
                    pdy = y1 - coords[3];
                    this.computeOffset(pdx, pdy, w, o, 0);
                    pox = o[0];
                    poy = o[1];
                    break;
                }
                case 4: {
                    float dx = sx - x0;
                    float dy = sy - y0;
                    float x1 = sx;
                    float y1 = sy;
                    if (!lastSegmentMove) {
                        this.computeOffset(sdx, sdy, w, o, 2);
                        if (dx == 0.0f && dy == 0.0f) {
                            this.accumulateJoin(pdx, pdy, sdx, sdy, sx, sy, pox, poy, o[2], o[3], bbox, w);
                        } else {
                            this.computeOffset(dx, dy, w, o, 0);
                            this.accumulateJoin(pdx, pdy, dx, dy, x0, y0, pox, poy, o[0], o[1], bbox, w);
                            this.accumulateJoin(dx, dy, sdx, sdy, x1, y1, o[0], o[1], o[2], o[3], bbox, w);
                        }
                    }
                    x0 = x1;
                    y0 = y1;
                }
            }
            lastSegmentMove = cur == 0 || cur == 4;
            pi.next();
        }
        if (!lastSegmentMove) {
            this.accumulateCap(pdx, pdy, x0, y0, pox, poy, bbox, w);
            this.accumulateCap(-sdx, -sdy, sx, sy, -sox, -soy, bbox, w);
        }
    }

    private void accumulate(float o0, float o1, float o2, float o3, float[] bbox) {
        if (o0 <= o2) {
            if (o0 < bbox[0]) {
                bbox[0] = o0;
            }
            if (o2 > bbox[2]) {
                bbox[2] = o2;
            }
        } else {
            if (o2 < bbox[0]) {
                bbox[0] = o2;
            }
            if (o0 > bbox[2]) {
                bbox[2] = o0;
            }
        }
        if (o1 <= o3) {
            if (o1 < bbox[1]) {
                bbox[1] = o1;
            }
            if (o3 > bbox[3]) {
                bbox[3] = o3;
            }
        } else {
            if (o3 < bbox[1]) {
                bbox[1] = o3;
            }
            if (o1 > bbox[3]) {
                bbox[3] = o1;
            }
        }
    }

    private void accumulateOrdered(float o0, float o1, float o2, float o3, float[] bbox) {
        if (o0 < bbox[0]) {
            bbox[0] = o0;
        }
        if (o2 > bbox[2]) {
            bbox[2] = o2;
        }
        if (o1 < bbox[1]) {
            bbox[1] = o1;
        }
        if (o3 > bbox[3]) {
            bbox[3] = o3;
        }
    }

    private void accumulateJoin(float pdx, float pdy, float dx, float dy, float x0, float y0, float pox, float poy, float ox, float oy, float[] bbox, float w) {
        if (this.join == 2) {
            this.accumulateBevel(x0, y0, pox, poy, ox, oy, bbox);
        } else if (this.join == 0) {
            this.accumulateMiter(pdx, pdy, dx, dy, pox, poy, ox, oy, x0, y0, bbox, w);
        } else {
            this.accumulateOrdered(x0 - w, y0 - w, x0 + w, y0 + w, bbox);
        }
    }

    private void accumulateCap(float dx, float dy, float x0, float y0, float ox, float oy, float[] bbox, float w) {
        if (this.cap == 2) {
            this.accumulate(x0 + ox - oy, y0 + oy + ox, x0 - ox - oy, y0 - oy + ox, bbox);
        } else if (this.cap == 0) {
            this.accumulate(x0 + ox, y0 + oy, x0 - ox, y0 - oy, bbox);
        } else {
            this.accumulateOrdered(x0 - w, y0 - w, x0 + w, y0 + w, bbox);
        }
    }

    private void accumulateMiter(float pdx, float pdy, float dx, float dy, float pox, float poy, float ox, float oy, float x0, float y0, float[] bbox, float w) {
        this.accumulateBevel(x0, y0, pox, poy, ox, oy, bbox);
        boolean cw = this.isCW(pdx, pdy, dx, dy);
        if (cw) {
            pox = -pox;
            poy = -poy;
            ox = -ox;
            oy = -oy;
        }
        this.computeMiter(x0 - pdx + pox, y0 - pdy + poy, x0 + pox, y0 + poy, x0 + dx + ox, y0 + dy + oy, x0 + ox, y0 + oy, this.tmpMiter, 0);
        float lenSq = (this.tmpMiter[0] - x0) * (this.tmpMiter[0] - x0) + (this.tmpMiter[1] - y0) * (this.tmpMiter[1] - y0);
        float miterLimitWidth = this.miterLimit * w;
        if (lenSq < miterLimitWidth * miterLimitWidth) {
            this.accumulateOrdered(this.tmpMiter[0], this.tmpMiter[1], this.tmpMiter[0], this.tmpMiter[1], bbox);
        }
    }

    private void accumulateBevel(float x0, float y0, float pox, float poy, float ox, float oy, float[] bbox) {
        this.accumulate(x0 + pox, y0 + poy, x0 - pox, y0 - poy, bbox);
        this.accumulate(x0 + ox, y0 + oy, x0 - ox, y0 - oy, bbox);
    }

    public Shape createCenteredStrokedShape(Shape s) {
        return ShapeUtil.createCenteredStrokedShape(s, this);
    }

    Shape strokeRoundRectangle(RoundRectangle2D rr) {
        Shape outer;
        float id;
        float od;
        int j;
        if (rr.width < 0.0f || rr.height < 0.0f) {
            return new Path2D();
        }
        if (this.isDashed()) {
            return null;
        }
        float aw = rr.arcWidth;
        float ah = rr.arcHeight;
        if (aw <= 0.0f || ah <= 0.0f) {
            ah = 0.0f;
            aw = 0.0f;
            if (this.type == 1) {
                j = 0;
            } else {
                j = this.join;
                if (j == 0 && this.miterLimit < SQRT_2) {
                    j = 2;
                }
            }
        } else {
            if (aw < ah * 0.9f || ah < aw * 0.9f) {
                return null;
            }
            j = 1;
        }
        if (this.type == 1) {
            od = 0.0f;
            id = this.width;
        } else if (this.type == 2) {
            od = this.width;
            id = 0.0f;
        } else {
            od = id = this.width / 2.0f;
        }
        switch (j) {
            case 0: {
                outer = new RoundRectangle2D(rr.x - od, rr.y - od, rr.width + od * 2.0f, rr.height + od * 2.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                outer = BasicStroke.makeBeveledRect(rr.x, rr.y, rr.width, rr.height, od);
                break;
            }
            case 1: {
                outer = new RoundRectangle2D(rr.x - od, rr.y - od, rr.width + od * 2.0f, rr.height + od * 2.0f, aw + od * 2.0f, ah + od * 2.0f);
                break;
            }
            default: {
                throw new InternalError("Unrecognized line join style");
            }
        }
        if (rr.width <= id * 2.0f || rr.height <= id * 2.0f) {
            return outer;
        }
        ah -= id * 2.0f;
        if ((aw -= id * 2.0f) <= 0.0f || ah <= 0.0f) {
            ah = 0.0f;
            aw = 0.0f;
        }
        RoundRectangle2D inner = new RoundRectangle2D(rr.x + id, rr.y + id, rr.width - id * 2.0f, rr.height - id * 2.0f, aw, ah);
        Path2D p2d = outer instanceof Path2D ? (Path2D)outer : new Path2D(outer);
        p2d.setWindingRule(0);
        p2d.append(inner, false);
        return p2d;
    }

    static Shape makeBeveledRect(float rx, float ry, float rw, float rh, float d) {
        float rx0 = rx;
        float ry0 = ry;
        float rx1 = rx + rw;
        float ry1 = ry + rh;
        Path2D p = new Path2D();
        p.moveTo(rx0, ry0 - d);
        p.lineTo(rx1, ry0 - d);
        p.lineTo(rx1 + d, ry0);
        p.lineTo(rx1 + d, ry1);
        p.lineTo(rx1, ry1 + d);
        p.lineTo(rx0, ry1 + d);
        p.lineTo(rx0 - d, ry1);
        p.lineTo(rx0 - d, ry0);
        p.closePath();
        return p;
    }

    protected Shape makeIntersectedShape(Shape outer, Shape inner) {
        return new CAGShapePair(outer, inner, 4);
    }

    protected Shape makeSubtractedShape(Shape outer, Shape inner) {
        return new CAGShapePair(outer, inner, 1);
    }

    public int hashCode() {
        int hash = Float.floatToIntBits(this.width);
        hash = hash * 31 + this.join;
        hash = hash * 31 + this.cap;
        hash = hash * 31 + Float.floatToIntBits(this.miterLimit);
        if (this.dash != null) {
            hash = hash * 31 + Float.floatToIntBits(this.dashPhase);
            for (int i = 0; i < this.dash.length; ++i) {
                hash = hash * 31 + Float.floatToIntBits(this.dash[i]);
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicStroke)) {
            return false;
        }
        BasicStroke bs = (BasicStroke)obj;
        if (this.width != bs.width) {
            return false;
        }
        if (this.join != bs.join) {
            return false;
        }
        if (this.cap != bs.cap) {
            return false;
        }
        if (this.miterLimit != bs.miterLimit) {
            return false;
        }
        if (this.dash != null) {
            if (this.dashPhase != bs.dashPhase) {
                return false;
            }
            if (!Arrays.equals(this.dash, bs.dash)) {
                return false;
            }
        } else if (bs.dash != null) {
            return false;
        }
        return true;
    }

    public BasicStroke copy() {
        return new BasicStroke(this.type, this.width, this.cap, this.join, this.miterLimit, this.dash, this.dashPhase);
    }

    static class CAGShapePair
    extends GeneralShapePair {
        private Shape cagshape;

        public CAGShapePair(Shape outer, Shape inner, int type) {
            super(outer, inner, type);
        }

        @Override
        public PathIterator getPathIterator(BaseTransform tx) {
            if (this.cagshape == null) {
                Area o = new Area(this.getOuterShape());
                Area i = new Area(this.getInnerShape());
                if (this.getCombinationType() == 4) {
                    o.intersect(i);
                } else {
                    o.subtract(i);
                }
                this.cagshape = o;
            }
            return this.cagshape.getPathIterator(tx);
        }
    }
}

