/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

final class OffHeapArray {
    static final Unsafe UNSAFE = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            Unsafe ref = null;
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                ref = (Unsafe)field.get(null);
            }
            catch (Exception e) {
                throw new InternalError("Unable to get sun.misc.Unsafe instance", e);
            }
            return ref;
        }
    });
    static final int SIZE_INT = Unsafe.ARRAY_INT_INDEX_SCALE;
    long address;
    long length;
    int used;

    OffHeapArray(Object parent, long len) {
        this.address = UNSAFE.allocateMemory(len);
        this.length = len;
        this.used = 0;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.allocateMemory =   " + len + " to addr = " + this.address);
        }
        MarlinUtils.getCleaner().register(parent, () -> this.free());
    }

    void resize(long len) {
        this.address = UNSAFE.reallocateMemory(this.address, len);
        this.length = len;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.reallocateMemory = " + len + " to addr = " + this.address);
        }
    }

    void free() {
        UNSAFE.freeMemory(this.address);
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.freeMemory =       " + this.length + " at addr = " + this.address);
        }
        this.address = 0L;
    }

    void fill(byte val) {
        UNSAFE.setMemory(this.address, this.length, val);
    }
}

