/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.FloatMath;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinAlphaConsumer;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.OffHeapArray;
import com.sun.prism.impl.shape.MaskData;
import java.nio.ByteBuffer;
import java.util.Arrays;
import sun.misc.Unsafe;

public final class MaskMarlinAlphaConsumer
implements MarlinAlphaConsumer {
    int x;
    int y;
    int width;
    int height;
    final byte[] alphas;
    final ByteBuffer alphabuffer;
    final MaskData maskdata = new MaskData();
    boolean useFastFill;
    int fastFillThreshold;
    OffHeapArray ALPHA_MAP_USED = null;
    static final byte[] ALPHA_MAP;
    static final OffHeapArray ALPHA_MAP_UNSAFE;
    static final byte[] ALPHA_MAP_NO_AA;
    static final OffHeapArray ALPHA_MAP_UNSAFE_NO_AA;

    public MaskMarlinAlphaConsumer(int alphalen) {
        this.alphas = new byte[alphalen];
        this.alphabuffer = ByteBuffer.wrap(this.alphas);
    }

    public void setBoundsNoClone(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.maskdata.update(this.alphabuffer, x, y, w, h);
        boolean bl = this.useFastFill = w >= 32;
        if (this.useFastFill) {
            this.fastFillThreshold = w >= 128 ? w >> 1 : w >> 2;
        }
    }

    @Override
    public int getOriginX() {
        return this.x;
    }

    @Override
    public int getOriginY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getAlphaLength() {
        return this.alphas.length;
    }

    public MaskData getMaskData() {
        return this.maskdata;
    }

    @Override
    public void setMaxAlpha(int maxalpha) {
        this.ALPHA_MAP_USED = maxalpha == 1 ? ALPHA_MAP_UNSAFE_NO_AA : ALPHA_MAP_UNSAFE;
    }

    private static byte[] buildAlphaMap(int maxalpha) {
        byte[] alMap = new byte[maxalpha << 1];
        int halfmaxalpha = maxalpha >> 2;
        for (int i = 0; i <= maxalpha; ++i) {
            alMap[i] = (byte)((i * 255 + halfmaxalpha) / maxalpha);
        }
        return alMap;
    }

    @Override
    public boolean supportBlockFlags() {
        return true;
    }

    @Override
    public void clearAlphas(int pix_y) {
        int w = this.width;
        int off = (pix_y - this.y) * w;
        Arrays.fill(this.alphas, off, off + w, (byte)0);
    }

    @Override
    public void setAndClearRelativeAlphas(int[] alphaDeltas, int pix_y, int pix_from, int pix_to) {
        boolean fast;
        byte[] out = this.alphas;
        int w = this.width;
        int off = (pix_y - this.y) * w;
        Unsafe _unsafe = OffHeapArray.UNSAFE;
        long addr_alpha = this.ALPHA_MAP_USED.address;
        int from = pix_from - this.x;
        int to = pix_to - this.x;
        int ato = Math.min(to, this.width);
        boolean bl = fast = this.useFastFill && ato - from < this.fastFillThreshold;
        if (fast) {
            Arrays.fill(out, off, off + w, (byte)0);
            int curAlpha = 0;
            for (int i = from; i < ato; ++i) {
                out[off + i] = _unsafe.getByte(addr_alpha + (long)(curAlpha += alphaDeltas[i]));
            }
        } else {
            int i;
            for (i = 0; i < from; ++i) {
                out[off + i] = 0;
            }
            int curAlpha = 0;
            while (i < ato) {
                out[off + i] = _unsafe.getByte(addr_alpha + (long)(curAlpha += alphaDeltas[i]));
                ++i;
            }
            while (i < w) {
                out[off + i] = 0;
                ++i;
            }
        }
        IntArrayCache.fill(alphaDeltas, from, to + 1, 0);
    }

    @Override
    public void setAndClearRelativeAlphas(int[] blkFlags, int[] alphaDeltas, int pix_y, int pix_from, int pix_to) {
        byte[] out = this.alphas;
        int w = this.width;
        int off = (pix_y - this.y) * w;
        Unsafe _unsafe = OffHeapArray.UNSAFE;
        long addr_alpha = this.ALPHA_MAP_USED.address;
        int from = pix_from - this.x;
        int to = pix_to - this.x;
        int ato = Math.min(to, this.width);
        boolean fast = this.useFastFill && ato - from < this.fastFillThreshold;
        int _BLK_SIZE_LG = MarlinConst.BLOCK_SIZE_LG;
        int blkW = from >> _BLK_SIZE_LG;
        int blkE = (ato >> _BLK_SIZE_LG) + 1;
        blkFlags[blkE] = 0;
        int curAlpha = 0;
        int _MAX_VALUE = Integer.MAX_VALUE;
        int last_t0 = Integer.MAX_VALUE;
        if (fast) {
            byte val;
            int i = from;
            Arrays.fill(out, off, off + w, (byte)0);
            for (int t = blkW; t <= blkE; ++t) {
                if (blkFlags[t] != 0) {
                    blkFlags[t] = 0;
                    if (last_t0 != Integer.MAX_VALUE) continue;
                    last_t0 = t;
                    continue;
                }
                if (last_t0 == Integer.MAX_VALUE) continue;
                int blk_x0 = FloatMath.max(last_t0 << _BLK_SIZE_LG, from);
                last_t0 = Integer.MAX_VALUE;
                int blk_x1 = FloatMath.min((t << _BLK_SIZE_LG) + 1, ato);
                for (int cx = blk_x0; cx < blk_x1; ++cx) {
                    int delta = alphaDeltas[cx];
                    if (delta == 0) continue;
                    alphaDeltas[cx] = 0;
                    if (cx != i) {
                        if (curAlpha == 0) {
                            i = cx;
                        } else {
                            val = _unsafe.getByte(addr_alpha + (long)curAlpha);
                            do {
                                out[off + i] = val;
                            } while (++i < cx);
                        }
                    }
                    curAlpha += delta;
                }
            }
            if (curAlpha != 0) {
                val = _unsafe.getByte(addr_alpha + (long)curAlpha);
                while (i < ato) {
                    out[off + i] = val;
                    ++i;
                }
            }
        } else {
            byte val;
            int i;
            for (i = 0; i < from; ++i) {
                out[off + i] = 0;
            }
            for (int t = blkW; t <= blkE; ++t) {
                if (blkFlags[t] != 0) {
                    blkFlags[t] = 0;
                    if (last_t0 != Integer.MAX_VALUE) continue;
                    last_t0 = t;
                    continue;
                }
                if (last_t0 == Integer.MAX_VALUE) continue;
                int blk_x0 = FloatMath.max(last_t0 << _BLK_SIZE_LG, from);
                last_t0 = Integer.MAX_VALUE;
                int blk_x1 = FloatMath.min((t << _BLK_SIZE_LG) + 1, ato);
                for (int cx = blk_x0; cx < blk_x1; ++cx) {
                    int delta = alphaDeltas[cx];
                    if (delta == 0) continue;
                    alphaDeltas[cx] = 0;
                    if (cx != i) {
                        val = _unsafe.getByte(addr_alpha + (long)curAlpha);
                        do {
                            out[off + i] = val;
                        } while (++i < cx);
                    }
                    curAlpha += delta;
                }
            }
            if (curAlpha != 0) {
                val = _unsafe.getByte(addr_alpha + (long)curAlpha);
                while (i < ato) {
                    out[off + i] = val;
                    ++i;
                }
            }
            while (i < w) {
                out[off + i] = 0;
                ++i;
            }
        }
        alphaDeltas[ato] = 0;
        if (MarlinConst.DO_CHECKS) {
            IntArrayCache.check(blkFlags, blkW, blkE, 0);
            IntArrayCache.check(alphaDeltas, from, to + 1, 0);
        }
    }

    static {
        Unsafe _unsafe = OffHeapArray.UNSAFE;
        byte[] _ALPHA_MAP = MaskMarlinAlphaConsumer.buildAlphaMap(MarlinConst.MAX_AA_ALPHA);
        ALPHA_MAP = _ALPHA_MAP;
        ALPHA_MAP_UNSAFE = new OffHeapArray(ALPHA_MAP, ALPHA_MAP.length);
        long addr = MaskMarlinAlphaConsumer.ALPHA_MAP_UNSAFE.address;
        for (int i = 0; i < _ALPHA_MAP.length; ++i) {
            _unsafe.putByte(addr + (long)i, _ALPHA_MAP[i]);
        }
        byte[] _ALPHA_MAP_NO_AA = MaskMarlinAlphaConsumer.buildAlphaMap(1);
        ALPHA_MAP_NO_AA = _ALPHA_MAP_NO_AA;
        ALPHA_MAP_UNSAFE_NO_AA = new OffHeapArray(ALPHA_MAP_NO_AA, ALPHA_MAP_NO_AA.length);
        addr = MaskMarlinAlphaConsumer.ALPHA_MAP_UNSAFE_NO_AA.address;
        for (int i = 0; i < _ALPHA_MAP_NO_AA.length; ++i) {
            _unsafe.putByte(addr + (long)i, _ALPHA_MAP_NO_AA[i]);
        }
    }
}

